package com.bcxin.ins.dao.preservation;

import com.bcxin.ins.entity.policy_core.InsOrderReconciliation;
import com.bcxin.ins.entity.policy_core.InsPreservationRecord;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import com.bcxin.mybatisplus.plugins.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
 * <b>保全申请单表</b>
 */
@MyBatisDao
public interface InsPreservationRecordAPIDao extends BaseMapper<InsPreservationRecord> {

    Map<String,String> sumRecordNumAndPremiumByEx(String policyNo);
    int countRecordByEx(String policyNo);

    /**
     * <b> 统计待审核批单条数 </b>
     * @author ZXF
     * @create 2021/05/10 0010 9:44
     * @version
     * @注意事项 </b>
     */
    int countDSHByPolicyNo(String policyNo);

    /**
     * <b>根据前台用户id跟保全条件查询保全申请单表并进行分页 </b>
     *
     * @param page
     * @param userId
     * @param revise_status
     * @param start_time
     * @param end_time
     * @param keyword
     * @return
     * @author ZXF
     * @date 2017年1月9日 下午8:21:24
     * @注意事项 </b>
     * <b>
     */
    List<InsPreservationRecord> findInsPreservationRecordByKeyword(Page<InsPreservationRecord> page, @Param("userId") Long userId, @Param("revise_status") String revise_status, @Param("start_time") String start_time, @Param("end_time") String end_time, @Param("keyword") String keyword);

    /**
     * <b>根据保全申请单id查询InsPreservationRecordVo </b>
     *
     * @param oid
     * @return
     * @author ZXF
     * @date 2017年1月9日 下午8:21:24
     * @注意事项 </b>
     * <b>
     */
    public InsPreservationRecordVo findInsPreservationRecordVoById( @Param("oid") Long oid );

    public int saveRevisePath( @Param("record_id") Long record_id, @Param("path") String path);

    /**
     * <b>根据保单号查询相关保全申请单最后‘已审核’状态的申请单 </b>
     * @param policyID
     * @return
     * @author ZXF
     * @date 2017年1月9日 下午8:21:24
     * @注意事项 </b>
     * <b>
     */
    public List<InsPreservationRecord> findInsPreservationRecordByPolicyID(@Param("policyID") Long policyID);
    public List<InsPreservationRecord> findNotResultRecord(@Param("day") String day);

    public List<InsPreservationRecordVo> findInsPreservationRecordVoByPayId(Page<InsPreservationRecordVo> page, @Param("payId") Long payId, @Param("keyword") String keyword);

    public List<InsPreservationRecord> findInsPreservationRecordByStatusAndTime();
    public List<String> findInsPreservationRecordIdsByStatusAndTime();

    int updateStatusById(@Param("status") String status,@Param("list") List<String> list);

    /**
     * 根据订单id及保全申请单状态查询对应保全申请单id列表
     * @param policyId
     * @param status
     * @return
     */
    public List<String> selectRecordIdByPolicyIdAndStatus(@Param("policyId") Long policyId, @Param("status") String status, @Param("resType") String resType);

    /**
     * <b> 根据保单号获取最后一个批单号 </b>
     * @author ZXF
     * @create 2023/08/17 0017 13:23
     * @version
     * @注意事项 </b>
     */
    public String getLastPDNoByPolicyNo(@Param("policyNo") String policyNo);
    /**
     * <b> 根据批单号查询批单记录是否存在 </b>
     * @author ZXF
     * @create 2023/08/17 0017 13:23
     * @version
     * @注意事项 </b>
     */
    public int selectRecordByPdNo(@Param("pdNo") String pdNo);

    /**
     * 根据外部平台标识查询对应的保全申请单
     * @param type
     * @return
     */
    public List<String> selectRecordIdByWebType(@Param("type") String type);

    /**
     * <b> 设置保全单推送标识 </b>
     * @param is_push 标记:1.已推送
     * @author ZXF
     * @create 2019/12/23 0023 16:01
     * @version
     * @注意事项 </b>
     */
    public int updateIsPushById(@Param("record_id") Long record_id, @Param("is_push") Integer is_push);

    /**
     * <b> 根据保全id修改批单号 </b>
     * @author ZXF
     * @create 2020/01/07 0007 17:38
     * @version
     * @注意事项 </b>
     */
    public int updateBatchNumber(@Param("record_id") String record_id, @Param("batch_number") String batch_number);

    public int updateRecordFail(@Param("record_id") String record_id, @Param("status") String status, @Param("remark") String remark);

    /**
     * <b> 根据保全id修改批单状态为废弃 </b>
     * @author ZXF
     * @create 2020/01/07 0007 17:38
     * @version
     * @注意事项 </b>
     */
    public int deleteRecord(@Param("record_id") String record_id);

    /**
     * <b> 保存同步业务支撑后台返回的id </b>
     * @author ZXF
     * @create 2020/02/26 0026 13:59
     * @version
     * @注意事项 </b>
     */
    public int saveYWZCId(@Param("record_id") String record_id, @Param("record_zc_id") String record_zc_id);

    String getRecordByResultId(@Param("result_id") String result_id);

    List<String> findRecordIdsByPayTime(@Param("yesterday") String yesterday);
    int batchOrderReconciliation(@Param("list") List<InsOrderReconciliation> list);
}
