package com.bcxin.ins.dao.preservation;

import com.bcxin.ins.entity.policy_core.InsPreservationPay;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.InsPreservationPayVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import com.bcxin.mybatisplus.plugins.Page;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * <b>保全缴费表业务 </b>
 *
 */
@MyBatisDao
public interface InsPreservationPayAPIDao extends BaseMapper<InsPreservationPay> {

    /**
     * <b>根据前台用户id跟保全缴费条件查询保全缴费表并进行分页 </b>
     *
     * @param page 分页
     * @param userId 用户id
     * @param pay_status 批改状态
     * @param start_time 结算开始时间
     * @param end_time 结算最后时间
     * @param keyword 关键字
     * @return
     * @author ZXF
     * @date 2017年8月3日 下午17:19:24
     * @注意事项 </b>
     * <b>
     */
    List<InsPreservationPay> findInsPreservationPayByKeyword(Page<InsPreservationPay> page, @Param("userId") Long userId, @Param("pay_status") String pay_status, @Param("start_time") String start_time, @Param("end_time") String end_time, @Param("keyword") String keyword);

    /**
     * <b>根据前台用户id跟保全缴费条件查询保全缴费表并进行分页(同上方法，返回vo) </b>
     *
     * @param page 分页
     * @param userId 用户id
     * @param pay_status 批改状态
     * @param start_time 结算开始时间
     * @param end_time 结算最后时间
     * @param keyword 关键字
     * @return
     * @author ZXF
     * @date 2017年8月3日 下午17:19:24
     * @注意事项 </b>
     * <b>
     */
    List<InsPreservationPayVo> findInsPreservationPayVoByKeyword(Page<InsPreservationPayVo> page, @Param("userId") Long userId, @Param("pay_status") String pay_status, @Param("start_time") String start_time, @Param("end_time") String end_time, @Param("keyword") String keyword);

    List<InsPreservationPay> findInsPreservationBillByKeyword(Page<InsPreservationPay> page, @Param("userId") Long userId, @Param("pay_status") String pay_status, @Param("start_time") String start_time, @Param("end_time") String end_time, @Param("keyword") String keyword);

    List<InsPreservationPayVo> findInsPreservationBillVoByKeyword(Page<InsPreservationPayVo> page, @Param("userId") Long userId, @Param("pay_status") String pay_status, @Param("start_time") String start_time, @Param("end_time") String end_time, @Param("keyword") String keyword);
    List<InsPreservationPayVo> findInsPreservationSettlementVoByKeyword(Page<InsPreservationPayVo> page, @Param("userId") Long userId, @Param("start_time") String start_time, @Param("end_time") String end_time, @Param("keyword") String keyword);
    List<InsPreservationPayVo> findInsPreservationChildBillVoByKeyword(Page<InsPreservationPayVo> page, @Param("userId") Long userId, @Param("parentPayId") Long parentPayId, @Param("pay_status") String pay_status, @Param("start_time") String start_time, @Param("end_time") String end_time, @Param("keyword") String keyword);
    List<InsPreservationPayVo> findInsPreservationChildSettlementVoByKeyword(Page<InsPreservationPayVo> page, @Param("userId") Long userId, @Param("parentPayId") Long parentPayId, @Param("start_time") String start_time, @Param("end_time") String end_time, @Param("keyword") String keyword);

    /**
     * <b> 是否险种一致 </b>
     * @param isSummaryBill 是否为汇总账单
     * @param pays 勾选数据列的id集合
     * @author ZXF
     * @create 2024/04/26 0026 11:24
     * @version
     * @注意事项 </b>
     */
    int isConsistentInsurancePlan(@Param("isSummaryBill") String isSummaryBill,@Param("pays") String[] pays);
    String isPartBillSign(@Param("pays") String[] pays);
    List<Map<String,String>> isConsistentSummaryBill(@Param("pays") String[] pays);
    List<InsPreservationPay>  consistentBillMerge(@Param("isSummaryBill") String isSummaryBill,@Param("pays") String[] pays);
    String findPayIdsByPayNos(@Param("payNos") String[] payNos);

    /**
     * 根据保全缴费id查询保全缴费详情及关联保全申请单信息
     * @param oid
     * @return
     */
    public InsPreservationPayVo findInsPreservationPayVoById(@Param("oid") Long oid);

    /**
     * 根据未生成结算的保全申请单筛选产品属性为按月按季度结算的订单id
     * @param paymentType 结算方式 2每月结算 3季度结算 4半年结算 5一年结算
     * @return
     */
    public List<InsPreservationPay> findInsPreservationPayByPaymentType(@Param("paymentType") String paymentType);
    public List<String> findInsPreservationPayIdsByPaymentType(@Param("paymentType") String paymentType);

    int updateStatusById(@Param("pay_status") String pay_status,@Param("pays") String[] pays);

    String selectHavePayID(@Param("record_id") Long record_id);

    InsPreservationPay getPayExAndMonth(@Param("policyNo") String policyNo,@Param("star") Date star,@Param("end") Date end);

    /**
     * <b> 给指定账单设置上级账单id </b>
     * @author ZXF
     * @create 2024/04/24 0024 13:46
     * @version
     * @注意事项 </b>
     */
    int updateParentPayId(@Param("parent_id") Long parent_id,@Param("pays") String[] pays);

    /**
     * <b> 给指定账单设置上级部分账单id </b>
     * @author ZXF
     * @create 2024/04/24 0024 13:46
     * @version
     * @注意事项 </b>
     */
    int updateParentPartBillId(@Param("parent_id") Long parent_id,@Param("pay_status") String pay_status,@Param("pays") String[] pays);

    /**
     * <b> 根据分组汇总上一个月账单 </b>
     * @author ZXF
     * @create 2024/04/24 0024 13:35
     * @version
     * @注意事项 </b>
     */
    List<InsPreservationPay> selectRecordBillBylastMonth(@Param("lastMonth") String lastMonth);

    /**
     * <b> 查询并组装当月有效保单未生成账单的记录 </b>
     * @author ZXF
     * @create 2024/04/23 0023 14:56
     * @version
     * @注意事项 </b>
     */
    List<InsPreservationPay> selectNotHavePayByThisMonth(@Param("policyNo") String policyNo,@Param("star") Date star,@Param("end") Date end);

    /**
     * 保存电子发票地址
     * @return
     */
    int updateFpUrl(@Param("pay_id") Long pay_id,@Param("fp_url") String fp_url);
    /**
     * 根据支付记录id查询有效批单号，取第一条
     * @return
     */
    String getRecordCode(@Param("pay_id") Long pay_id);
}
