package com.bcxin.ins.dao.order;

import java.util.List;

import com.bcxin.ins.entity.policy_core.InsShipReceive;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import com.bcxin.ins.spring.annotation.MyBatisDao;

/**
 * 信用险-出运应收接口
 * @author liumd
 * @date 2016年12月30日
 */
@MyBatisDao
public interface ShipReceiveAPIDao extends BaseMapper<InsShipReceive> {
	
	/** 根据ID获取应收
	 * 	没取到返回null
	 * */
	public List<InsShipReceive> getShipReceiveById(@Param("id") Long id);
	
	/** 根据出运ID获取应收
	 * 	没取到返回null
	 * */
	public List<InsShipReceive> getShipReceiveByShipDeclareId(@Param("shipDeclareId") Long shipDeclareId);
	
	/**
	 * 获取应收首页列表；
	 * @return
	 */
	public List<InsShipReceive> getReceiveIndexList(Long userId, DwzPage page);

	
}
