/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.third.tyx.pingancai;

import com.bcxin.ins.entity.common.LogBusinessrequest;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.LogBusinessrequestService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.third.tyx.pingancai.PackageMessagePAC;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.InsPreservationRecordVo;
import com.bcxin.ins.vo.OrderFormVo;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pACRequestService")
@Transactional
public class PACRequestService {
    private Logger communicatorLog = LoggerFactory.getLogger(PACRequestService.class);
    @Autowired
    private PolicyService policyService;
    @Autowired
    private LogBusinessrequestService logBusinessrequestService;
    private static final String PARTNERCODE = "P_BCX_GA";

    public String requestPAC(Long order_id, String transType, InsPreservationRecordVo iprVo) throws Exception {
        this.communicatorLog.info("requestPAC-TYX\uff1astar-----------------------");
        this.communicatorLog.info("requestPAC-TYX\uff1a\u63a5\u53e3\u7f16\u7801-" + transType + ",\u8ba2\u5355id-" + order_id + ",iprVo-" + (iprVo != null ? iprVo.toString() : "null"));
        OrderFormVo dto = this.policyService.accordingToOrderIDToGetPolicyDto(order_id);
        GMRPolicyVo vo = this.policyService.accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(dto.getOid()));
        String result = "300#\uff08APP-PAC-TYX-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
        LogBusinessrequest lb = null;
        try {
            String json = PackageMessagePAC.marshal(vo, dto, transType, iprVo);
            this.communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + json);
            String url = GlobalResources.PN_INS_URL + "/open/appsvr/property/openapi/" + PARTNERCODE + "/" + PACRequestService.getUrlByTransType(transType) + "?access_token=" + this.policyService.pnc_access_token();
            this.communicatorLog.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
            Date bTime = new Date();
            String ret = RequestUtil.initHttp().doPostByAccept(url, json, "application/json", "UTF-8");
            lb = this.logBusinessrequestService.initLogBusinessrequest(String.valueOf(order_id), transType, url, json, ret, bTime, new Date(), TransTypeEnum.getAlias((String)transType));
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
            result = PackageMessagePAC.returnAnalysisJson(ret, transType);
            this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
            this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
        }
        catch (Exception ex) {
            this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
            ex.printStackTrace();
        }
        this.communicatorLog.info("requestPAC-TYX\uff1aend-----------------------");
        return result;
    }

    private static String getUrlByTransType(String type) {
        if (TransTypeEnum.HB.getValue().equals(type)) {
            return "applyGA";
        }
        if (TransTypeEnum.CBXX.getValue().equals(type)) {
            return "acceptGA";
        }
        if (TransTypeEnum.DZBD.getValue().equals(type)) {
            return "printGA";
        }
        if (TransTypeEnum.DZPD.getValue().equals(type)) {
            return "printGA";
        }
        if (TransTypeEnum.ZFDZ.getValue().equals(type)) {
            return "prePayFinance";
        }
        if (TransTypeEnum.ZX.getValue().equals(type)) {
            return "cancelGA";
        }
        if (TransTypeEnum.TB.getValue().equals(type)) {
            return "refundGA";
        }
        if (TransTypeEnum.DZFP.getValue().equals(type)) {
            return "printInvoice";
        }
        if (TransTypeEnum.PD.getValue().equals(type)) {
            return "endorseApplyGA";
        }
        if (TransTypeEnum.PDQR.getValue().equals(type)) {
            return "endorseConfirmGA";
        }
        return "";
    }

    public String pdqr(String transType, String pdResult) {
        this.communicatorLog.info("pdqr-TYX\uff1astar-----------------------");
        this.communicatorLog.info("pdqr-TYX\uff1a\u63a5\u53e3\u7f16\u7801-" + transType + ",pdResult-" + pdResult);
        if (StringUtils.isNotEmpty((String)pdResult)) {
            String[] arr = pdResult.split("#");
            String result = "300#\uff08APP-PAC-TYX-001\uff09\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u8bf7\u91cd\u65b0\u8bf7\u6c42\uff01";
            LogBusinessrequest lb = null;
            try {
                String json = PackageMessagePAC.pdqr_marshal(arr[1], transType, arr[4], arr[3], arr[5]);
                this.communicatorLog.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + json);
                String url = GlobalResources.PN_INS_URL + "/open/appsvr/property/openapi/" + PARTNERCODE + "/" + PACRequestService.getUrlByTransType(transType) + "?access_token=" + this.policyService.pnc_access_token();
                this.communicatorLog.info("\u8bf7\u6c42\u5730\u5740\uff1a" + url);
                Date bTime = new Date();
                String ret = RequestUtil.initHttp().doPostByAccept(url, json, "application/json", "UTF-8");
                lb = this.logBusinessrequestService.initLogBusinessrequest("", transType, url, json, ret, bTime, new Date(), TransTypeEnum.getAlias((String)transType));
                this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\uff1a" + ret);
                result = PackageMessagePAC.returnAnalysisJson(ret, transType);
                this.communicatorLog.info("\u8fd4\u56de\u62a5\u6587\u5904\u7406\uff1a" + result);
                this.logBusinessrequestService.supplementDecAndSave(lb, result.startsWith("300") ? 1 : 0, "");
            }
            catch (Exception ex) {
                this.logBusinessrequestService.supplementDecAndSave(lb, 2, ex.getMessage());
                ex.printStackTrace();
            }
            this.communicatorLog.info("pdqr-TYX\uff1aend-----------------------");
            return result;
        }
        return "300#\u65e0\u6279\u6539\u4fe1\u606f\uff01";
    }
}

