/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.product.impl;

import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.service.order.InsuranceOperationAPIService;
import com.bcxin.ins.service.product.InsProductAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.util.BASE64Util;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProductServiceImpl
implements ProductService {
    @Autowired
    private InsuranceOperationAPIService insuranceOperationService;
    @Autowired
    private InsProductAPIService insProductAPIService;
    private Logger log = LoggerFactory.getLogger(ProductServiceImpl.class);

    @Override
    public List<ProductVo> getProducts() {
        return this.insuranceOperationService.selectProductVoList(new ProPrimary());
    }

    @Override
    public List<ProductVo> getProductsByOnLine(String code) {
        return this.insProductAPIService.getProductsByOnLine(code);
    }

    @Override
    public List<ProductVo> getProductsByCodeForNotCache(String code) {
        return this.insProductAPIService.getProductsByOnLine(code);
    }

    @Override
    public List<ProductVo> getProductsByConditionAndPage(String pro_type, String condition, DwzPage page) {
        return this.insProductAPIService.getProductsByConditionAndPage(pro_type, condition, page);
    }

    @Override
    public String setSharePath(Long oid, ClientUserVo userVo) {
        String result = "";
        String pUrl = GlobalResources.getResource((String)"BUSINESS_URL") + "insurance/product/productInfo/" + oid;
        result = userVo != null ? (StringUtils.isNotEmpty((CharSequence)userVo.getBusiness_support_id()) ? this.shareProduct(userVo.getBusiness_support_id(), pUrl) : this.shareProduct("", pUrl)) : this.shareProduct("", pUrl);
        return result;
    }

    private String shareProduct(String resID, String path) {
        String oidStr = "";
        if (StringUtils.isNotEmpty((CharSequence)resID)) {
            try {
                oidStr = BASE64Util.encryptBASE64((String)resID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return path + "?recommendCode=" + oidStr;
    }

    @Override
    public ProductVo getProduct(long productID) {
        ProductVo vo = null;
        if (StrUtil.isNotBlank((CharSequence)String.valueOf(productID))) {
            vo = this.insuranceOperationService.accordingToInsProductIDToGetInsProductInProductVo(productID);
        }
        return vo;
    }

    @Override
    public String getProductIDByCode(String productCode) {
        ProPrimary product;
        String product_id = "";
        if (StrUtil.isNotBlank((CharSequence)productCode) && (product = this.insProductAPIService.findProductByCode(productCode)) != null) {
            product_id = String.valueOf(product.getPro_primary_id());
        }
        return product_id;
    }

    @Override
    public int api_request_sign(String product_code) {
        if (StringUtils.isNotEmpty((CharSequence)product_code)) {
            if (product_code.indexOf("TYX-TK") != -1) {
                return 1;
            }
            if (product_code.indexOf("TYX-PAS") != -1) {
                return 2;
            }
            if (product_code.indexOf("TYX-RB") != -1) {
                return 4;
            }
            if (product_code.indexOf("TYX-PAC") != -1) {
                return 5;
            }
            if (product_code.indexOf("ZZX-ZA") != -1) {
                return 1;
            }
            if (product_code.indexOf("ZZX-PAC") != -1) {
                return 2;
            }
            if (product_code.indexOf("ZZX-HT") != -1) {
                return 5;
            }
            if (product_code.indexOf("GZX-HT") != -1) {
                return 1;
            }
            if (product_code.indexOf("GZX-PAC") != -1) {
                return 2;
            }
            if (product_code.indexOf("GZX-CA") != -1) {
                return 3;
            }
            if (product_code.indexOf("ZZX-YA") != -1) {
                return 3;
            }
            if (product_code.indexOf("ZZX-CA") != -1) {
                return 4;
            }
            if (product_code.indexOf("TYX-CA") != -1) {
                return 6;
            }
            if (product_code.indexOf("TYX-QH") != -1) {
                return 7;
            }
            if (product_code.indexOf("TYX-HT") != -1) {
                return 8;
            }
        }
        return 9;
    }

    @Override
    public String listProductAndResponsibility() {
        return this.insProductAPIService.listProductAndResponsibility();
    }
}

