/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.service.order.impl;

import com.bcxin.ins.dao.order.ShipDeclareAPIDao;
import com.bcxin.ins.entity.policy_core.InsShipDeclare;
import com.bcxin.ins.service.order.ShipDeclareAPIService;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ShipDeclareMultipleVo;
import com.bcxin.ins.vo.ShipDeclareStepTwoSearchVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ShipDeclareAPIServiceImpl
extends ServiceImpl<ShipDeclareAPIDao, InsShipDeclare>
implements ShipDeclareAPIService {
    @Autowired
    private ShipDeclareAPIDao shipDeclareDao;

    @Override
    public InsShipDeclare getShipDeclareById(Long id) {
        List<InsShipDeclare> lis = this.shipDeclareDao.getShipDeclareById(id);
        if (lis != null) {
            return lis.get(0);
        }
        return null;
    }

    @Override
    public List<InsShipDeclare> getShipDeclareByInsOrderFormId(Long ins_order_form_id, DwzPage page) {
        List<Object> lis = new ArrayList();
        if (page != null) {
            Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
            lis = this.shipDeclareDao.getShipDeclareByInsOrderFormId((Page<InsShipDeclare>)pageHelper, ins_order_form_id);
            page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        } else {
            lis = this.shipDeclareDao.getShipDeclareByInsOrderFormId(ins_order_form_id);
        }
        if (lis != null) {
            return lis;
        }
        return null;
    }

    @Override
    public List<ShipDeclareMultipleVo> getShipDeclareVoByInsOrderFormId(Long ins_order_form_id, DwzPage page) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<ShipDeclareMultipleVo> lis = this.shipDeclareDao.getShipDeclareVoByInsOrderFormId((Page<ShipDeclareMultipleVo>)pageHelper, ins_order_form_id);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        if (lis != null) {
            return lis;
        }
        return null;
    }

    @Override
    public List<ShipDeclareMultipleVo> getShipDeclareVoByInsOrderFormIdAndVo(Long ins_order_form_id, ShipDeclareStepTwoSearchVo searchVo, DwzPage page) {
        String insured = null;
        String country = null;
        String buyerName = null;
        String startDate = null;
        String endDate = null;
        String declareType = null;
        if (StringUtils.isNotBlank((String)searchVo.getInsured())) {
            insured = searchVo.getInsured();
        }
        if (StringUtils.isNotBlank((String)searchVo.getCountry())) {
            country = searchVo.getCountry();
        }
        if (StringUtils.isNotBlank((String)searchVo.getBuyer_name())) {
            buyerName = searchVo.getBuyer_name();
        }
        if (StringUtils.isNotBlank((String)searchVo.getStart_date())) {
            startDate = searchVo.getStart_date() + " 00:00:00";
        }
        if (StringUtils.isNotBlank((String)searchVo.getEnd_date())) {
            endDate = searchVo.getEnd_date() + " 23:59:59";
        }
        if (StringUtils.isNotBlank((String)searchVo.getDeclare_type())) {
            declareType = searchVo.getDeclare_type();
        }
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<ShipDeclareMultipleVo> lis = this.shipDeclareDao.getShipDeclareVoByInsOrderFormIdAndVo((Page<ShipDeclareMultipleVo>)pageHelper, ins_order_form_id, insured, country, buyerName, startDate, endDate, declareType);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        if (lis != null) {
            return lis;
        }
        return null;
    }

    @Override
    public List<OrderFormVo> getCanShipDeclareList(Long userId, DwzPage page) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<OrderFormVo> lis = this.shipDeclareDao.getCanShipDeclareList((Page<OrderFormVo>)pageHelper, userId);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        if (lis != null) {
            return lis;
        }
        return null;
    }

    @Override
    public OrderFormVo getOrderFormVoByOrderFormId(Long orderFormId) {
        List<OrderFormVo> lis = this.shipDeclareDao.getOrderFormVoByOrderFormId(orderFormId);
        if (lis != null) {
            return lis.get(0);
        }
        return null;
    }

    @Override
    public List<String> getInsureNameList(Long orderFormId) {
        List<String> lis = this.shipDeclareDao.getInsureNameList(orderFormId);
        if (lis != null) {
            return lis;
        }
        return null;
    }
}

