/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.storage;

import com.pingan.iobs.core.exception.IobsCoreException;
import com.pingan.iobs.core.model.PutResult;
import com.pingan.iobs.sdk.common.Config;
import com.pingan.iobs.sdk.common.IOBSException;
import com.pingan.iobs.sdk.http.Client;
import com.pingan.iobs.sdk.model.Response;
import com.pingan.iobs.sdk.repkg.com.google.gson.Gson;
import com.pingan.iobs.sdk.storage.FormUploader;
import com.pingan.iobs.sdk.storage.RecordKeyGenerator;
import com.pingan.iobs.sdk.storage.Recorder;
import com.pingan.iobs.sdk.storage.ResumeUploader;
import com.pingan.iobs.sdk.util.StringMap;
import java.io.File;
import java.io.InputStream;

public final class UploadManager {
    private String SERVICE_PATH_GETKEY = "/getUploadKey";
    private final Client client = Client.getInstance();
    private final Recorder recorder;
    private final RecordKeyGenerator keyGen;

    public UploadManager(Config config) {
        this(null, null);
    }

    public UploadManager() {
        this(null, null);
    }

    public Response getUploadKey(String token) throws IOBSException {
        StringBuffer sb = new StringBuffer();
        sb.append(Config.HOST).append(this.SERVICE_PATH_GETKEY).append("?token=").append(token);
        return this.client.get(sb.toString());
    }

    public UploadManager(Recorder recorder) {
        this(recorder, new RecordKeyGenerator(){

            @Override
            public String gen(String key, File file) {
                return key + "_._" + file.getAbsolutePath();
            }
        });
    }

    public UploadManager(Recorder recorder, RecordKeyGenerator keyGen) {
        this.recorder = recorder;
        this.keyGen = keyGen;
    }

    private static void checkArgs(String key, byte[] data, File f, String token) {
        String message = null;
        if (f == null && data == null) {
            message = "no input data";
        } else if (token == null || token.equals("")) {
            message = "no token";
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public Response put(File file, String bucket, String key, String token) throws IOBSException, IobsCoreException {
        return this.put(file, bucket, key, token, null, null);
    }

    public Response put(File file, String bucket, String key, String token, String persistentOps, String persistentNotifyUrl) throws IOBSException {
        long size = file.length();
        if (size <= (long)Config.PUT_THRESHOLD) {
            return new FormUploader(this.client, token, bucket, key, file, persistentOps, persistentNotifyUrl).upload();
        }
        ResumeUploader uploader = new ResumeUploader(token, bucket, key, file);
        return this.toResponse(uploader.execute());
    }

    public Response put(File file, String bucket, String token) throws IOBSException, IobsCoreException {
        return this.put(file, bucket, token, null, null);
    }

    public Response put(File file, String bucket, String token, String persistentOps, String persistentNotifyUrl) throws IOBSException {
        return new FormUploader(this.client, token, bucket, file, persistentOps, persistentNotifyUrl).upload();
    }

    private Response toResponse(PutResult result) {
        return new Response(200, null, new Gson().toJson(result));
    }

    private static StringMap filterParam(StringMap params) {
        final StringMap ret = new StringMap();
        if (params == null) {
            return ret;
        }
        params.forEach(new StringMap.Consumer(){

            @Override
            public void accept(String key, Object value) {
                if (value == null) {
                    return;
                }
                String val = value.toString();
                if (key.startsWith("x:") && !val.equals("")) {
                    ret.put(key, val);
                }
            }
        });
        return ret;
    }

    public Response putStream(String bucket, String key, InputStream ins, String fileName, String token, long length) throws IOBSException {
        return this.putStream(bucket, key, ins, fileName, token, length, null, null);
    }

    public Response putStream(String bucket, String key, InputStream ins, String fileName, String token, long length, String persistentOps, String persistentNotifyUrl) throws IOBSException {
        return new FormUploader(this.client, token, bucket, key, ins, fileName, length, persistentOps, persistentNotifyUrl).uploadStream();
    }

    public Response putStream(String bucket, InputStream ins, String fileName, String token, long length) throws IOBSException {
        return this.putStream(bucket, ins, fileName, token, length, null, null);
    }

    public Response putStream(String bucket, InputStream ins, String fileName, String token, long length, String persistentOps, String persistentNotifyUrl) throws IOBSException {
        return new FormUploader(this.client, token, bucket, ins, fileName, length, persistentOps, persistentNotifyUrl).uploadStream();
    }
}

