/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.storage;

import com.pingan.iobs.core.model.Context;
import com.pingan.iobs.sdk.common.Config;
import com.pingan.iobs.sdk.common.IOBSException;
import com.pingan.iobs.sdk.http.HttpClientFactory;
import com.pingan.iobs.sdk.repkg.com.google.gson.Gson;
import com.pingan.iobs.sdk.repkg.org.apache.commons.codec.binary.Base64;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpEntity;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpResponse;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.HttpClient;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.methods.HttpPost;
import com.pingan.iobs.sdk.repkg.org.apache.http.entity.BasicHttpEntity;
import com.pingan.iobs.sdk.repkg.org.apache.http.util.EntityUtils;
import com.pingan.iobs.sdk.storage.ResumeUploader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class UploadBlock {
    private static final String MKBLK_SERVICE = "mkblk";
    private static final String BPUT_SERVICE = "bput";
    private ResumeUploader resumeUploader;
    private Context ctx;
    private long offset;
    private int blockLen;
    private RandomAccessFile randomAccessFile;
    private HttpClient httpClient;

    public UploadBlock(ResumeUploader resumeFileUpload, Context ctx, long start, int len, RandomAccessFile randomAccessFile) throws IOException {
        this.resumeUploader = resumeFileUpload;
        this.ctx = ctx;
        this.offset = start;
        this.blockLen = len;
        this.randomAccessFile = randomAccessFile;
        this.httpClient = HttpClientFactory.createHttpClient();
    }

    public void execute() throws IOException, InterruptedException, IOBSException {
        int firstUpLen = Math.min(this.blockLen, Config.SLICE_SIZE);
        this.firstSliceUpload(firstUpLen);
        this.remainSliceUpload();
    }

    private void remainSliceUpload() throws IOException, InterruptedException, IOBSException {
        if (this.blockLen > Config.SLICE_SIZE) {
            this.loopUploadSlice();
            this.ctx.setUploadOver(true);
            this.resumeUploader.recordContextList();
        }
    }

    private void firstSliceUpload(int firstUpLen) throws IOException, InterruptedException, IOBSException {
        if (this.ctx.getSliceId() == 0) {
            Context returnCtx = this.mkblk(this.offset, firstUpLen);
            this.ctx.setSliceId(returnCtx.getSliceId());
        }
    }

    private void loopUploadSlice() throws IOException, InterruptedException, IOBSException {
        int count = (int)Math.ceil((double)this.blockLen / (double)Config.SLICE_SIZE);
        for (int i = this.ctx.getSliceId(); i < count; ++i) {
            long start = Config.SLICE_SIZE * i;
            int len = Math.min((int)((long)this.blockLen - start), Config.SLICE_SIZE);
            Context returnCtx = this.uploadSlice(this.ctx, start, len);
            this.ctx.setSliceId(returnCtx.getSliceId());
            this.resumeUploader.recordContextList();
        }
    }

    private Context uploadSlice(Context ctx, long start, int upLen) throws IOException, InterruptedException, IOBSException {
        String bputUrl = this.getBputUrl(ctx, start);
        return this.upload(bputUrl, this.offset + start, upLen);
    }

    private Context mkblk(long offset, int upLen) throws IOException, InterruptedException, IOBSException {
        String mkblkUrl = this.getMkblkUrl();
        return this.upload(mkblkUrl, offset, upLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context upload(String url, long offset, int len) throws IOException, InterruptedException, IOBSException {
        String respMsg = null;
        for (int index = 0; index < 3; ++index) {
            HttpPost post;
            block4: {
                post = null;
                try {
                    post = this.buildUpPost(url, this.resumeUploader.getUpToken());
                    post.setEntity(this.bulidHttpEtity(offset, len));
                    HttpResponse resp = this.httpClient.execute(post);
                    respMsg = EntityUtils.toString(resp.getEntity(), "UTF-8");
                    if (resp.getStatusLine().getStatusCode() != 200) break block4;
                    Context context = new Gson().fromJson(respMsg, Context.class);
                    this.releaseConnection(post);
                    return context;
                }
                catch (Throwable throwable) {
                    this.releaseConnection(post);
                    throw throwable;
                }
            }
            Thread.sleep(1000L);
            this.releaseConnection(post);
            continue;
        }
        throw new IOBSException(respMsg);
    }

    private void releaseConnection(HttpPost post) {
        if (post != null) {
            post.releaseConnection();
        }
    }

    private HttpEntity bulidHttpEtity(long offset, int len) throws IOException {
        BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
        basicHttpEntity.setContentLength(len);
        basicHttpEntity.setContent(new ByteArrayInputStream(this.readRandomAccessFile(offset, len)));
        return basicHttpEntity;
    }

    private HttpPost buildUpPost(String url, String upToken) {
        url = url + "?token=" + upToken;
        return new HttpPost(url);
    }

    private byte[] readRandomAccessFile(long offset, int len) throws IOException {
        byte[] bytes = new byte[len];
        this.randomAccessFile.seek(offset);
        this.randomAccessFile.read(bytes);
        return bytes;
    }

    public String getMkblkUrl() {
        return String.format("%s/%s/%s/%s/%s", Config.HOST, MKBLK_SERVICE, this.resumeUploader.getBucket(), this.resumeUploader.getKey(), this.ctx.getBlockId());
    }

    public String getBputUrl(Context ctx, long start) throws UnsupportedEncodingException {
        String ctxJson = new Gson().toJson(ctx);
        String ctxJsonBase64 = new String(Base64.encodeBase64(ctxJson.getBytes()), "UTF-8");
        return String.format("%s/%s/%s/%s/%s/%s", Config.HOST, BPUT_SERVICE, this.resumeUploader.getBucket(), this.resumeUploader.getKey(), ctxJsonBase64, start);
    }
}

