/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.service;

import com.pingan.iobs.sdk.auth.AuthException;
import com.pingan.iobs.sdk.common.IOBSException;
import com.pingan.iobs.sdk.model.Response;
import com.pingan.iobs.sdk.storage.DeleteManager;
import com.pingan.iobs.sdk.storage.DownloadManager;
import com.pingan.iobs.sdk.storage.UploadManager;
import com.pingan.iobs.sdk.util.Auth;
import com.pingan.iobs.sdk.util.StringUtils;
import java.io.File;
import java.io.InputStream;

public class IobsService {
    private UploadManager uploadManager;
    private DownloadManager downloadManager = new DownloadManager();
    private DeleteManager deleteManager;

    public IobsService() {
        this.uploadManager = new UploadManager();
        this.deleteManager = new DeleteManager();
    }

    public Response getKey() {
        try {
            String token = Auth.keyToken();
            return this.uploadManager.getUploadKey(token);
        }
        catch (AuthException e) {
            e.printStackTrace();
            return new Response(401, e.getMessage());
        }
        catch (IOBSException e) {
            e.printStackTrace();
            return new Response(400, e.getMessage());
        }
    }

    public Response upload(String bucket, String key, File file) {
        try {
            String token = Auth.newUpToken(bucket, key);
            return this.upload(bucket, key, file, token);
        }
        catch (AuthException ae) {
            ae.printStackTrace();
            return new Response(401, ae.getMessage());
        }
    }

    public Response upload(String bucket, String key, File file, String token) {
        try {
            String checkArgsMessage = this.checkUploadArgs(file, bucket, key, token);
            if (!StringUtils.isNullOrEmpty(checkArgsMessage)) {
                return new Response(400, checkArgsMessage);
            }
            return this.uploadManager.put(file, bucket, key, token);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Response(400, e.getMessage());
        }
    }

    public Response upload(String bucket, String key, File file, String persistentOps, String persistentNotifyUrl) {
        try {
            String token = Auth.newUpToken(bucket, key);
            return this.upload(bucket, key, file, token, persistentOps, persistentNotifyUrl);
        }
        catch (AuthException ae) {
            ae.printStackTrace();
            return new Response(401, ae.getMessage());
        }
    }

    public Response upload(String bucket, String key, File file, String token, String persistentOps, String persistentNotifyUrl) {
        try {
            String checkArgsMessage = this.checkUploadArgs(file, bucket, key, token);
            if (!StringUtils.isNullOrEmpty(checkArgsMessage)) {
                return new Response(400, checkArgsMessage);
            }
            return this.uploadManager.put(file, bucket, key, token, persistentOps, persistentNotifyUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Response(400, e.getMessage());
        }
    }

    public Response uploadStream(String bucket, String key, InputStream ins, String fileName, String token, long length) {
        try {
            String checkArgsMessage = this.checkBaseArgs(bucket, key, token);
            if (!StringUtils.isNullOrEmpty(checkArgsMessage)) {
                return new Response(400, checkArgsMessage);
            }
            return this.uploadManager.putStream(bucket, key, ins, fileName, token, length);
        }
        catch (IOBSException e) {
            e.printStackTrace();
            return new Response(400, e.getMessage());
        }
    }

    public Response uploadStream(String bucket, String key, InputStream ins, String fileName, long length) {
        try {
            String token = Auth.newUpToken(bucket, key);
            return this.uploadStream(bucket, key, ins, fileName, token, length);
        }
        catch (AuthException ae) {
            ae.printStackTrace();
            return new Response(401, ae.getMessage());
        }
    }

    public Response uploadStream(String bucket, String key, InputStream ins, String fileName, String token, long length, String persistentOps, String persistentNotifyUrl) {
        try {
            String checkArgsMessage = this.checkBaseArgs(bucket, fileName, token);
            if (!StringUtils.isNullOrEmpty(checkArgsMessage)) {
                return new Response(400, checkArgsMessage);
            }
            return this.uploadManager.putStream(bucket, key, ins, fileName, token, length, persistentOps, persistentNotifyUrl);
        }
        catch (IOBSException e) {
            e.printStackTrace();
            return new Response(400, e.getMessage());
        }
    }

    public Response uploadStream(String bucket, String key, InputStream ins, String fileName, long length, String persistentOps, String persistentNotifyUrl) {
        try {
            String token = Auth.newUpToken(bucket, key);
            return this.uploadStream(bucket, key, ins, fileName, token, length, persistentOps, persistentNotifyUrl);
        }
        catch (AuthException ae) {
            ae.printStackTrace();
            return new Response(401, ae.getMessage());
        }
    }

    public Response uploadRoute(String bucket, File file) {
        try {
            String token = Auth.newUpToken(bucket);
            return this.uploadRoute(bucket, file, token);
        }
        catch (AuthException ae) {
            ae.printStackTrace();
            return new Response(401, ae.getMessage());
        }
    }

    public Response uploadRoute(String bucket, File file, String token) {
        try {
            String checkArgsMessage = this.checkUploadArgs(file, bucket, token);
            if (!StringUtils.isNullOrEmpty(checkArgsMessage)) {
                return new Response(400, checkArgsMessage);
            }
            return this.uploadManager.put(file, bucket, token);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Response(400, e.getMessage());
        }
    }

    public Response uploadRoute(String bucket, File file, String persistentOps, String persistentNotifyUrl) {
        try {
            String token = Auth.newUpToken(bucket);
            return this.uploadRoute(bucket, file, token, persistentOps, persistentNotifyUrl);
        }
        catch (AuthException ae) {
            ae.printStackTrace();
            return new Response(401, ae.getMessage());
        }
    }

    public Response uploadRoute(String bucket, File file, String token, String persistentOps, String persistentNotifyUrl) {
        try {
            String checkArgsMessage = this.checkUploadArgs(file, bucket, token);
            if (!StringUtils.isNullOrEmpty(checkArgsMessage)) {
                return new Response(400, checkArgsMessage);
            }
            return this.uploadManager.put(file, bucket, token, persistentOps, persistentNotifyUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Response(400, e.getMessage());
        }
    }

    public Response uploadStreamRoute(String bucket, InputStream ins, String fileName, String token, long length) {
        try {
            String checkArgsMessage = this.checkBaseArgs(bucket, token);
            if (!StringUtils.isNullOrEmpty(checkArgsMessage)) {
                return new Response(400, checkArgsMessage);
            }
            return this.uploadManager.putStream(bucket, ins, fileName, token, length);
        }
        catch (IOBSException e) {
            e.printStackTrace();
            return new Response(400, e.getMessage());
        }
    }

    public Response uploadStreamRoute(String bucket, InputStream ins, String fileName, long length) {
        try {
            String token = Auth.newUpToken(bucket);
            return this.uploadStreamRoute(bucket, ins, fileName, token, length);
        }
        catch (AuthException ae) {
            ae.printStackTrace();
            return new Response(401, ae.getMessage());
        }
    }

    public Response uploadStreamRoute(String bucket, InputStream ins, String fileName, String token, long length, String persistentOps, String persistentNotifyUrl) {
        try {
            String checkArgsMessage = this.checkBaseArgs(bucket, fileName, token);
            if (!StringUtils.isNullOrEmpty(checkArgsMessage)) {
                return new Response(400, checkArgsMessage);
            }
            return this.uploadManager.putStream(bucket, ins, fileName, token, length, persistentOps, persistentNotifyUrl);
        }
        catch (IOBSException e) {
            e.printStackTrace();
            return new Response(400, e.getMessage());
        }
    }

    public Response uploadStreamRoute(String bucket, InputStream ins, String fileName, long length, String persistentOps, String persistentNotifyUrl) {
        try {
            String token = Auth.newUpToken(bucket);
            return this.uploadStreamRoute(bucket, ins, fileName, token, length, persistentOps, persistentNotifyUrl);
        }
        catch (AuthException ae) {
            ae.printStackTrace();
            return new Response(401, ae.getMessage());
        }
    }

    public Response downloadPublicRs(String bucket, String key) {
        try {
            String checkArgsMessage = this.checkPublicBucketDownloadArgs(bucket, key);
            if (!StringUtils.isNullOrEmpty(checkArgsMessage)) {
                return new Response(400, checkArgsMessage);
            }
            return this.downloadManager.downloadPublic(bucket, key);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Response(400, exception.getMessage());
        }
    }

    public Response downloadPrivateRs(String bucket, String key) {
        try {
            String checkArgsMessage = this.checkPublicBucketDownloadArgs(bucket, key);
            if (!StringUtils.isNullOrEmpty(checkArgsMessage)) {
                return new Response(400, checkArgsMessage);
            }
            return this.downloadManager.downloadPrivate(bucket, key);
        }
        catch (AuthException ae) {
            ae.printStackTrace();
            return new Response(401, ae.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Response(400, e.getMessage());
        }
    }

    public String downloadBaseUrl(String bucket, String key) {
        return this.downloadBaseUrl(bucket, key, null);
    }

    public String downloadBaseUrl(String bucket, String key, String attName) {
        return this.downloadManager.downloadPublicUrl(bucket, key, attName);
    }

    public String downloadAuthedUrl(String bucket, String key) throws IOBSException {
        return this.downloadAuthedUrl(bucket, key, null);
    }

    public String downloadAuthedUrl(String bucket, String key, String attName) throws IOBSException {
        try {
            return this.downloadManager.generateSignedUrl(bucket, key, attName);
        }
        catch (AuthException e) {
            throw new IOBSException(e);
        }
    }

    public Response download(String url) {
        try {
            return this.downloadManager.download(url);
        }
        catch (IOBSException e) {
            return new Response(400, e.getMessage());
        }
    }

    public Response delete(String bucket, String key) {
        try {
            String checkArgsMessage = this.checkPublicBucketDownloadArgs(bucket, key);
            if (!StringUtils.isNullOrEmpty(checkArgsMessage)) {
                return new Response(400, checkArgsMessage);
            }
            return this.deleteManager.delete(bucket, key);
        }
        catch (AuthException ae) {
            ae.printStackTrace();
            return new Response(401, ae.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Response(400, e.getMessage());
        }
    }

    public String deleteAuthedUrl(String bucket, String key) throws IOBSException {
        try {
            return this.deleteManager.generateSignedUrl(bucket, key);
        }
        catch (Exception e) {
            throw new IOBSException(e);
        }
    }

    public Response delete(String url) {
        try {
            return this.deleteManager.delete(url);
        }
        catch (IOBSException e) {
            return new Response(400, e.getMessage());
        }
    }

    private String checkPublicBucketDownloadArgs(String bucket, String key) {
        String message = null;
        if (StringUtils.isNullOrEmpty(bucket)) {
            message = "no bucket";
        } else if (StringUtils.isNullOrEmpty(key)) {
            message = "no key";
        }
        return message;
    }

    private String checkBaseArgs(String bucket, String key, String token) {
        String message = this.checkPublicBucketDownloadArgs(bucket, key);
        if (StringUtils.isNullOrEmpty(message) && (token == null || token.equals(""))) {
            message = "no token";
        }
        return message;
    }

    private String checkUploadArgs(File f, String bucket, String key, String token) {
        String message = this.checkBaseArgs(bucket, key, token);
        if (StringUtils.isNullOrEmpty(message) && f == null) {
            message = "no input data";
        }
        return message;
    }

    private String checkPublicBucketArgs(String bucket) {
        String message = null;
        if (StringUtils.isNullOrEmpty(bucket)) {
            message = "no bucket";
        }
        return message;
    }

    private String checkBaseArgs(String bucket, String token) {
        String message = this.checkPublicBucketArgs(bucket);
        if (StringUtils.isNullOrEmpty(message) && (token == null || token.equals(""))) {
            message = "no token";
        }
        return message;
    }

    private String checkUploadArgs(File f, String bucket, String token) {
        String message = this.checkBaseArgs(bucket, token);
        if (StringUtils.isNullOrEmpty(message) && f == null) {
            message = "no input data";
        }
        return message;
    }
}

