/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.repkg.org.apache.http.impl.execchain;

import com.pingan.iobs.sdk.repkg.org.apache.http.Header;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpException;
import com.pingan.iobs.sdk.repkg.org.apache.http.NoHttpResponseException;
import com.pingan.iobs.sdk.repkg.org.apache.http.annotation.Immutable;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.HttpRequestRetryHandler;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.NonRepeatableRequestException;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.methods.CloseableHttpResponse;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.methods.HttpExecutionAware;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.methods.HttpRequestWrapper;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.protocol.HttpClientContext;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.routing.HttpRoute;
import com.pingan.iobs.sdk.repkg.org.apache.http.impl.execchain.ClientExecChain;
import com.pingan.iobs.sdk.repkg.org.apache.http.impl.execchain.RequestEntityProxy;
import com.pingan.iobs.sdk.repkg.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RetryExec
implements ClientExecChain {
    private final ClientExecChain requestExecutor;
    private final HttpRequestRetryHandler retryHandler;

    public RetryExec(ClientExecChain requestExecutor, HttpRequestRetryHandler retryHandler) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryHandler, "HTTP request retry handler");
        this.requestExecutor = requestExecutor;
        this.retryHandler = retryHandler;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Args.notNull(route, "HTTP route");
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        Header[] origheaders = request.getAllHeaders();
        int execCount = 1;
        while (true) {
            try {
                return this.requestExecutor.execute(route, request, context, execAware);
            }
            catch (IOException ex) {
                if (execAware != null && execAware.isAborted()) {
                    throw ex;
                }
                if (this.retryHandler.retryRequest(ex, execCount, context)) {
                    if (!RequestEntityProxy.isRepeatable(request)) {
                        throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity", ex);
                    }
                } else {
                    if (ex instanceof NoHttpResponseException) {
                        NoHttpResponseException updatedex = new NoHttpResponseException(route.getTargetHost().toHostString() + " failed to respond");
                        updatedex.setStackTrace(ex.getStackTrace());
                        throw updatedex;
                    }
                    throw ex;
                }
                request.setHeaders(origheaders);
                ++execCount;
                continue;
            }
            break;
        }
    }
}

