/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.repkg.org.apache.http.impl.cookie;

import com.pingan.iobs.sdk.repkg.org.apache.http.annotation.Immutable;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.utils.DateUtils;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.MalformedCookieException;
import com.pingan.iobs.sdk.repkg.org.apache.http.cookie.SetCookie;
import com.pingan.iobs.sdk.repkg.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.pingan.iobs.sdk.repkg.org.apache.http.util.Args;
import java.util.Date;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for expires attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Unable to parse expires attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }
}

