/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.repkg.org.apache.http.impl.conn;

import com.pingan.iobs.sdk.repkg.org.apache.http.HttpHost;
import com.pingan.iobs.sdk.repkg.org.apache.http.annotation.Immutable;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.protocol.HttpClientContext;
import com.pingan.iobs.sdk.repkg.org.apache.http.config.Lookup;
import com.pingan.iobs.sdk.repkg.org.apache.http.config.SocketConfig;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.ConnectTimeoutException;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.DnsResolver;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.HttpHostConnectException;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.ManagedHttpClientConnection;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.SchemePortResolver;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.UnsupportedSchemeException;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.socket.ConnectionSocketFactory;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import com.pingan.iobs.sdk.repkg.org.apache.http.impl.conn.DefaultSchemePortResolver;
import com.pingan.iobs.sdk.repkg.org.apache.http.impl.conn.SystemDefaultDnsResolver;
import com.pingan.iobs.sdk.repkg.org.apache.http.protocol.HttpContext;
import com.pingan.iobs.sdk.repkg.org.apache.http.util.Args;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketTimeoutException;

@Immutable
class HttpClientConnectionOperator {
    static final String SOCKET_FACTORY_REGISTRY = "http.socket-factory-registry";
    private final Lookup<ConnectionSocketFactory> socketFactoryRegistry;
    private final SchemePortResolver schemePortResolver;
    private final DnsResolver dnsResolver;

    HttpClientConnectionOperator(Lookup<ConnectionSocketFactory> socketFactoryRegistry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        Args.notNull(socketFactoryRegistry, "Socket factory registry");
        this.socketFactoryRegistry = socketFactoryRegistry;
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
    }

    private Lookup<ConnectionSocketFactory> getSocketFactoryRegistry(HttpContext context) {
        Lookup<ConnectionSocketFactory> reg = (Lookup<ConnectionSocketFactory>)context.getAttribute(SOCKET_FACTORY_REGISTRY);
        if (reg == null) {
            reg = this.socketFactoryRegistry;
        }
        return reg;
    }

    public void connect(ManagedHttpClientConnection conn, HttpHost host, InetSocketAddress localAddress, int connectTimeout, SocketConfig socketConfig, HttpContext context) throws IOException {
        InetAddress[] inetAddressArray;
        Lookup<ConnectionSocketFactory> registry = this.getSocketFactoryRegistry(context);
        ConnectionSocketFactory sf = registry.lookup(host.getSchemeName());
        if (sf == null) {
            throw new UnsupportedSchemeException(host.getSchemeName() + " protocol is not supported");
        }
        if (host.getAddress() != null) {
            InetAddress[] inetAddressArray2 = new InetAddress[1];
            inetAddressArray = inetAddressArray2;
            inetAddressArray2[0] = host.getAddress();
        } else {
            inetAddressArray = this.dnsResolver.resolve(host.getHostName());
        }
        InetAddress[] addresses = inetAddressArray;
        int port = this.schemePortResolver.resolve(host);
        for (int i = 0; i < addresses.length; ++i) {
            InetAddress address = addresses[i];
            boolean last = i == addresses.length - 1;
            Socket sock = sf.createSocket(context);
            sock.setSoTimeout(socketConfig.getSoTimeout());
            sock.setReuseAddress(socketConfig.isSoReuseAddress());
            sock.setTcpNoDelay(socketConfig.isTcpNoDelay());
            sock.setKeepAlive(socketConfig.isSoKeepAlive());
            int linger = socketConfig.getSoLinger();
            if (linger >= 0) {
                sock.setSoLinger(linger > 0, linger);
            }
            conn.bind(sock);
            InetSocketAddress remoteAddress = new InetSocketAddress(address, port);
            try {
                sock = sf.connectSocket(connectTimeout, sock, host, remoteAddress, localAddress, context);
                conn.bind(sock);
                return;
            }
            catch (SocketTimeoutException ex) {
                if (!last) continue;
                throw new ConnectTimeoutException(ex, host, addresses);
            }
            catch (ConnectException ex) {
                if (!last) continue;
                String msg = ex.getMessage();
                if ("Connection timed out".equals(msg)) {
                    throw new ConnectTimeoutException(ex, host, addresses);
                }
                throw new HttpHostConnectException(ex, host, addresses);
            }
            catch (NoRouteToHostException ex) {
                if (!last) continue;
                throw ex;
            }
        }
    }

    public void upgrade(ManagedHttpClientConnection conn, HttpHost host, HttpContext context) throws IOException {
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Lookup<ConnectionSocketFactory> registry = this.getSocketFactoryRegistry(clientContext);
        ConnectionSocketFactory sf = registry.lookup(host.getSchemeName());
        if (sf == null) {
            throw new UnsupportedSchemeException(host.getSchemeName() + " protocol is not supported");
        }
        if (!(sf instanceof LayeredConnectionSocketFactory)) {
            throw new UnsupportedSchemeException(host.getSchemeName() + " protocol does not support connection upgrade");
        }
        LayeredConnectionSocketFactory lsf = (LayeredConnectionSocketFactory)sf;
        Socket sock = conn.getSocket();
        int port = this.schemePortResolver.resolve(host);
        sock = lsf.createLayeredSocket(sock, host.getHostName(), port, context);
        conn.bind(sock);
    }
}

