/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.repkg.org.apache.http.impl.auth;

import com.pingan.iobs.sdk.repkg.org.apache.http.Header;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpException;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpHost;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpRequest;
import com.pingan.iobs.sdk.repkg.org.apache.http.HttpResponse;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.AuthOption;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.AuthProtocolState;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.AuthScheme;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.AuthState;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.AuthenticationException;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.ContextAwareAuthScheme;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.Credentials;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.MalformedChallengeException;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.AuthenticationStrategy;
import com.pingan.iobs.sdk.repkg.org.apache.http.protocol.HttpContext;
import com.pingan.iobs.sdk.repkg.org.apache.http.util.Asserts;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;

public class HttpAuthenticator {
    public boolean isAuthenticationRequested(HttpHost host, HttpResponse response, AuthenticationStrategy authStrategy, AuthState authState, HttpContext context) {
        if (authStrategy.isAuthenticationRequested(host, response, context)) {
            if (authState.getState() == AuthProtocolState.SUCCESS) {
                authStrategy.authFailed(host, authState.getAuthScheme(), context);
            }
            return true;
        }
        switch (authState.getState()) {
            case CHALLENGED: 
            case HANDSHAKE: {
                authState.setState(AuthProtocolState.SUCCESS);
                authStrategy.authSucceeded(host, authState.getAuthScheme(), context);
                break;
            }
            case SUCCESS: {
                break;
            }
            default: {
                authState.setState(AuthProtocolState.UNCHALLENGED);
            }
        }
        return false;
    }

    public boolean handleAuthChallenge(HttpHost host, HttpResponse response, AuthenticationStrategy authStrategy, AuthState authState, HttpContext context) {
        try {
            Map<String, Header> challenges = authStrategy.getChallenges(host, response, context);
            if (challenges.isEmpty()) {
                return false;
            }
            AuthScheme authScheme = authState.getAuthScheme();
            switch (authState.getState()) {
                case FAILURE: {
                    return false;
                }
                case SUCCESS: {
                    authState.reset();
                    break;
                }
                case CHALLENGED: 
                case HANDSHAKE: {
                    if (authScheme == null) {
                        authStrategy.authFailed(host, null, context);
                        authState.reset();
                        authState.setState(AuthProtocolState.FAILURE);
                        return false;
                    }
                }
                case UNCHALLENGED: {
                    if (authScheme == null) break;
                    String id = authScheme.getSchemeName();
                    Header challenge = challenges.get(id.toLowerCase(Locale.ENGLISH));
                    if (challenge != null) {
                        authScheme.processChallenge(challenge);
                        if (authScheme.isComplete()) {
                            authStrategy.authFailed(host, authState.getAuthScheme(), context);
                            authState.reset();
                            authState.setState(AuthProtocolState.FAILURE);
                            return false;
                        }
                        authState.setState(AuthProtocolState.HANDSHAKE);
                        return true;
                    }
                    authState.reset();
                }
            }
            Queue<AuthOption> authOptions = authStrategy.select(challenges, host, response, context);
            if (authOptions != null && !authOptions.isEmpty()) {
                authState.setState(AuthProtocolState.CHALLENGED);
                authState.update(authOptions);
                return true;
            }
            return false;
        }
        catch (MalformedChallengeException ex) {
            authState.reset();
            return false;
        }
    }

    public void generateAuthResponse(HttpRequest request, AuthState authState, HttpContext context) throws HttpException, IOException {
        AuthScheme authScheme = authState.getAuthScheme();
        Credentials creds = authState.getCredentials();
        switch (authState.getState()) {
            case FAILURE: {
                return;
            }
            case SUCCESS: {
                this.ensureAuthScheme(authScheme);
                if (!authScheme.isConnectionBased()) break;
                return;
            }
            case CHALLENGED: {
                Queue<AuthOption> authOptions = authState.getAuthOptions();
                if (authOptions != null) {
                    while (!authOptions.isEmpty()) {
                        AuthOption authOption = authOptions.remove();
                        authScheme = authOption.getAuthScheme();
                        creds = authOption.getCredentials();
                        authState.update(authScheme, creds);
                        try {
                            Header header = this.doAuth(authScheme, creds, request, context);
                            request.addHeader(header);
                            break;
                        }
                        catch (AuthenticationException ex) {
                        }
                    }
                    return;
                }
                this.ensureAuthScheme(authScheme);
            }
        }
        if (authScheme != null) {
            try {
                Header header = this.doAuth(authScheme, creds, request, context);
                request.addHeader(header);
            }
            catch (AuthenticationException ex) {
                // empty catch block
            }
        }
    }

    private void ensureAuthScheme(AuthScheme authScheme) {
        Asserts.notNull(authScheme, "Auth scheme");
    }

    private Header doAuth(AuthScheme authScheme, Credentials creds, HttpRequest request, HttpContext context) throws AuthenticationException {
        if (authScheme instanceof ContextAwareAuthScheme) {
            return ((ContextAwareAuthScheme)authScheme).authenticate(creds, request, context);
        }
        return authScheme.authenticate(creds, request);
    }
}

