/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.auth;

import com.alibaba.fastjson.JSONObject;
import com.pingan.iobs.sdk.auth.EncodeUtils;
import com.pingan.iobs.sdk.auth.PutPolicy;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class UploadToken {
    private static final String SEPERATOR_SYMBOL = ":";
    private String accessKey;
    private String encodedSign;
    private String encodedPutPolicy;
    private PutPolicy putPolicy;

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getEncodedSign() {
        return this.encodedSign;
    }

    public String getEncodedPutPolicy() {
        return this.encodedPutPolicy;
    }

    public PutPolicy getPutPolicy() {
        return this.putPolicy;
    }

    private UploadToken(String accessKey, String encodedSign, String encodedPutPolicy) {
        this.accessKey = accessKey;
        this.encodedSign = encodedSign;
        this.encodedPutPolicy = encodedPutPolicy;
        this.putPolicy = this.parse2PutPolicy(encodedPutPolicy);
    }

    private PutPolicy parse2PutPolicy(String encodedPutPolicy) {
        String putPolicyStr = new String(EncodeUtils.urlsafeBase64Decode(encodedPutPolicy));
        return (PutPolicy)JSONObject.parseObject((String)putPolicyStr, PutPolicy.class);
    }

    public static UploadToken toUploadToken(String encodedToken) {
        Object[] tokenArray = StringUtils.split((String)encodedToken, (String)SEPERATOR_SYMBOL);
        if (ArrayUtils.isEmpty((Object[])tokenArray) || tokenArray.length != 3) {
            return null;
        }
        return new UploadToken((String)tokenArray[0], (String)tokenArray[1], (String)tokenArray[2]);
    }
}

