/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.auth;

import com.pingan.iobs.sdk.auth.AuthException;
import com.pingan.iobs.sdk.auth.DigestAuth;
import com.pingan.iobs.sdk.auth.Mac;
import com.pingan.iobs.sdk.auth.PutPolicy;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class TokenGenerator {
    private static final Log log = LogFactory.getLog(TokenGenerator.class);
    private static final String SEPERATOR_SYMBOL = ":";

    public String uploadToken(String bucket, String key, String accessKey, String secretKey, PutPolicy putPolicyObj) {
        putPolicyObj = this.setPolicyScope(bucket, key, putPolicyObj);
        try {
            return putPolicyObj.token(new Mac(accessKey, secretKey), false);
        }
        catch (Exception e) {
            log.error((Object)String.format("generate a upload token failed.bucket:%s/key:%s/accessKey:%s", bucket, key, accessKey), (Throwable)e);
            return null;
        }
    }

    private PutPolicy setPolicyScope(String bucket, String key, PutPolicy putPolicyObj) {
        putPolicyObj.scope = StringUtils.contains((String)putPolicyObj.scope, (String)SEPERATOR_SYMBOL) ? (StringUtils.isEmpty((String)key) ? bucket : bucket + SEPERATOR_SYMBOL + key) : bucket;
        return putPolicyObj;
    }

    public String downloadToken(String url, String accessKey, String secretKey) {
        String verifyDownloadToken = null;
        String baseUrl = url.substring(0, url.indexOf("&token="));
        try {
            verifyDownloadToken = DigestAuth.sign(new Mac(accessKey, secretKey), baseUrl.getBytes());
        }
        catch (AuthException e) {
            log.error((Object)String.format("generate verifying downloading token failedly:url:%s/accessKey:%s", url, accessKey), (Throwable)e);
        }
        return verifyDownloadToken;
    }

    public static void main(String[] args) {
        TokenGenerator generator = new TokenGenerator();
        PutPolicy putp = new PutPolicy();
        putp.scope = "ff-esbc-sf-stg-pri";
        Mac mac = new Mac("0DF8MK80DdV2286C609FV60KVDWMYIKW", "KdVVJD98C82YdJ0K9d88W26WVD06I928");
        String baseUrl = "http://10.20.18.135:8080/csp-iobs-core/listUsers";
        System.out.println(generator.uploadToken("ff-esbc-sf-stg-pri", "12", "0DF8MK80DdV2286C609FV60KVDWMYIKW", "KdVVJD98C82YdJ0K9d88W26WVD06I928", putp));
        System.out.println(System.currentTimeMillis() / 1000L);
    }
}

