/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.auth;

import com.pingan.iobs.core.cache.UserBucketCacheManager;
import com.pingan.iobs.core.exception.IobsCoreException;
import com.pingan.iobs.core.model.User;
import com.pingan.iobs.core.util.SecretKeyUtils;
import com.pingan.iobs.sdk.auth.JavaBase64;
import com.pingan.iobs.sdk.auth.TokenGenerator;
import com.pingan.iobs.sdk.auth.UploadToken;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Authentication {
    private static final Log log = LogFactory.getLog(Authentication.class);
    private static final String UPLOAD_TOKEN_FORMAT = "^[^\\:]+\\:[^\\:]+\\:[^\\:]+$";
    private static final String DOWNLOAD_TOKEN_FORMAT = "^[^\\:]+\\:[^\\:]+$";
    @Autowired
    private TokenGenerator tokenGenerator;
    @Autowired
    private UserBucketCacheManager cacheManager;

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public boolean checkUploadToken(String token, String bucket, String key) {
        if (!this.isValidUploadTokenFormat(token)) {
            return false;
        }
        UploadToken tokenObj = UploadToken.toUploadToken(token);
        if (this.isOverTime(tokenObj.getPutPolicy().deadline)) {
            return false;
        }
        String secretKey = null;
        try {
            secretKey = this.getSecretKeyByAccessKey(tokenObj.getAccessKey());
        }
        catch (Exception e) {
            log.error((Object)("Get secretkey error,and return false!ak:" + tokenObj.getAccessKey()), (Throwable)e);
            return false;
        }
        String newToken = this.tokenGenerator.uploadToken(bucket, key, tokenObj.getAccessKey(), secretKey, tokenObj.getPutPolicy());
        return this.tokenEquals(newToken, token);
    }

    public boolean checkDownloadToken(String token, String url, Long expires) throws Exception {
        if (!this.isValidDownloadTokenFormat(token) || this.isOverTime(expires)) {
            return false;
        }
        String[] tokenSepArr = token.split(":");
        String accessKey = tokenSepArr[0];
        String secretKey = this.getSecretKeyByAccessKey(accessKey);
        String verifyDownloadToken = this.tokenGenerator.downloadToken(url, accessKey, secretKey);
        return this.tokenEquals(verifyDownloadToken, token);
    }

    private boolean tokenEquals(String generatedToken, String originToken) {
        return StringUtils.isNotEmpty((String)generatedToken) && StringUtils.equals((String)generatedToken, (String)originToken);
    }

    private String getSecretKeyByAccessKey(String accessKey) throws Exception {
        User user = this.cacheManager.getUserBucketWrapper().findUserByAK(accessKey);
        String sk = null;
        if (user == null) {
            throw new IobsCoreException(612, "get user by AK failed,this user cache not exist");
        }
        sk = user.getSk();
        return JavaBase64.encryptBASE64(SecretKeyUtils.getSKWithSecretaryByte(sk));
    }

    private boolean isOverTime(long expires) {
        return System.currentTimeMillis() / 1000L > expires;
    }

    private boolean isValidUploadTokenFormat(String token) {
        return this.matches(token, UPLOAD_TOKEN_FORMAT);
    }

    private boolean isValidDownloadTokenFormat(String token) {
        return this.matches(token, DOWNLOAD_TOKEN_FORMAT);
    }

    private boolean matches(String source, String format) {
        try {
            Pattern pattern = Pattern.compile(format);
            Matcher matcher = pattern.matcher(source);
            return matcher.matches();
        }
        catch (Exception e) {
            log.error((Object)String.format("Token(%s) is not valid(doesn't match %s)!", source, format), (Throwable)e);
            return false;
        }
    }
}

