/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.core.exception;

import com.pingan.iobs.core.model.ErrorResp;
import com.pingan.radosgw.sdk.common.util.json.JSONObject;
import javax.servlet.http.HttpServletResponse;

public class IobsCoreException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int statusCode;

    public IobsCoreException(int statusCode, String message) {
        this(statusCode, message, null);
    }

    public IobsCoreException(String message) {
        this(406, message, null);
    }

    public IobsCoreException(Throwable t) {
        this(406, t.getMessage(), t);
    }

    public IobsCoreException(int statusCode, String message, Throwable t) {
        super(message, t);
        this.statusCode = statusCode;
    }

    public IobsCoreException(String message, Throwable t) {
        super(message, t);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public static String handleException(HttpServletResponse resp, Exception e) {
        JSONObject retJsonObj = null;
        if (e instanceof IobsCoreException) {
            retJsonObj = IobsCoreException.handleIobsCoreException(resp, (IobsCoreException)e);
        } else {
            resp.setStatus(599);
            retJsonObj = new JSONObject((Object)ErrorResp.newErrorResp((Integer)599, (String)"Internal Error!"));
        }
        return retJsonObj.toString();
    }

    private static JSONObject handleIobsCoreException(HttpServletResponse resp, IobsCoreException ce) {
        if (ce.getStatusCode() == 404) {
            resp.setStatus(612);
            return new JSONObject((Object)ErrorResp.newErrorResp((Integer)612, (String)"Not find a specified file!"));
        }
        if (ce.getStatusCode() == 410) {
            resp.setStatus(410);
            return new JSONObject((Object)ErrorResp.newErrorResp((Integer)410, (String)"Upload file lose efficacy!"));
        }
        if (ce.getStatusCode() == 500) {
            if (ce.getMessage().contains("404")) {
                resp.setStatus(612);
                return new JSONObject((Object)ErrorResp.newErrorResp((Integer)612, (String)"Not find a specified file!"));
            }
            resp.setStatus(599);
            return new JSONObject((Object)ErrorResp.newErrorResp((Integer)599, (String)"Internal Error!"));
        }
        if (ce.getStatusCode() == 599 || ce.getStatusCode() == 0) {
            resp.setStatus(599);
            return new JSONObject((Object)ErrorResp.newErrorResp((Integer)599, (String)"Internal Error!"));
        }
        resp.setStatus(ce.getStatusCode());
        return new JSONObject((Object)ErrorResp.newErrorResp((Integer)ce.getStatusCode(), (String)"Internal Error!"));
    }
}

