/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.MyTposThrUserService;
import com.bcxin.ins.core.util.CTLUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${systemPath}/mywhiteuser"})
public class WhiteUserController
extends BaseController {
    private static final String WHITE_USER_LIST = WhiteUserController.getViewPath((String)"admin/system/white_user_list");
    private static final String WHITE_USER_ADD = WhiteUserController.getViewPath((String)"admin/system/white_user_add");
    @Autowired
    private MyTposThrUserService myTposThrUserService;

    @RequiresPermissions(value={"mywhiteuser:win:list"})
    @RequestMapping(value={"/win/list"})
    public String winList(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        return WHITE_USER_LIST;
    }

    @RequestMapping(value={"/list/add"}, method={RequestMethod.GET})
    public String add(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        model.addAttribute("mark", (Object)"add");
        model.addAttribute("p", params);
        return WHITE_USER_ADD;
    }

    @RequestMapping(value={"/list/edit/{oid}"})
    public String edit(Model model, @RequestParam Map<Object, Object> params, @PathVariable Long oid) {
        HashMap m = Maps.newHashMap();
        m.put("tpos_thr_user_id", oid);
        model.addAttribute("mark", (Object)"upd");
        model.addAttribute("p", params);
        model.addAttribute("row", this.myTposThrUserService.selectByMap((Map)m).get(0));
        return WHITE_USER_ADD;
    }

    @RequiresPermissions(value={"mywhiteuser:win:list"})
    @RequestMapping(value={"/query"}, method={RequestMethod.POST})
    @ResponseBody
    public Object query(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        CTLUtil.out((Object)this.myTposThrUserService.query(params), (HttpServletResponse)resp);
        return null;
    }

    @RequiresPermissions(value={"mywhiteuser:wu:add"})
    @RequestMapping(value={"/wu/add"}, method={RequestMethod.POST})
    @ResponseBody
    public Object wuAdd(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.myTposThrUserService.whiteUserAdd(p);
    }

    @RequiresPermissions(value={"mywhiteuser:wu:upd"})
    @RequestMapping(value={"/wu/upd"}, method={RequestMethod.POST})
    @ResponseBody
    public Object wuUpd(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.myTposThrUserService.whiteUserUpd(p);
    }

    @RequiresPermissions(value={"mywhiteuser:wu:del"})
    @RequestMapping(value={"/wu/del"}, method={RequestMethod.POST})
    @ResponseBody
    public Object wuDel(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.myTposThrUserService.whiteUserDel(p);
    }
}

