/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.web;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.common.mapper.JsonMapper;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysRole;
import com.bcxin.ins.core.entity.SysRoleMenu;
import com.bcxin.ins.core.service.SysCompanyService;
import com.bcxin.ins.core.service.SysMenuService;
import com.bcxin.ins.core.service.SysRoleMenuService;
import com.bcxin.ins.core.service.SysRoleService;
import com.bcxin.ins.spring.util.ServletUtils;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.plugins.Page;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${systemPath}/sysrole"})
public class SysRoleController
extends BaseController {
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SysRoleMenuService sysRoleMenuService;
    @Autowired
    private SysMenuService sysMenuService;
    @Autowired
    private SysCompanyService sysCompanyService;
    private static final String SYSTEM_ROLE_LIST = SysRoleController.getViewPath((String)"/admin/system/system_role_list");
    private static final String SYSTEM_ROLE_ADD = SysRoleController.getViewPath((String)"/admin/system/system_role_add");
    private static final String SYSTEM_ROLE_ADD_AUTH = SysRoleController.getViewPath((String)"/admin/system/system_role_add_auth");

    @RequiresPermissions(value={"sysuser:role:view"})
    @RequestMapping(value={"/list"})
    public String showRoleList(Model model, Page page) {
        List roleList = this.sysRoleService.selectRoleList();
        model.addAttribute("roleList", (Object)roleList);
        List sysRoles = this.sysRoleService.selectRoleAndNumber();
        model.addAttribute("sysRoles", (Object)sysRoles);
        return SYSTEM_ROLE_LIST;
    }

    @RequiresPermissions(value={"sysuser:role:add"})
    @RequestMapping(value={"/list/add"})
    public String add(Model model) {
        List menuList = this.sysMenuService.findList();
        if (menuList != null) {
            model.addAttribute("jsonMenu", (Object)JsonMapper.toJsonString((Object)menuList));
            this.logger.info(JsonMapper.toJsonString((Object)menuList));
        }
        return SYSTEM_ROLE_ADD;
    }

    @RequiresPermissions(value={"sysuser:role:edit"})
    @RequestMapping(value={"/list/{roleId}/edit"})
    public String edit(Model model, @PathVariable Long roleId) {
        SysRole sysRole = this.sysRoleService.get(roleId);
        model.addAttribute("sysRole", (Object)sysRole);
        return SYSTEM_ROLE_ADD;
    }

    @RequiresPermissions(value={"sysuser:role:auth"})
    @RequestMapping(value={"/list/{roleId}/auth"})
    public String editAuth(Model model, @PathVariable Long roleId) {
        SysRole sysRole = this.sysRoleService.get(roleId);
        model.addAttribute("sysRole", (Object)sysRole);
        List menuList = this.sysMenuService.findList();
        model.addAttribute("menuList", (Object)menuList);
        model.addAttribute("id", (Object)roleId);
        return SYSTEM_ROLE_ADD_AUTH;
    }

    @RequiresPermissions(value={"sysuser:role:add", "sysuser:role:edit"})
    @RequestMapping(value={"/list/save"})
    @ResponseBody
    public AjaxResult save(SysRole sysRole) {
        String menuIds = ServletUtils.getRequest().getParameter("menuIds");
        String companyIds = ServletUtils.getRequest().getParameter("companyIds");
        if (StrUtil.isBlank((String)menuIds) && sysRole.getId() != null) {
            return this.fail(false, "\u8bf7\u9009\u62e9\u7528\u6237\u6743\u9650");
        }
        if (sysRole.getDataScope().equals("9") && StrUtil.isBlank((String)companyIds)) {
            return this.fail(false, "\u8bf7\u9009\u62e9\u6570\u636e\u8303\u56f4");
        }
        this.sysRoleService.save((Object)sysRole);
        return this.success(true, "\u4fdd\u5b58\u89d2\u8272\u6210\u529f");
    }

    @RequiresPermissions(value={"sysuser:role:delete"})
    @RequestMapping(value={"/list/{roleId}/delete"})
    @ResponseBody
    public Map<String, Object> deleteRole(@PathVariable(value="roleId") Long roleId) {
        Map json = Maps.newHashMap();
        if (roleId > 0L) {
            this.sysRoleService.deleteById((Serializable)roleId);
            SysRoleMenu sysRoleMenu = new SysRoleMenu();
            sysRoleMenu.setRoleId(roleId);
            this.sysRoleMenuService.delete(new EntityWrapper().addFilter("role_id={0}", new Object[]{roleId}));
            json = this.setJson(true, "\u89d2\u8272\u5220\u9664\u6210\u529f", null);
        } else {
            json = this.setJson(false, "\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u89d2\u8272!", null);
        }
        return json;
    }

    @RequiresPermissions(value={"sysuser:role:audit"})
    @RequestMapping(value={"/list/audit"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult audit() {
        Long roleId = Long.parseLong(this.getParameter("roleId"));
        Integer status = Integer.valueOf(this.getParameter("status"));
        SysRole sysRole = new SysRole();
        sysRole.setId(roleId);
        sysRole.setStatus(status);
        this.sysRoleService.updateById((Object)sysRole);
        return this.success(true);
    }
}

