/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.web;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysMenu;
import com.bcxin.ins.core.service.SysMenuService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${systemPath}/sysmenu"})
public class SysMenuController
extends BaseController {
    private static final String SYSTEM_MENU_LIST = SysMenuController.getViewPath((String)"/admin/system/system_menu_list");
    private static final String SYSTEM_MENU_ADD = SysMenuController.getViewPath((String)"/admin/system/system_menu_add");
    @Autowired
    private SysMenuService sysMenuService;

    @RequiresPermissions(value={"sysuser:menu:view"})
    @RequestMapping(value={"/list"})
    public String showMenuList(Model model) {
        List menuList = this.sysMenuService.findList();
        model.addAttribute("menuList", (Object)menuList);
        return SYSTEM_MENU_LIST;
    }

    @RequiresPermissions(value={"sysuser:menu:add"})
    @RequestMapping(value={"/list/add"}, method={RequestMethod.GET})
    public String add(Model model) {
        List menuList = this.sysMenuService.selectSysMenu();
        model.addAttribute("menuList", (Object)menuList);
        return SYSTEM_MENU_ADD;
    }

    @RequiresPermissions(value={"sysuser:menu:edit"})
    @RequestMapping(value={"/list/{menuId}/edit"})
    public String edit(Model model, @PathVariable Long menuId) {
        SysMenu sysMenu = (SysMenu)this.sysMenuService.selectById((Serializable)menuId);
        model.addAttribute("sysMenu", (Object)sysMenu);
        List menuList = this.sysMenuService.selectSysMenu();
        model.addAttribute("menuList", (Object)menuList);
        return SYSTEM_MENU_ADD;
    }

    @RequiresPermissions(value={"sysuser:menu:add", "sysuser:menu:edit"})
    @RequestMapping(value={"/list/save"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult update(SysMenu sysMenu) {
        if (sysMenu.getId() == null) {
            HashMap<String, Object> columnMap = new HashMap<String, Object>();
            columnMap.put("MENU_NAME", sysMenu.getMenuName());
            columnMap.put("PARENT_ID", sysMenu.getParent().getId());
            List list = this.sysMenuService.selectByMap(columnMap);
            if (list.size() > 0) {
                return this.fail(false, "\u8be5\u83dc\u5355\u540d\u5df2\u88ab\u4f7f\u7528");
            }
        }
        this.sysMenuService.save((Object)sysMenu);
        return this.success(true, "\u64cd\u4f5c\u6210\u529f!");
    }

    @RequiresPermissions(value={"sysuser:menu:delete"})
    @RequestMapping(value={"/list/{id}/delete"})
    @ResponseBody
    public AjaxResult deleteFunction(@PathVariable(value="id") Long id) {
        this.sysMenuService.deleteById((Serializable)id);
        return this.success(true, "\u5220\u9664\u6210\u529f");
    }

    @RequiresPermissions(value={"sysuser:menu:edit"})
    @RequestMapping(value={"/list/audit"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult audit() {
        Long menuId = Long.parseLong(this.getParameter("menuId"));
        Integer status = Integer.valueOf(this.getParameter("status"));
        SysMenu sysMenu = new SysMenu();
        sysMenu.setId(menuId);
        sysMenu.setStatus(status);
        this.sysMenuService.updateById((Object)sysMenu);
        return this.success(true);
    }
}

