/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.web;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysDict;
import com.bcxin.ins.core.service.SysDictService;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.core.util.DOM;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.util.toolbox.StrUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${systemPath}/dict"})
public class SysDictController
extends BaseController {
    @Autowired
    private SysDictService sysDictService;
    private static final String SYSTEM_DICT_LIST = SysDictController.getViewPath((String)"/admin/system/system_dict_list");
    private static final String SYSTEM_DICT_ADD = SysDictController.getViewPath((String)"/admin/system/system_dist_add");

    @RequestMapping(value={"/list/save"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult update(@RequestParam Map<Object, Object> params) {
        SysDict sysDict = (SysDict)DOM.mtd(params, (Object)new SysDict());
        if ("add".equals(params.get("mark"))) {
            HashMap<String, Object> columnMap = new HashMap<String, Object>();
            columnMap.put("type", params.get("type"));
            columnMap.put("value", params.get("value"));
            List list = this.sysDictService.selectByMap(columnMap);
            if (list.size() > 0) {
                return this.fail(false, "\u8be5\u5b57\u5178\u503c\u5df2\u7ecf\u88ab\u4f7f\u7528");
            }
            try {
                sysDict.setCom_dict_id(null);
                this.sysDictService.insert((Object)sysDict);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.success(true, "\u5b57\u5178\u521b\u5efa\u6210\u529f!");
        }
        this.sysDictService.updateById((Object)sysDict);
        return this.success(true, "\u5b57\u5178\u4fee\u6539\u6210\u529f!");
    }

    @RequestMapping(value={"/list"})
    public String list(SysDict dict, Model model) {
        return SYSTEM_DICT_LIST;
    }

    @RequestMapping(value={"/list/query"})
    @ResponseBody
    public Object query(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        CTLUtil.out((Object)this.sysDictService.query(p), (HttpServletResponse)resp);
        return null;
    }

    @RequestMapping(value={"/list/add"}, method={RequestMethod.GET})
    public String add(Model model) {
        return SYSTEM_DICT_ADD;
    }

    @RequestMapping(value={"/list/edit/{dictId}"})
    public String edit(Model model, @PathVariable Long dictId) {
        SysDict dict = (SysDict)this.sysDictService.selectById((Serializable)dictId);
        model.addAttribute("dict", (Object)dict);
        return SYSTEM_DICT_ADD;
    }

    @RequestMapping(value={"/sync"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult sync() {
        SysDictUtils.syncDict();
        return this.success(true, "\u5b57\u5178\u540c\u6b65\u6210\u529f!");
    }

    @RequestMapping(value={"/list/getvalue"})
    public String getValue(Model model, Long dictId) {
        SysDict dict = (SysDict)this.sysDictService.selectById((Serializable)dictId);
        dict.setCom_dict_id(null);
        dict.setLabel(null);
        dict.setValue(null);
        model.addAttribute("dict", (Object)dict);
        return SYSTEM_DICT_ADD;
    }

    @RequestMapping(value={"/list/{id}/delete"})
    @ResponseBody
    public Map<String, Object> deleteFunction(@PathVariable(value="id") Long id) {
        Map<String, Object> json = new HashMap<String, Object>();
        try {
            this.sysDictService.deleteById((Serializable)id);
            json = this.setJson(true, null, null);
        }
        catch (Exception e) {
            this.logger.error("deleteFunction()--error", (Throwable)e);
        }
        return json;
    }

    @ResponseBody
    @RequestMapping(value={"/getListByType/{type}"})
    public List<SysDict> getSysDictListByType(@PathVariable(value="type") String type) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            return SysDictUtils.getDictList((String)type);
        }
        return null;
    }

    @RequestMapping(value={"/getDictLabel"})
    public String getDictLabel(String value, String type, String def) {
        if (StrUtil.isBlank((String)value) || StrUtil.isBlank((String)type)) {
            return "";
        }
        return this.renderString(this.response, SysDictUtils.getDictLabel((String)value, (String)type, (String)(StrUtil.isBlank((String)def) ? "" : def)));
    }
}

