/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.ins.entity.product_core.ProPrimaryRuleXWCK;
import com.bcxin.ins.models.pro.service.MyProService;
import com.bcxin.ins.models.pro.service.ProExpCustomsCompaniesService;
import com.bcxin.ins.models.pro.service.ProPrimaryRuleXWCKService;
import com.bcxin.ins.models.pro.service.ProResponsibilityService;
import com.bcxin.ins.util.RegionUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"${systemPath}/mypro"})
public class ProController
extends BaseController {
    private static final String PRO_LIST = ProController.getViewPath((String)"admin/pro/pro_list");
    private static final String PRO_CATEGORY_LIST = ProController.getViewPath((String)"admin/pro/pro_category_list");
    private static final String PRO_SR_LIST = ProController.getViewPath((String)"admin/pro/pro_security_responsibility_list");
    private static final String PRO_SR_ADD = ProController.getViewPath((String)"admin/pro/pro_security_responsibility_add");
    private static final String PRO_RXWCK_LIST = ProController.getViewPath((String)"admin/pro/pro_security_rule_xwck_list");
    private static final String PRO_RXWCK_ADD = ProController.getViewPath((String)"admin/pro/pro_security_rule_xwck_add");
    private static final String PRO_ECC_LIST = ProController.getViewPath((String)"admin/pro/pro_exp_customs_companies_list");
    private static final String PRO_ECC_ADD = ProController.getViewPath((String)"admin/pro/pro_exp_customs_companies_add");
    private static final String PRO_DETAIL_PUBLIC = ProController.getViewPath((String)"admin/pro/pro_detail_public");
    private static final String PRO_DETAIL_CREDIT = ProController.getViewPath((String)"admin/pro/pro_detail_credit");
    private static final String PRO_DETAIL_RESPONSIBILITY = ProController.getViewPath((String)"admin/pro/pro_detail_responsibility");
    private static final String PRO_DETAIL_ENSURE = ProController.getViewPath((String)"admin/pro/pro_detail_ensure");
    private static final String PRO_DETAIL_PERSON = ProController.getViewPath((String)"admin/pro/pro_detail_person");
    @Autowired
    private MyProService proS;
    @Autowired
    private ProResponsibilityService proRS;
    @Autowired
    private ProPrimaryRuleXWCKService proRXWCK;
    @Autowired
    private ProExpCustomsCompaniesService proECC;

    @RequestMapping(value={"/win/detail/pro"})
    public String winDetailPro(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        return this.redirectTo("/api/mypro/win/dml");
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/win/list"})
    public String winList(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        return PRO_LIST;
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/win/sr/list"})
    public String winSRList(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        model.addAttribute("p", params);
        return PRO_SR_LIST;
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/win/sr/add"})
    public String winSRAdd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        model.addAttribute("mark", (Object)"add");
        model.addAttribute("p", params);
        return PRO_SR_ADD;
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/win/sr/upd"})
    public String winSRUpd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        HashMap m = Maps.newHashMap();
        m.put("pro_responsibility_id", params.get("pro_responsibility_id"));
        model.addAttribute("mark", (Object)"upd");
        model.addAttribute("p", params);
        model.addAttribute("row", this.proRS.selectByMap(m).get(0));
        return PRO_SR_ADD;
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/win/ecc/list"})
    public String winECCList(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        model.addAttribute("p", params);
        return PRO_ECC_LIST;
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/win/ecc/add"})
    public String winECCAdd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        model.addAttribute("mark", (Object)"add");
        model.addAttribute("p", params);
        return PRO_ECC_ADD;
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/win/ecc/upd"})
    public String winECCUpd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        HashMap m = Maps.newHashMap();
        m.put("pro_exp_customs_companies_id", params.get("pro_exp_customs_companies_id"));
        model.addAttribute("mark", (Object)"upd");
        model.addAttribute("p", params);
        model.addAttribute("row", this.proECC.selectByMap(m).get(0));
        return PRO_ECC_ADD;
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/win/rXWCK/list"})
    public String winRXWCKList(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        model.addAttribute("p", params);
        return PRO_RXWCK_LIST;
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/win/rXWCK/add"})
    public String winRXWCKAdd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        model.addAttribute("mark", (Object)"add");
        model.addAttribute("p", params);
        model.addAttribute("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
        return PRO_RXWCK_ADD;
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/win/rXWCK/upd"})
    public String winRXWCKUpd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        HashMap m = Maps.newHashMap();
        m.put("pro_primary_rule_xwck_id", params.get("pro_primary_rule_xwck_id"));
        model.addAttribute("mark", (Object)"upd");
        model.addAttribute("p", params);
        ProPrimaryRuleXWCK row = (ProPrimaryRuleXWCK)this.proRXWCK.selectByMap(m).get(0);
        model.addAttribute("row", (Object)row);
        model.addAttribute("provinceList", (Object)RegionUtils.findDistrictByParentCode((String)"1", (String)""));
        model.addAttribute("bankCityList", (Object)RegionUtils.findDistrictByParentCode((String)"2", (String)row.getProvince_code()));
        return PRO_RXWCK_ADD;
    }

    @RequestMapping(value={"/win/findCity"})
    @ResponseBody
    public List<ComRegion> findDistrictByParentCode(String codeLevel, String parentCode) {
        List list = RegionUtils.findDistrictByParentCode((String)codeLevel, (String)parentCode);
        return list;
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/win/category/list"})
    public String winCategoryList(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        return PRO_CATEGORY_LIST;
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/query"}, method={RequestMethod.POST})
    @ResponseBody
    public Object query(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        PageResult pr = this.proS.query(params);
        CTLUtil.out((Object)pr, (HttpServletResponse)resp);
        return null;
    }

    @RequiresPermissions(value={"mypro:sr:add"})
    @RequestMapping(value={"/sr/add"}, method={RequestMethod.POST})
    @ResponseBody
    public Object srAdd(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.proS.srAdd(p);
    }

    @RequiresPermissions(value={"mypro:sr:upd"})
    @RequestMapping(value={"/sr/upd"}, method={RequestMethod.POST})
    @ResponseBody
    public Object srUpd(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.proS.srUpd(p);
    }

    @RequiresPermissions(value={"mypro:sr:del"})
    @RequestMapping(value={"/sr/del"}, method={RequestMethod.POST})
    @ResponseBody
    public Object srDel(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.proS.srDel(p);
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/querySR"}, method={RequestMethod.POST})
    @ResponseBody
    public Object querySR(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        CTLUtil.out((Object)this.proS.querySR(params), (HttpServletResponse)resp);
        return null;
    }

    @RequiresPermissions(value={"mypro:ecc:add"})
    @RequestMapping(value={"/ecc/file"}, method={RequestMethod.POST})
    @ResponseBody
    public Object eccFile(@RequestParam(value="excelFile") MultipartFile mFile, HttpServletRequest req, HttpServletResponse resp) {
        return this.proS.eCCFile(mFile);
    }

    @RequiresPermissions(value={"mypro:ecc:add"})
    @RequestMapping(value={"/ecc/add"}, method={RequestMethod.POST})
    @ResponseBody
    public Object eccAdd(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.proS.eCCAdd(p);
    }

    @RequiresPermissions(value={"mypro:ecc:upd"})
    @RequestMapping(value={"/ecc/upd"}, method={RequestMethod.POST})
    @ResponseBody
    public Object eccUpd(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.proS.eCCUpd(p);
    }

    @RequiresPermissions(value={"mypro:ecc:del"})
    @RequestMapping(value={"/ecc/del"}, method={RequestMethod.POST})
    @ResponseBody
    public Object eccDel(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.proS.eCCDel(p);
    }

    @RequiresPermissions(value={"mypro:ecc:batch_del"})
    @RequestMapping(value={"/ecc/batch_del"}, method={RequestMethod.POST})
    @ResponseBody
    public Object eccBatchDel(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.proS.eCCBatchDel(p);
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/queryECC"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryECC(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        CTLUtil.out((Object)this.proS.queryECC(params), (HttpServletResponse)resp);
        return null;
    }

    @RequiresPermissions(value={"mypro:rXWCK:add"})
    @RequestMapping(value={"/rXWCK/add"}, method={RequestMethod.POST})
    @ResponseBody
    public Object rXWCKAdd(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.proS.rXWCKAdd(p);
    }

    @RequiresPermissions(value={"mypro:rXWCK:upd"})
    @RequestMapping(value={"/rXWCK/upd"}, method={RequestMethod.POST})
    @ResponseBody
    public Object rXWCKUpd(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.proS.rXWCKUpd(p);
    }

    @RequiresPermissions(value={"mypro:rXWCK:del"})
    @RequestMapping(value={"/rXWCK/del"}, method={RequestMethod.POST})
    @ResponseBody
    public Object rXWCKDel(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.proS.rXWCKDel(p);
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/queryRXWCK"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryRXWCK(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        CTLUtil.out((Object)this.proS.queryRXWCK(params), (HttpServletResponse)resp);
        return null;
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/queryCategory"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryCategory(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        CTLUtil.out((Object)this.proS.queryCategory(params), (HttpServletResponse)resp);
        return null;
    }

    @RequiresPermissions(value={"mypro:pro:sync"})
    @RequestMapping(value={"/pro/sync"})
    @ResponseBody
    public Object proSync(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.proS.proSync(p);
    }

    @RequiresPermissions(value={"mypro:category:sync"})
    @RequestMapping(value={"/catetory/sync"})
    @ResponseBody
    public Object categorySync(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.proS.categorySync(p);
    }

    @RequiresPermissions(value={"mypro:win:list"})
    @RequestMapping(value={"/pro/addSource"}, method={RequestMethod.POST})
    @ResponseBody
    public R addSource(@RequestParam Map<Object, Object> params, HttpServletRequest request) {
        Map p = CTLUtil.init((HttpServletRequest)request, params);
        return this.proS.addSource(p, request);
    }
}

