/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.InfoNews;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.service.InfoNewsService;
import com.bcxin.ins.core.service.SysDictService;
import com.bcxin.ins.core.util.CTLUtil;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"${systemPath}/myinfo"})
public class InfoNewsController
extends BaseController {
    private static final String LIST = InfoNewsController.getViewPath((String)"admin/system/info_news_list");
    private static final String ADD_INFO = InfoNewsController.getViewPath((String)"admin/system/info_news_add");
    @Autowired
    private InfoNewsService infoNewsService;
    @Autowired
    private SysDictService sysDictService;

    @RequiresPermissions(value={"myinfo:win:list"})
    @RequestMapping(value={"/win/list"})
    public String winList(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        return LIST;
    }

    @RequestMapping(value={"/list/add"}, method={RequestMethod.GET})
    public String add(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        model.addAttribute("mark", (Object)"add");
        return ADD_INFO;
    }

    @RequestMapping(value={"/list/edit/{oid}"})
    public String edit(Model model, @RequestParam Map<Object, Object> params, @PathVariable Long oid) {
        InfoNews infoNews = (InfoNews)this.infoNewsService.selectById((Serializable)oid);
        String getRecommend_channel = infoNews.getRecommend_channel();
        String sort = infoNews.getSort();
        if ("999999999".equals(sort)) {
            infoNews.setSort("");
        }
        String json = JSON.toJSONStringWithDateFormat((Object)infoNews, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        model.addAttribute("oid", (Object)infoNews.getInfo_news_id());
        model.addAttribute("photo_url", (Object)infoNews.getPhoto_url());
        model.addAttribute("row", (Object)json);
        model.addAttribute("mark", (Object)"upd");
        return ADD_INFO;
    }

    @RequiresPermissions(value={"myinfo:win:list"})
    @RequestMapping(value={"/query"}, method={RequestMethod.POST})
    @ResponseBody
    public Object query(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        CTLUtil.out((Object)this.infoNewsService.query(params), (HttpServletResponse)resp);
        return null;
    }

    @RequiresPermissions(value={"myinfo:info:add"})
    @RequestMapping(value={"/info/add"}, method={RequestMethod.POST})
    @ResponseBody
    public Object wuAdd(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        this.response.setHeader("Access-Control-Allow-Origin", "*");
        R r = this.infoNewsService.infoNewsAdd(CTLUtil.init((HttpServletRequest)req, params));
        CTLUtil.out2((Object)r, (HttpServletResponse)this.response);
        return null;
    }

    @RequestMapping(value={"/rights"}, method={RequestMethod.POST})
    @ResponseBody
    public Object rights(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        return this.infoNewsService.getInfoNewsTypeList(params);
    }

    @RequiresPermissions(value={"myinfo:info:upd"})
    @RequestMapping(value={"/info/upd"}, method={RequestMethod.POST})
    @ResponseBody
    public Object wuUpd(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.infoNewsService.infoNewsUpd(p);
    }

    @RequiresPermissions(value={"myinfo:info:upd"})
    @RequestMapping(value={"/uploadFileImage"})
    @ResponseBody
    public R uploadFileImage(@RequestParam(value="upload_file", required=false) MultipartFile upload_file) throws Exception {
        try {
            if (upload_file != null && upload_file.getSize() > 0L) {
                return this.infoNewsService.doUploadFile(upload_file);
            }
            return new R(Boolean.valueOf(false), "\u8bf7\u9009\u62e9\u8981\u4e0a\u4f20\u7684\u6587\u4ef6");
        }
        catch (NullPointerException e) {
            return new R(Boolean.valueOf(false), "\u8bf7\u9009\u62e9\u4e0a\u4f20\u6587\u4ef6\u56fe\u7247");
        }
    }

    @RequiresPermissions(value={"myinfo:audit"})
    @RequestMapping(value={"/audit"}, method={RequestMethod.POST})
    @ResponseBody
    public R audit(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        if (!CTLUtil.pNotNull(params, (String[])new String[]{"id", "status"})) {
            return new R(Boolean.valueOf(false), "\u5fc5\u8981\u53c2\u6570\u786e\u5b9e");
        }
        if (!"0".equals(params.get("status")) && !"1".equals(params.get("status"))) {
            return new R(Boolean.valueOf(false), "\u503c\u9519\u8bef");
        }
        return this.infoNewsService.updateInfoNewsStatus(params);
    }
}

