/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.statistics.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.models.pro.dao.MyProMapper;
import com.bcxin.ins.models.statistics.dao.StatisticsMapper;
import com.bcxin.ins.models.statistics.service.StatisticsService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class StatisticsServiceImpl
implements StatisticsService {
    private static Logger log = LoggerFactory.getLogger(StatisticsServiceImpl.class);
    @Autowired
    private StatisticsMapper staM;
    @Autowired
    private MyProMapper proM;

    @Override
    public R user(Map<Object, Object> p) {
        int y = 2021;
        if (p.get("year") != null) {
            y = Integer.parseInt((String)p.get("year"));
        }
        int count = 13;
        int _m = 12;
        if (y == 1900 + new Date().getYear()) {
            _m = new Date().getMonth() + 1;
            count = _m + 1;
        }
        String[] yearArr = new String[_m];
        Integer[] blbs = new Integer[_m];
        Integer[] thrs = new Integer[_m];
        Integer[] alls = new Integer[_m];
        for (int i = 1; i < count; ++i) {
            String m = i < 10 ? "0" + i : String.valueOf(i);
            yearArr[i - 1] = y + "-" + m;
            blbs[i - 1] = this.staM.sta_user("1", yearArr[i - 1]);
            thrs[i - 1] = this.staM.sta_user("2", yearArr[i - 1]);
            alls[i - 1] = this.staM.sta_user("3", yearArr[i - 1]);
        }
        p.put("yms", yearArr);
        p.put("blbs", blbs);
        p.put("thrs", thrs);
        p.put("alls", alls);
        return new R(Boolean.valueOf(true), p);
    }

    @Override
    public R user_reg(Map<Object, Object> p) {
        int y = 2021;
        if (p.get("year") != null) {
            y = Integer.parseInt((String)p.get("year"));
        }
        int count = 13;
        int _m = 12;
        if (y == 1900 + new Date().getYear()) {
            _m = new Date().getMonth() + 1;
            count = _m + 1;
        }
        String[] yearArr = new String[_m];
        Integer[] xds = new Integer[_m];
        Integer[] cjs = new Integer[_m];
        int max = 0;
        for (int i = 1; i < count; ++i) {
            String m = i < 10 ? "0" + i : String.valueOf(i);
            yearArr[i - 1] = y + "-" + m;
            int bval = this.staM.user_reg("BLB", yearArr[i - 1]);
            if (max < bval) {
                max = bval;
            }
            xds[i - 1] = bval;
            int tval = this.staM.user_reg("", yearArr[i - 1]);
            cjs[i - 1] = tval;
        }
        p.put("yms", yearArr);
        p.put("xds", xds);
        p.put("cjs", cjs);
        return new R(Boolean.valueOf(true), p);
    }

    @Override
    public R pro_req(Map<Object, Object> p) {
        int y = 2021;
        if (p.get("year") != null) {
            y = Integer.parseInt((String)p.get("year"));
        }
        List<Map<Object, Object>> proList = this.proM.queryProTrue();
        String kw = "product/productInfo";
        JSONObject jsonP = new JSONObject();
        p.put("all", this.staM.keywork_pro(kw, String.valueOf(y)));
        JSONObject jsonC = new JSONObject();
        HashMap m = Maps.newHashMap();
        int max = 0;
        int val = 0;
        for (Map<Object, Object> map : proList) {
            val = this.staM.keywork_pro(kw + "/" + map.get("pro_primary_id"), String.valueOf(y));
            if (val != 0) {
                m.put(map.get("insurance_name"), val);
            }
            if (max >= val) continue;
            max = val;
        }
        p.put("charts", m);
        p.put("max", (max / 100 + 1) * 100);
        return new R(Boolean.valueOf(true), p);
    }

    @Override
    public R amt_pro(Map<Object, Object> p) {
        int y = 2021;
        if (p.get("year") != null) {
            y = Integer.parseInt((String)p.get("year"));
        }
        List<String> list = this.staM.pro_name_cb(String.valueOf(y));
        String[] pns = new String[list.size()];
        Integer[] pus = new Integer[list.size()];
        Double[] pms = new Double[list.size()];
        int l = list.size();
        for (int i = 0; i < l; ++i) {
            pns[i] = list.get(i);
            pus[i] = this.staM.pro_num_cb(list.get(i), String.valueOf(y));
            pms[i] = this.staM.pro_amt_cb(list.get(i), String.valueOf(y));
        }
        p.put("pns", pns);
        p.put("pus", pus);
        p.put("pms", pms);
        return new R(Boolean.valueOf(true), p);
    }

    @Override
    public R com_order(Map<Object, Object> p) {
        int y = 2021;
        if (p.get("year") != null) {
            y = Integer.parseInt((String)p.get("year"));
        }
        int count = 13;
        int _m = 12;
        if (y == 1900 + new Date().getYear()) {
            _m = new Date().getMonth() + 1;
            count = _m + 1;
        }
        String[] yearArr = new String[_m];
        Integer[] xds = new Integer[_m];
        Integer[] cjs = new Integer[_m];
        Double[] bls = new Double[_m];
        int max = 0;
        int val = 0;
        for (int i = 1; i < count; ++i) {
            String m = i < 10 ? "0" + i : String.valueOf(i);
            yearArr[i - 1] = y + "-" + m;
            val = this.staM.com_order("", yearArr[i - 1]);
            if (max < val) {
                max = val;
            }
            xds[i - 1] = val;
            cjs[i - 1] = this.staM.com_order("1", yearArr[i - 1]);
            if (cjs[i - 1] <= 0) continue;
            double bl = Double.valueOf(cjs[i - 1].intValue()) / Double.valueOf(xds[i - 1].intValue());
            bls[i - 1] = BigDecimal.valueOf(bl).multiply(BigDecimal.valueOf(Double.parseDouble("100"))).setScale(2, 4).doubleValue();
        }
        p.put("yms", yearArr);
        p.put("xds", xds);
        p.put("cjs", cjs);
        p.put("bls", bls);
        p.put("max", (max / 100 + 1) * 100);
        return new R(Boolean.valueOf(true), p);
    }

    @Override
    public R pro_order(Map<Object, Object> p) {
        String ym = (String)p.get("ym");
        if (ym.length() == 6) {
            ym = ym.substring(0, 5) + "0" + ym.substring(5, 6);
        }
        List<String> pNameList = this.staM.pro_order(ym);
        String cName = "";
        String cNames = "";
        String counts = "";
        int count = 0;
        int num = 0;
        for (String name : pNameList) {
            if (!name.equals(cName)) {
                if (count > 0) {
                    counts = counts + "," + count;
                }
                count = 0;
                cName = name;
                cNames = cNames + "," + name;
            }
            ++count;
            if (++num != pNameList.size()) continue;
            counts = counts + "," + count;
        }
        cNames = cNames.substring(1, cNames.length());
        counts = counts.substring(1, counts.length());
        String[] nameArr = cNames.split(",");
        String[] countArr = counts.split(",");
        ArrayList list = Lists.newArrayList();
        HashMap mapc = null;
        for (int i = 0; i < countArr.length; ++i) {
            mapc = Maps.newHashMap();
            mapc.put("name", nameArr[i]);
            mapc.put("value", countArr[i]);
            list.add(mapc);
        }
        p.put("list", list);
        p.put("names", cNames);
        return new R(Boolean.valueOf(true), p);
    }

    @Override
    public R pro_order_amout(Map<Object, Object> p) {
        String ym = (String)p.get("ym");
        if (ym.length() == 6) {
            ym = ym.substring(0, 5) + "0" + ym.substring(5, 6);
        }
        List<String> pNameList = this.staM.pro_order(ym);
        String cName = "";
        String cNames = "";
        String counts = "";
        int count = 0;
        int num = 0;
        if (pNameList.size() == 0) {
            return new R(Boolean.valueOf(false), "\u65e0\u8bb0\u5f55");
        }
        for (String name : pNameList) {
            if (!name.equals(cName)) {
                if (count > 0) {
                    counts = counts + "," + count;
                }
                count = 0;
                cName = name;
                cNames = cNames + "," + name;
            }
            ++count;
            if (++num != pNameList.size()) continue;
            counts = counts + "," + count;
        }
        cNames = cNames.substring(1, cNames.length());
        String[] nameArr = cNames.split(",");
        ArrayList list = Lists.newArrayList();
        HashMap mapc = null;
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal amounts = BigDecimal.ZERO;
        for (int i = 0; i < nameArr.length; ++i) {
            amt = this.staM.pro_order_amout(ym, nameArr[i]);
            amounts = amounts.add(amt);
            mapc = Maps.newHashMap();
            mapc.put("name", nameArr[i]);
            mapc.put("value", String.valueOf(amt));
            list.add(mapc);
        }
        p.put("list", list);
        p.put("names", cNames);
        p.put("amounts", amounts);
        return new R(Boolean.valueOf(true), p);
    }

    @Override
    public R all_amt(Map<Object, Object> p) {
        int y = 2021;
        if (p.get("year") != null) {
            y = Integer.parseInt((String)p.get("year"));
        }
        int count = 13;
        int _m = 12;
        if (y == 1900 + new Date().getYear()) {
            _m = new Date().getMonth() + 1;
            count = _m + 1;
        }
        String ym = "";
        Integer[] xds = new Integer[_m];
        Integer[] cjs = new Integer[_m];
        Double[] bls = new Double[_m];
        BigDecimal all = BigDecimal.ZERO;
        BigDecimal max = BigDecimal.ZERO;
        ArrayList cls = null;
        ArrayList pls = Lists.newArrayList();
        for (int i = 1; i < count; ++i) {
            String m = i < 10 ? "0" + i : String.valueOf(i);
            ym = y + "-" + m;
            BigDecimal val = this.staM.all_amt(ym);
            if (val == null) {
                val = BigDecimal.ZERO;
            }
            if (max.compareTo(val) < 0) {
                max = val;
            }
            all = all.add(val);
            cls = Lists.newArrayList();
            cls.add(ym);
            cls.add(val);
            pls.add(cls);
        }
        p.put("pls", pls);
        int s = String.valueOf(max.intValue()).length();
        String n = String.valueOf(Integer.parseInt(String.valueOf(max).substring(0, 1)) + 1);
        for (int i = 1; i < s; ++i) {
            n = n + "0";
        }
        p.put("max", Integer.valueOf(n));
        p.put("amounts", all);
        return new R(Boolean.valueOf(true), p);
    }

    public static void main(String[] args) {
        BigDecimal a = new BigDecimal("2340575.98");
        int s = String.valueOf(Integer.parseInt(String.valueOf(a))).length();
        System.out.println(s);
    }
}

