/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.models.order.policy.dao.InsTransactionDao;
import com.bcxin.ins.models.order.policy.service.InsTransactionService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.DateUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.TransactionVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsTransactionServiceImpl
extends ServiceImpl<InsTransactionDao, InsTransaction>
implements InsTransactionService {
    @Autowired
    private InsTransactionDao dao;

    @Override
    public List<InsTransaction> selectInsTransactionByInsOrderForm(Long oid) {
        return this.dao.selectInsTransactionByInsOrderForm(oid);
    }

    public InsTransaction initInsTransaction() {
        InsTransaction insTransaction = new InsTransaction();
        this.dao.insert(insTransaction);
        return insTransaction;
    }

    @Override
    public List<TransactionVo> packagingTransactionVoListByInsTransactionList(List<InsTransaction> itList) {
        ArrayList<TransactionVo> voList = new ArrayList<TransactionVo>();
        for (InsTransaction it : itList) {
            voList.add(this.accordingToInsTransactionIntoTransactionVo(it));
        }
        return voList;
    }

    @Override
    public void accordingToTheTransactionVoSetUpInsTransaction(TransactionVo vo, Long insTransaction_id) {
        InsTransaction insTransaction = null;
        insTransaction = StrUtil.isNotBlank((CharSequence)vo.getOid()) ? this.dao.selectById(Long.parseLong(vo.getOid())) : this.initInsTransaction();
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insTransaction);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dao.updateById(insTransaction);
    }

    @Override
    public TransactionVo accordingToInsTransactionIntoTransactionVo(InsTransaction insTransaction) {
        TransactionVo vo = new TransactionVo();
        if (insTransaction == null) {
            return vo;
        }
        vo.setOid(String.valueOf(insTransaction.getIns_transaction_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insTransaction), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public void setOrderFormVoOfShowUrlByOrderID(OrderFormVo vo, Long order_id) {
        InsTransaction insTransaction;
        List<InsTransaction> insTransactionList = this.selectInsTransactionByInsOrderForm(order_id);
        if (insTransactionList.size() > ConstProp.INT_NUMBER_ZERO && StrUtil.isNotBlank((CharSequence)(insTransaction = insTransactionList.get(ConstProp.INT_NUMBER_ZERO)).getDeal_url())) {
            vo.setShow_url(insTransaction.getDeal_url());
        }
    }

    @Override
    public void uploadPayMentFileToTranction(String path_url, InsInsuranceSlip insurance_slip, String path_sign) {
        InsTransaction it = new InsTransaction();
        it.setStart_time((Date)DateUtil.getTimestamp());
        IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
        it.setTrade_serial_number(String.valueOf(idWorker.nextId()));
        it.setPayment_method("6");
        it.getInsurance_slip().setIns_insurance_slip_id(insurance_slip.getIns_insurance_slip_id());
        it.setUser_id(insurance_slip.getRegister_user_id());
        it.setPath_sign(path_sign);
        it.setPay_order_url(path_url);
        this.dao.insert(it);
    }

    @Override
    public String accordingToOrderIDGainPathSign(String order_id) {
        List<InsTransaction> insTransactionList = this.selectInsTransactionByInsOrderForm(Long.parseLong(order_id));
        String pathSign = "1-0";
        if (insTransactionList != null) {
            for (InsTransaction it : insTransactionList) {
                if (!"2".equals(it.getTransaction_status())) continue;
                pathSign = it.getPath_sign() + "-1";
            }
            if ("1-0".equals(pathSign)) {
                pathSign = String.valueOf(insTransactionList.size() + 1) + "-0";
            }
        }
        return pathSign;
    }
}

