/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.entity.common.ComBuyers;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.models.order.policy.dao.InsTopBuyersDao;
import com.bcxin.ins.models.order.policy.service.InsBuyersService;
import com.bcxin.ins.models.order.policy.service.InsTopBuyersService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.DateUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.BuyersVo_two;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.TopBuyersVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsTopBuyersServiceImpl
extends ServiceImpl<InsTopBuyersDao, StTopBuyers>
implements InsTopBuyersService {
    @Autowired
    private InsTopBuyersDao dao;
    @Autowired
    private InsBuyersService insBuyersService;

    @Override
    public StTopBuyers packagingInsTopBuyers(Long oid) {
        return this.dao.getInsTopBuyers(oid);
    }

    @Override
    public List<StTopBuyers> selectInsTopBuyersBySpecialID(Long oid) {
        return this.dao.selectInsTopBuyersBySpecialID(oid);
    }

    @Override
    public void setTopBuyersByTopBuyersVo(List<TopBuyersVo> voList, Long special_id) {
        if (voList != null && voList.size() > ConstProp.INT_NUMBER_ZERO) {
            this.ruleOutDoesNotExist(voList, special_id);
            for (TopBuyersVo vo : voList) {
                this.accordingToTheTopBuyersVoSetUpInsTopBuyers(vo, special_id);
            }
        }
    }

    private void ruleOutDoesNotExist(List<TopBuyersVo> voList, Long special_id) {
        List<StTopBuyers> tbList = this.selectInsTopBuyersBySpecialID(special_id);
        for (StTopBuyers itb : tbList) {
            int i = ConstProp.INT_NUMBER_ZERO;
            for (TopBuyersVo vo : voList) {
                if (!StrUtil.isNotBlank((CharSequence)vo.getOid()) || itb.getSt_top_buyers_id() != Long.parseLong(vo.getOid())) continue;
                i = ConstProp.INT_NUMBER_ONE;
            }
            if (i != 0) continue;
            this.dao.deleteById(itb.getSt_top_buyers_id());
        }
    }

    @Override
    public void accordingToTheTopBuyersVoSetUpInsTopBuyers(TopBuyersVo vo, Long special_id) {
        StTopBuyers insTopBuyers = null;
        ComBuyers insBuyers = null;
        if (StrUtil.isNotBlank((CharSequence)vo.getOid())) {
            insTopBuyers = this.dao.selectById(Long.parseLong(vo.getOid()));
            insBuyers = (ComBuyers)this.insBuyersService.selectById(insTopBuyers.getCom_buyer().getCom_buyer_id());
            insTopBuyers.setUpdate_time((Date)DateUtil.getTimestamp());
            insTopBuyers.setCom_buyer(insBuyers);
        } else {
            insTopBuyers = new StTopBuyers();
            insTopBuyers.setCreate_time((Date)DateUtil.getTimestamp());
            insTopBuyers.setSpecial_id(special_id);
            if (StrUtil.isNotBlank((CharSequence)vo.getCode())) {
                insBuyers = this.insBuyersService.selectInsBuyersByCode(vo.getCode());
                if (insBuyers == null) {
                    insBuyers = this.insBuyersService.selectInsBuyersBySomeField(vo.getCustomer_name(), vo.getAddress(), vo.getCountry());
                }
            } else {
                insBuyers = this.insBuyersService.selectInsBuyersBySomeField(vo.getCustomer_name(), vo.getAddress(), vo.getCountry());
            }
            insTopBuyers.setCom_buyer(insBuyers);
            this.dao.insert(insTopBuyers);
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insTopBuyers);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)vo), (Object)insBuyers);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insBuyersService.updateById(insBuyers);
        insTopBuyers.setApply_type("0");
        this.dao.updateById(insTopBuyers);
    }

    @Override
    public List<TopBuyersVo> getTopBuyersVoListBySpecialID(Long special_id) {
        ArrayList<TopBuyersVo> voList = new ArrayList<TopBuyersVo>();
        List<StTopBuyers> bList = this.selectInsTopBuyersBySpecialID(special_id);
        if (bList != null && bList.size() > 0) {
            for (StTopBuyers tb : bList) {
                voList.add(this.accordingToInsTopBuyersIntoTopBuyersVo(tb));
            }
        }
        return voList;
    }

    @Override
    public TopBuyersVo accordingToInsTopBuyersIntoTopBuyersVo(StTopBuyers tb) {
        TopBuyersVo vo = new TopBuyersVo();
        if (tb == null) {
            return vo;
        }
        vo.setOid(String.valueOf(tb.getSt_top_buyers_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)tb), (Object)vo);
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)tb.getCom_buyer()), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public boolean updateTopBuyerForDelStatus(Long oid) {
        StTopBuyers buyers = (StTopBuyers)this.selectById(oid);
        buyers.setApply_type("4");
        this.dao.updateById(buyers);
        return false;
    }

    @Override
    public List<StTopBuyers> findTopBuyers(DwzPage page, TopBuyersVo buyersVo) {
        List<StTopBuyers> bList = this.dao.findTopBuyers(buyersVo);
        return bList;
    }

    @Override
    public List<StTopBuyers> getInsTopBuyersByOrderFormId(Long orderFormId, DwzPage page) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<StTopBuyers> lis = this.dao.getInsTopBuyersByOrderFormId((Page<StTopBuyers>)pageHelper, orderFormId);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return lis.size() > ConstProp.INT_NUMBER_ZERO ? lis : null;
    }

    @Override
    public TopBuyersVo accordingToInsBuyersIntoTopBuyersVo(ComBuyers insBuyers) {
        TopBuyersVo vo = new TopBuyersVo();
        if (insBuyers == null) {
            return vo;
        }
        vo.setOid(String.valueOf(insBuyers.getCom_buyer_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insBuyers), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public List<BuyersVo_two> getBuyersVoTwoByOrderFormId(Long orderFormId, DwzPage page) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<BuyersVo_two> lis = this.dao.getBuyersVoTwoByOrderFormId((Page<StTopBuyers>)pageHelper, orderFormId);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return lis.size() > ConstProp.INT_NUMBER_ZERO ? lis : null;
    }

    @Override
    public List<TopBuyersVo> findTopBuyersOrder(DwzPage page, SysUser user) {
        InsInsuranceSlip insOrderForm = new InsInsuranceSlip();
        return this.dao.findTopBuyersOrder(insOrderForm);
    }

    @Override
    public TopBuyersVo getBuyersVoById(Long oid) {
        List<TopBuyersVo> lis = this.dao.getBuyersVoById(oid);
        if (null != lis) {
            return lis.get(0);
        }
        return null;
    }

    @Override
    public List<StTopBuyers> selectInsTopBuyersListBySpecialID(DwzPage page, TopBuyersVo topBuyersVo) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<StTopBuyers> list = this.dao.selectInsTopBuyersListBySpecialID((Page<StTopBuyers>)pageHelper, topBuyersVo);
        page.setTotalCount(pageHelper.getTotal());
        return list;
    }

    @Override
    public boolean updTopFreeAmount(String oid, Long userId, Long status, BigDecimal amount) {
        StTopBuyers topBuyers = (StTopBuyers)this.dao.selectById((Serializable)((Object)oid));
        BigDecimal replyAmount = topBuyers.getReply_amount();
        BigDecimal unUserdAmount = topBuyers.getUnused_amount();
        BigDecimal userdAmount = topBuyers.getUnused_amount();
        if (status == 1L) {
            if (unUserdAmount.compareTo(amount) >= 0) {
                topBuyers.setUnused_amount(unUserdAmount.subtract(amount));
                topBuyers.setUserd_amount(userdAmount.add(amount));
                this.insert(topBuyers);
                return true;
            }
        } else if (status == 2L && replyAmount.compareTo(unUserdAmount.add(amount)) >= 0) {
            topBuyers.setUnused_amount(unUserdAmount.add(amount));
            topBuyers.setUserd_amount(userdAmount.subtract(amount));
            this.dao.insert(topBuyers);
            return true;
        }
        return false;
    }

    @Override
    public List<BuyersVo_two> findBuyersListByOrderFormIdAndSearch(Long orderFormId, DwzPage page, String countrySearch, String companySearch) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        List<BuyersVo_two> lis = this.dao.findBuyersListByOrderFormIdAndSearch((Page<StTopBuyers>)pageHelper, orderFormId, countrySearch, companySearch);
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return lis.size() > ConstProp.INT_NUMBER_ZERO ? lis : null;
    }

    @Override
    public Long getInsTopBuyerPifu(Long userId, Long type) {
        return this.dao.getInsTopBuyerPifu(userId, type);
    }

    @Override
    public Long getInsTopBuyerWPifu(Long userId, Long type) {
        return this.dao.getInsTopBuyerWPifu(userId, type);
    }

    @Override
    public List<TopBuyersVo> findPifuList(Long userId, Long type, DwzPage page, String statusType) {
        if (statusType.equals("0")) {
            Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
            List<TopBuyersVo> list = this.dao.findNoPifuList((Page<TopBuyersVo>)pageHelper, userId, type);
            page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
            return list;
        }
        if (statusType.equals("1")) {
            Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
            List<TopBuyersVo> list = this.dao.findPifuList((Page<TopBuyersVo>)pageHelper, userId, type);
            page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
            return list;
        }
        return null;
    }
}

