/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.core.service.ComDeployConfigService;
import com.bcxin.ins.core.service.SysUserService;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.entity.policy_core.InsAgreement;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsMailPolicy;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.entity.policy_core.InsUnderwrite;
import com.bcxin.ins.entity.policy_special.SpecialBid;
import com.bcxin.ins.entity.policy_special.SpecialCreditMicro;
import com.bcxin.ins.entity.policy_special.SpecialCreditSt;
import com.bcxin.ins.entity.policy_special.SpecialLitigation;
import com.bcxin.ins.entity.policy_special.SpecialPerformance;
import com.bcxin.ins.entity.policy_special.SpecialPublicDuty;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.models.order.policy.dao.InsInsuranceSlipDao;
import com.bcxin.ins.models.order.policy.service.InsAgreementService;
import com.bcxin.ins.models.order.policy.service.InsCommonExportService;
import com.bcxin.ins.models.order.policy.service.InsInsuranceSlipService;
import com.bcxin.ins.models.order.policy.service.InsMailPolicyService;
import com.bcxin.ins.models.order.policy.service.InsMicroExportService;
import com.bcxin.ins.models.order.policy.service.InsRiskDutyService;
import com.bcxin.ins.models.order.policy.service.InsRoleInpolicyService;
import com.bcxin.ins.models.order.policy.service.InsTransactionService;
import com.bcxin.ins.models.order.policy.service.InsUnderwriteService;
import com.bcxin.ins.models.order.policy.service.SpecialBidService;
import com.bcxin.ins.models.order.policy.service.SpecialLitigationService;
import com.bcxin.ins.models.order.policy.service.SpecialPerformanceService;
import com.bcxin.ins.models.order.policy.service.SpecialPublicDutyService;
import com.bcxin.ins.models.product.service.InsProductResponsibilityService;
import com.bcxin.ins.models.product.service.InsProductService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.email.EmailModel;
import com.bcxin.ins.util.email.SendEmailAndMsgUtil;
import com.bcxin.ins.util.excel.ExcelUtil;
import com.bcxin.ins.util.toolbox.DateUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsurePolicyVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.OrderStatusCountVo;
import com.bcxin.ins.vo.ResponsibilityVo;
import com.bcxin.ins.vo.excel.PolicyExcelVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.xiaoleilu.hutool.thread.ThreadUtil;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InsInsuranceSlipServiceImpl
extends ServiceImpl<InsInsuranceSlipDao, InsInsuranceSlip>
implements InsInsuranceSlipService {
    private Logger log = LoggerFactory.getLogger(InsInsuranceSlipServiceImpl.class);
    @Autowired
    private InsCommonExportService insCommonExportService;
    @Autowired
    private InsMicroExportService insMicroExportService;
    @Autowired
    private InsRoleInpolicyService insRoleInpolicyService;
    @Autowired
    private InsProductService insProductService;
    @Autowired
    private InsUnderwriteService insUnderwriteService;
    @Autowired
    private InsMailPolicyService insMailPolicyService;
    @Autowired
    private InsProductResponsibilityService insProductResponsibilityService;
    @Autowired
    private InsInsuranceSlipDao dao;
    @Autowired
    private InsTransactionService insTransactionService;
    @Autowired
    private ComDeployConfigService configService;
    @Autowired
    private InsAgreementService insAgreementService;
    @Autowired
    private InsRiskDutyService insRiskDutyService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SpecialLitigationService specialLitigationService;
    @Autowired
    private SpecialBidService specialBidService;
    @Autowired
    private SpecialPerformanceService specialPerformanceService;
    @Autowired
    private SpecialPublicDutyService specialPublicDutyService;

    @Override
    public InsInsuranceSlip selectById(Long oid) {
        InsInsuranceSlip insInsuranceSlip = this.dao.selectById(oid);
        if (insInsuranceSlip != null) {
            this.insMailPolicyService.throughTheInsInsuranceSlipForInsMailPolicySetUpInsInsuranceSlip(insInsuranceSlip);
            this.insUnderwriteService.throughTheInsInsuranceSlipForInsUnderwriteSetUpInsInsuranceSlip(insInsuranceSlip);
            insInsuranceSlip.setInsTransaction(this.insTransactionService.selectInsTransactionByInsOrderForm(insInsuranceSlip.getIns_insurance_slip_id()));
        }
        return insInsuranceSlip;
    }

    @Override
    public InsInsuranceSlip packagingInsInsuranceSlip(Long oid) {
        SpecialPublicDuty specialPublicDuty;
        InsInsuranceSlip insInsuranceSlip = this.selectById(oid);
        if (insInsuranceSlip == null) {
            return insInsuranceSlip;
        }
        insInsuranceSlip.setRoles(this.insRoleInpolicyService.selectInsRoleInpolicyByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id()));
        ProPrimary insProduct = (ProPrimary)this.insProductService.selectById(insInsuranceSlip.getPro_primary().getPro_primary_id());
        insInsuranceSlip.setPro_primary(insProduct);
        if (StringUtils.isEmpty((CharSequence)insProduct.getProduct_code())) {
            return insInsuranceSlip;
        }
        if ("XYX-XWCK".equals(insProduct.getProduct_code())) {
            SpecialCreditMicro insMicroExport = (SpecialCreditMicro)this.insMicroExportService.selectById(insInsuranceSlip.getSpecial_id());
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), insMicroExport);
            insInsuranceSlip.setSpecial_id(insMicroExport.getSpecial_credit_micro_id());
        } else if ("XYX-DQCK".equals(insProduct.getProduct_code())) {
            SpecialCreditSt insCommonExport = this.insCommonExportService.getInsCommonExportBusiness(insInsuranceSlip.getSpecial_id());
            if (insCommonExport != null && insCommonExport.getSpecial_credit_st_id() != null) {
                insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), insCommonExport);
                insInsuranceSlip.setSpecial_id(insCommonExport.getSpecial_credit_st_id());
            }
        } else if ("BZX-TB-GCTB".equals(insProduct.getProduct_code())) {
            SpecialBid specialBid = (SpecialBid)this.specialBidService.selectById(insInsuranceSlip.getSpecial_id());
            if (specialBid != null && specialBid.getSpecial_bid_id() != null) {
                insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialBid);
                insInsuranceSlip.setSpecial_id(specialBid.getSpecial_bid_id());
            }
        } else if ("BZX-YG-GCTB".equals(insProduct.getProduct_code())) {
            SpecialBid specialBid = (SpecialBid)this.specialBidService.selectById(insInsuranceSlip.getSpecial_id());
            if (specialBid != null && specialBid.getSpecial_bid_id() != null) {
                insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialBid);
                insInsuranceSlip.setSpecial_id(specialBid.getSpecial_bid_id());
            }
        } else if ("BZX-GCLY".equals(insProduct.getProduct_code())) {
            SpecialPerformance specialPerformance = (SpecialPerformance)this.specialPerformanceService.selectById(insInsuranceSlip.getSpecial_id());
            if (specialPerformance != null && specialPerformance.getSpecial_performance_id() != null) {
                insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialPerformance);
                insInsuranceSlip.setSpecial_id(specialPerformance.getSpecial_performance_id());
            }
        } else if ("BZX-SSBQ".equals(insProduct.getProduct_code())) {
            SpecialLitigation specialLitigation = this.specialLitigationService.getSpecialLitigationBusiness(insInsuranceSlip.getSpecial_id());
            if (specialLitigation != null && specialLitigation.getSpecial_litigation_id() != null) {
                insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialLitigation);
                insInsuranceSlip.setSpecial_id(specialLitigation.getSpecial_litigation_id());
            }
        } else if ("GZX".equals(insProduct.getProduct_code().split("-")[0]) && (specialPublicDuty = (SpecialPublicDuty)this.specialPublicDutyService.selectById(insInsuranceSlip.getSpecial_id())) != null && specialPublicDuty.getSpecial_public_duty_id() != null) {
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialPublicDuty);
            insInsuranceSlip.setSpecial_id(specialPublicDuty.getSpecial_public_duty_id());
        }
        return insInsuranceSlip;
    }

    @Override
    public InsInsuranceSlip initOrderForm(Long poductID, Long user_id) {
        InsInsuranceSlip insInsuranceSlip = new InsInsuranceSlip();
        IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
        insInsuranceSlip.setTrade_serial_number(String.valueOf(idWorker.nextId()));
        insInsuranceSlip.setStart_time((Date)DateUtil.getTimestamp());
        insInsuranceSlip.setRegister_user_id(user_id);
        insInsuranceSlip.setUnderwrite(this.insUnderwriteService.initInsUnderwrite());
        insInsuranceSlip.setMailPolicy(this.insMailPolicyService.initInsMailPolicy());
        ProPrimary insProduct = (ProPrimary)this.insProductService.selectById(poductID);
        insInsuranceSlip.setPro_primary(insProduct);
        if (StringUtils.isEmpty((CharSequence)insProduct.getProduct_code())) {
            this.dao.insert(insInsuranceSlip);
            return insInsuranceSlip;
        }
        if ("XYX-XWCK".equals(insProduct.getProduct_code())) {
            SpecialCreditMicro insMicroExport = this.insMicroExportService.initInsMicroExport();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), insMicroExport);
            insInsuranceSlip.setSpecial_id(insMicroExport.getSpecial_credit_micro_id());
        } else if ("XYX-DQCK".equals(insProduct.getProduct_code())) {
            SpecialCreditSt insCommonExport = this.insCommonExportService.initInsCommonExport();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), insCommonExport);
            insInsuranceSlip.setSpecial_id(insCommonExport.getSpecial_credit_st_id());
        } else if ("BZX-TB-GCTB".equals(insProduct.getProduct_code())) {
            SpecialBid specialBid = this.specialBidService.initInsSpecialBid();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialBid);
            insInsuranceSlip.setSpecial_id(specialBid.getSpecial_bid_id());
        } else if ("BZX-YG-GCTB".equals(insProduct.getProduct_code())) {
            SpecialBid specialBid = this.specialBidService.initInsSpecialBid();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialBid);
            insInsuranceSlip.setSpecial_id(specialBid.getSpecial_bid_id());
        } else if ("BZX-GCLY".equals(insProduct.getProduct_code())) {
            SpecialPerformance specialPerformance = this.specialPerformanceService.initInsSpecialPerformance();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialPerformance);
            insInsuranceSlip.setSpecial_id(specialPerformance.getSpecial_performance_id());
        } else if ("BZX-SSBQ".equals(insProduct.getProduct_code())) {
            SpecialLitigation specialLitigation = this.specialLitigationService.initSpecialLitigation();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialLitigation);
            insInsuranceSlip.setSpecial_id(specialLitigation.getSpecial_litigation_id());
        } else if ("GZX".equals(insProduct.getProduct_code().split("-")[0])) {
            SpecialPublicDuty specialPublicDuty = this.specialPublicDutyService.initSpecialPublicDuty();
            insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialPublicDuty);
            insInsuranceSlip.setSpecial_id(specialPublicDuty.getSpecial_public_duty_id());
        }
        this.dao.insert(insInsuranceSlip);
        return insInsuranceSlip;
    }

    @Override
    public InsurePolicyVo willInsInsuranceSlipChangeIntoInsurePolicyVo(Long insInsuranceSlip_id) {
        InsurePolicyVo vo = new InsurePolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.packagingInsInsuranceSlip(insInsuranceSlip_id);
        if (insInsuranceSlip == null) {
            return vo;
        }
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setMailPolicy_id(String.valueOf(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id()));
        if (insInsuranceSlip.getUnderwrite() != null) {
            vo.setUnderwrite_id(String.valueOf(insInsuranceSlip.getUnderwrite().getUnderwrite_id()));
        }
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        return vo;
    }

    @Override
    public void getInsuredAmountSetToInsInsuranceSlip(BigDecimal insuredAmount, InsInsuranceSlip iis) {
        iis.setInsured_amount(insuredAmount);
        this.dao.updateById(iis);
    }

    @Override
    public void accordingToOrderIDCreatePolicySerialNumber(InsInsuranceSlip insInsuranceSlip) {
        IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
        insInsuranceSlip.setPolicy_serial_number("BCX-" + String.valueOf(idWorker.nextId()) + "A");
        this.dao.updateById(insInsuranceSlip);
    }

    @Override
    public void dbSave(InsInsuranceSlip insInsuranceSlip) {
        this.dao.insert(insInsuranceSlip);
    }

    @Override
    public InsInsuranceSlip getInsOrderForm(Long oid) {
        InsInsuranceSlip insInsuranceSlip = this.selectById(oid);
        if (insInsuranceSlip != null) {
            ProPrimary insProduct = (ProPrimary)this.insProductService.selectById(insInsuranceSlip.getPro_primary().getPro_primary_id());
            insInsuranceSlip.setPro_primary(insProduct);
        }
        return insInsuranceSlip;
    }

    @Override
    public InsInsuranceSlip getInsOrderForm(String tradeSerialNumber) {
        InsInsuranceSlip insOrderForm = this.dao.selectByTradeSerialNumber(tradeSerialNumber);
        if (insOrderForm != null) {
            insOrderForm.setInsTransaction(this.insTransactionService.selectInsTransactionByInsOrderForm(insOrderForm.getIns_insurance_slip_id()));
        }
        return insOrderForm;
    }

    @Override
    public InsInsuranceSlip packagingInsOrderForm(Long oid) {
        return this.packagingInsInsuranceSlip(oid);
    }

    @Override
    public List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatus(Long user_id, String status, DwzPage page) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        ArrayList<InsInsuranceSlip> list = new ArrayList<InsInsuranceSlip>();
        List<InsInsuranceSlip> insOrderFormList = this.dao.selectInsOrderFormByUserIDAndStatus((Page<InsInsuranceSlip>)pageHelper, user_id, status);
        for (InsInsuranceSlip order : insOrderFormList) {
            list.add(this.packagingInsOrderForm(order.getIns_insurance_slip_id()));
        }
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return list;
    }

    public List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatusList(Long user_id, List<String> statusList, DwzPage page) {
        Page pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
        ArrayList<InsInsuranceSlip> list = new ArrayList<InsInsuranceSlip>();
        List<InsInsuranceSlip> insOrderFormList = this.dao.selectInsOrderFormByUserIDAndStatusList((Page<InsInsuranceSlip>)pageHelper, user_id, statusList);
        for (InsInsuranceSlip order : insOrderFormList) {
            list.add(this.packagingInsOrderForm(order.getIns_insurance_slip_id()));
        }
        page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
        return list;
    }

    @Override
    public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(Long user_id, String status, DwzPage page) {
        ArrayList<OrderFormVo> voList = new ArrayList<OrderFormVo>();
        List<InsInsuranceSlip> orderList = this.selectInsOrderFormByUserIDAndStatus(user_id, status, page);
        for (InsInsuranceSlip order : orderList) {
            voList.add(this.willInsOrderFormSetUpOrderFormVo(order));
        }
        return voList;
    }

    @Override
    public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusListSetUpOrderFormVo(Long user_id, List<String> statusList, DwzPage page) {
        ArrayList<OrderFormVo> voList = new ArrayList<OrderFormVo>();
        List<InsInsuranceSlip> orderList = this.selectInsOrderFormByUserIDAndStatusList(user_id, statusList, page);
        for (InsInsuranceSlip insInsuranceSlip : orderList) {
            voList.add(this.willInsOrderFormSetUpOrderFormVo(insInsuranceSlip));
        }
        return voList;
    }

    @Override
    public OrderFormVo willInsOrderFormSetUpOrderFormVo(InsInsuranceSlip insInsuranceSlip) {
        ProPrimary insProduct;
        List insurenceRoles;
        List applicantRoles;
        OrderFormVo vo = new OrderFormVo();
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
        SysUser user = (SysUser)this.sysUserService.selectById((Serializable)insInsuranceSlip.getRegister_user_id());
        if (user != null) {
            vo.setLogin_name(user.getLoginName());
        }
        if (insInsuranceSlip.getStart_time() != null) {
            vo.setStart_time(DateUtil.formatDate((Date)insInsuranceSlip.getStart_time()));
        }
        if (!("1".equals(insInsuranceSlip.getOrder_status()) || "2".equals(insInsuranceSlip.getOrder_status()) || "3".equals(insInsuranceSlip.getOrder_status()))) {
            InsAgreement insAgreement = this.insAgreementService.selectInsAgreementByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id());
            vo.setExternal_reference(insAgreement != null ? insAgreement.getExternal_reference() : "");
        }
        if (insInsuranceSlip.getPremium() != null) {
            vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
            vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
        }
        if (insInsuranceSlip.getPro_primary() != null) {
            vo.setProduct_oid(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        }
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.formatDate((Date)insInsuranceSlip.getInception_date()));
        }
        if (insInsuranceSlip.getPlanned_end_date() != null) {
            vo.setPlanned_end_date(DateUtil.formatDate((Date)insInsuranceSlip.getPlanned_end_date()));
        }
        if (StrUtil.isNotBlank((CharSequence)insInsuranceSlip.getPolicy_serial_number())) {
            vo.setPolicy_serial_number(insInsuranceSlip.getPolicy_serial_number());
        }
        if (StrUtil.isNotBlank((CharSequence)insInsuranceSlip.getOrder_status())) {
            vo.setPolicy_status(insInsuranceSlip.getOrder_status());
        }
        this.insProductService.accordingToProductIDToGetInsProductSetUpOrderFormVo(vo, insInsuranceSlip.getPro_primary().getPro_primary_id());
        this.insTransactionService.setOrderFormVoOfShowUrlByOrderID(vo, insInsuranceSlip.getIns_insurance_slip_id());
        if (insInsuranceSlip.getStart_time() != null) {
            vo.setStart_time(DateUtil.formatDateTime((Date)insInsuranceSlip.getStart_time()));
        }
        if ((applicantRoles = insInsuranceSlip.getRolesOfKind("1")) != null) {
            vo.setApplicant_name(((InsRoleInpolicy)applicantRoles.get(0)).getName_cn());
        }
        if ((insurenceRoles = insInsuranceSlip.getRolesOfKind("2")) != null) {
            vo.setInsured_role(((InsRoleInpolicy)insurenceRoles.get(0)).getName_cn());
            vo.setBusiness_scope(((InsRoleInpolicy)insurenceRoles.get(0)).getBusiness_nature());
            vo.setPolicy_currency(SysDictUtils.getDictLabel((String)((InsRoleInpolicy)insurenceRoles.get(0)).getCurrency_required(), (String)"currencyRequired", (String)""));
        }
        if ((insProduct = (ProPrimary)this.insProductService.selectById(insInsuranceSlip.getPro_primary().getPro_primary_id())) != null && "XYX-XWCK".equals(insProduct.getProduct_code())) {
            SpecialCreditMicro micro = (SpecialCreditMicro)insInsuranceSlip.getMapSpecial().get(String.valueOf(insProduct.getPro_primary_id()));
            vo.setPolicy_currency(SysDictUtils.getDictLabel((String)micro.getAnnual_currency(), (String)"annualCurrency", (String)""));
        }
        return vo;
    }

    @Override
    public AdviceNoteVo willInsOrderFormSetUpAdviceNoteVo(InsInsuranceSlip insInsuranceSlip) {
        AdviceNoteVo vo = new AdviceNoteVo();
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        InsUnderwrite underwrite = insInsuranceSlip.getUnderwrite();
        if (underwrite != null) {
            vo.setTotal_rate(String.valueOf(underwrite.getTotal_rate()));
            vo.setYear_premium(String.valueOf(underwrite.getYear_premium()));
            vo.setInitial_premium(String.valueOf(underwrite.getInitial_premium()));
        }
        if (insInsuranceSlip.getPremium() != null) {
            vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
        }
        this.insProductService.accordingToProductIDToGetInsProductSetUpAdviceNoteVo(vo, insInsuranceSlip.getPro_primary().getPro_primary_id());
        return vo;
    }

    @Override
    public OrderStatusCountVo selectOrderStatusCountVoByUserID(Long user_id) {
        return this.dao.selectOrderStatusCountVoByUserID(user_id);
    }

    @Override
    public String updateOrderFormStatus(OrderFormVo vo) {
        InsInsuranceSlip insInsuranceSlip = this.dao.selectById(Long.parseLong(vo.getOid()));
        insInsuranceSlip.setOrder_status(vo.getPolicy_status());
        this.dao.updateById(insInsuranceSlip);
        if ("6".equals(vo.getPolicy_status())) {
            ThreadUtil.excAsync(() -> this.sendZZPolicyEmail(vo.getOid()), (boolean)false);
        }
        return insInsuranceSlip.getIns_insurance_slip_id().toString();
    }

    public void sendZZPolicyEmail(String order_id) {
        ThreadUtil.sleep((Number)120000);
        InsMailPolicy insMailPolicy = this.insMailPolicyService.getInsMailPolicyByOrderId(Long.parseLong(order_id));
        if (insMailPolicy == null) {
            return;
        }
        OrderFormVo vo = this.findOrderFormVoByID(Long.parseLong(order_id));
        String content = this.htmlContentByZZPolicyEmail(vo, insMailPolicy);
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            String pcode = StringUtils.isNotEmpty((CharSequence)vo.getProduct_code()) && vo.getProduct_code().contains("PAC") ? vo.getProduct_code() : "";
            this.sendZZMsgEmail(pcode, content);
        }
    }

    public void sendZZMsgEmail(String product_code, String htmlContent) {
        this.log.info("\u5bc4\u9001\u90ae\u4ef6\u53d1\u9001\uff08\u5185\u5bb9htmlContent\uff09:" + htmlContent);
        String[] arrs = this.configService.getValueByKey("TBFP_EMAIL").split(";");
        EmailModel emailModel = new EmailModel("\u4fdd\u5355\u3001\u53d1\u7968\u5bc4\u9001\u901a\u77e5", htmlContent);
        ArrayList<String> emailList = new ArrayList<String>();
        String em = "";
        for (int i = 0; i < arrs.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)arrs[i])) continue;
            if (!arrs[i].contains(":")) {
                em = arrs[i].trim();
                emailList.add(em);
                this.log.info("\u5bc4\u9001\u90ae\u4ef6\u53d1\u9001\uff08\u6536\u4ef6\u4ebaEmail-" + (i + 1) + "\uff09:" + em);
                continue;
            }
            String[] sigs = arrs[i].split(":");
            if (!StringUtils.isNotEmpty((CharSequence)product_code) || !product_code.contains(sigs[1])) continue;
            em = sigs[0].trim();
            emailList.add(em);
            this.log.info("\u5bc4\u9001\u90ae\u4ef6\u53d1\u9001\uff08\u6536\u4ef6\u4ebaEmail-" + (i + 1) + "\uff09:" + em);
        }
        if (emailList.size() > 0) {
            emailModel.setTo(emailList);
            SendEmailAndMsgUtil.sendEmail((EmailModel)emailModel);
        }
    }

    private String htmlContentByZZPolicyEmail(OrderFormVo orderVo, InsMailPolicy insMailPolicy) {
        StringBuffer htmlContent = new StringBuffer();
        try {
            if (orderVo == null) {
                return "";
            }
            if (insMailPolicy.getNeed_insur_bill() == 0 && insMailPolicy.getNeed_receipt() == 0) {
                return "";
            }
            htmlContent.append("<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\"><title>\u7eb8\u8d28\u4fdd\u5355\u3001\u53d1\u7968\u5bc4\u9001\u4fe1\u606f</title><style type=\"text/css\">.wrap{width:500px;margin:30px auto}.wrap h1{text-align:center}.shenqing-con p strong,.shenqing-con p span{display:block;font-size:14px;line-height:24px}.shenqing-con p strong{float:left;margin-right:8px}.shenqing-con div{float:left}.shenqing-con p.mg-r{width:200px;margin-left:78px}table{width:680px}table th,table td{padding:5px}</style></head><body><div class=\"wrap\"><h1>\u7eb8\u8d28\u4fdd\u5355\u3001\u53d1\u7968\u5bc4\u9001\u4fe1\u606f</h1><div class=\"shenqing-con\">");
            htmlContent.append("<p><strong>\u8ba2\u5355\u53f7\uff1a</strong><span>" + orderVo.getTrade_serial_number() + "</span></p>");
            htmlContent.append("<p><strong>\u4fdd\u9669\u516c\u53f8\uff1a</strong><span>" + orderVo.getInsurance_name() + "</span></p><p><strong>\u4fdd\u5355\u53f7\uff1a</strong><span>" + orderVo.getExternal_reference() + "</span></p><p><strong>\u6295\u4fdd\u65f6\u95f4\uff1a</strong><span>" + orderVo.getStart_time() + "</span></p><p><strong>\u6295\u4fdd\u4eba\uff1a</strong><span>" + orderVo.getApplicant_name() + "</span></p><p><strong>\u4fdd\u9669\u4ea7\u54c1\uff1a</strong><span>[\u4ea7\u54c1\u540d\u79f0\uff1a" + orderVo.getProduct_name() + "]</span></p>");
            if (insMailPolicy.getNeed_insur_bill() == 1) {
                htmlContent.append("<h2>\u7eb8\u8d28\u4fdd\u5355\u5bc4\u9001\u4fe1\u606f\uff1a</h2>");
                htmlContent.append("<p><strong>\u6536\u4ef6\u4eba\u540d\u79f0\uff1a</strong><span>" + insMailPolicy.getReceiver_name() + "</span></p>");
                htmlContent.append("<p><strong>\u6536\u4ef6\u4eba\u624b\u673a\uff1a</strong><span>" + insMailPolicy.getReceiver_mobile() + "</span></p>");
                htmlContent.append("<p><strong>\u6536\u4ef6\u4eba\u5730\u5740\uff1a</strong><span>" + insMailPolicy.getReceiver_address_detail() + "</span></p>");
            }
            if (insMailPolicy.getNeed_receipt() == 1) {
                boolean isInv = "1".equals(insMailPolicy.getInvoice_type());
                String inv = isInv ? "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968" : "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968";
                htmlContent.append("<h2>\u7eb8\u8d28" + inv + "\u5bc4\u9001\u4fe1\u606f\uff1a</h2>");
                htmlContent.append("<p><strong>\u5355\u4f4d\u540d\u79f0\uff1a</strong><span>" + insMailPolicy.getReceipt_head() + "</span></p>");
                htmlContent.append("<p><strong>\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a</strong><span>" + insMailPolicy.getTaxpayer_number_invoice() + "</span></p>");
                htmlContent.append("<p><strong>\u6536\u7968\u4eba\u59d3\u540d\uff1a</strong><span>" + insMailPolicy.getTaker_name() + "</span></p>");
                htmlContent.append("<p><strong>\u6536\u7968\u4eba\u624b\u673a\uff1a</strong><span>" + insMailPolicy.getTaker_mobile() + "</span></p>");
                htmlContent.append("<p><strong>\u6536\u7968\u4eba\u5730\u5740\uff1a</strong><span>" + insMailPolicy.getTaker_address_detail() + "</span></p>");
                if (isInv) {
                    htmlContent.append("<p><strong>\u5f00\u6237\u94f6\u884c\uff1a</strong><span>" + insMailPolicy.getBank_invoice() + "</span></p>");
                    htmlContent.append("<p><strong>\u94f6\u884c\u8d26\u53f7\uff1a</strong><span>" + insMailPolicy.getBank_account_invoice() + "</span></p>");
                    htmlContent.append("<p><strong>\u5f00\u6237\u5730\u5740\uff1a</strong><span>" + RegionUtils.getRegionNameByALLCode((String)insMailPolicy.getBank_province(), (String)insMailPolicy.getBank_city(), (String)"") + "</span></p>");
                }
            }
            htmlContent.append("</div></div></body></html>");
        }
        catch (Exception e) {
            this.log.error("\u7eb8\u8d28\u4fdd\u5355\u3001\u53d1\u7968\u5f85\u5bc4\u9001\u901a\u77e5\u5185\u5bb9\u7ec4\u88c5\u5f02\u5e38\uff1a", (Throwable)e);
            e.printStackTrace();
        }
        return htmlContent.toString();
    }

    @Override
    public List<InsInsuranceSlip> findAllInsOrderList(String sql) {
        return this.dao.findAllInsOrderList(sql);
    }

    @Override
    public void accordingToInsTopBuyersListGainInsRiskDuty(Long order_id) {
        InsInsuranceSlip insInsuranceSlip = this.packagingInsOrderForm(order_id);
        Long pid = insInsuranceSlip.getPro_primary().getPro_primary_id();
        ProPrimary product = this.insProductService.getProduct(pid);
        if (product != null && "XYX-DQCK".equals(product.getProduct_code())) {
            SpecialCreditSt insCommonExport = (SpecialCreditSt)insInsuranceSlip.getMapSpecial().get(String.valueOf(pid));
            List tbList = insCommonExport.getTopBuyers();
            Long underwrite_id = insInsuranceSlip.getUnderwrite().getUnderwrite_id();
            this.insRiskDutyService.accordingToInsTopBuyersListGainInsRiskDuty(tbList, underwrite_id, pid);
        }
    }

    @Override
    public void updateOrderUnderwriting(OrderFormVo vo) {
        InsInsuranceSlip insInsuranceSlip = this.packagingInsOrderForm(Long.parseLong(vo.getOid()));
        SimpleDateFormat DATE_FORMAT_6 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        boolean sign = false;
        try {
            if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
                if (vo.getInception_date().indexOf(" 00:00:00") != -1) {
                    insInsuranceSlip.setInception_date(DATE_FORMAT_6.parse(vo.getInception_date()));
                } else {
                    insInsuranceSlip.setInception_date(DATE_FORMAT_6.parse(vo.getInception_date() + " 00:00:00"));
                }
            } else {
                sign = true;
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
                if (vo.getInception_date().indexOf(" 23:59:59") != -1) {
                    insInsuranceSlip.setPlanned_end_date(DATE_FORMAT_6.parse(vo.getPlanned_end_date()));
                } else {
                    insInsuranceSlip.setPlanned_end_date(DATE_FORMAT_6.parse(vo.getPlanned_end_date() + " 23:59:59"));
                }
            } else {
                sign = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        insInsuranceSlip.setUnit_count(Integer.valueOf(1));
        if (StringUtils.isNotEmpty((CharSequence)vo.getGross_premium())) {
            insInsuranceSlip.setPremium(new BigDecimal(vo.getGross_premium()));
        } else {
            sign = true;
        }
        if (StringUtils.isEmpty((CharSequence)vo.getExternal_reference())) {
            sign = true;
        }
        insInsuranceSlip.setEnd_time(new Date());
        this.dao.updateById(insInsuranceSlip);
        if (!sign) {
            this.insAgreementService.willInsurePolicyVoChangeIntoInsAgreement(insInsuranceSlip.getIns_insurance_slip_id(), vo.getExternal_reference());
        }
    }

    @Override
    public List<OrderFormVo> findInsOrderForm(InsInsuranceSlip insInsuranceSlip) {
        List<OrderFormVo> voList = this.dao.findInsOrderForm();
        return voList;
    }

    @Override
    public List<OrderFormVo> findInsOrderFormByUnSync() {
        List<OrderFormVo> voList = this.dao.findInsOrderFormByUnSync();
        return voList;
    }

    @Override
    public PageResult findInsOrderFormByKeyword(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.dao.findInsOrderFormByKeywordCnt(p)), this.dao.findInsOrderFormByKeyword(p));
    }

    @Override
    public List<OrderFormVo> findInsOrderFormBySup(String sup_id) {
        List<OrderFormVo> voList = this.dao.findInsOrderFormBySup(sup_id);
        return voList;
    }

    @Override
    public List<OrderFormVo> getLawsuitList() {
        return this.dao.getLawsuitList();
    }

    @Override
    public OrderFormVo findOrderFormVoByID(Long orderId) {
        OrderFormVo vo = this.dao.getOrderFormVoByID(orderId);
        if (vo != null) {
            this.replenishOrderFormVo(vo);
            return vo;
        }
        return null;
    }

    @Override
    public void replenishOrderFormVo(OrderFormVo vo) {
        this.insTransactionService.setOrderFormVoOfShowUrlByOrderID(vo, Long.parseLong(vo.getOid()));
        InsInsuranceSlip policy = this.dao.selectById(Long.parseLong(vo.getOid()));
        if (!StringUtils.isEmpty((CharSequence)vo.getProduct_code()) && "XYX-XWCK".equals(vo.getProduct_code())) {
            SpecialCreditMicro micro = (SpecialCreditMicro)this.insMicroExportService.selectById(policy.getSpecial_id());
            vo.setPolicy_currency(micro.getAnnual_currency());
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getProduct_oid())) {
            List<ResponsibilityVo> irpVoList = this.insProductResponsibilityService.findResponsibilityVoList(vo.getProduct_oid());
            vo.setResponsibilityVoList(irpVoList);
        }
    }

    @Override
    public void downAllPolicy(HttpServletResponse response) {
        String fileName = "\u767e\u8054\u4fdd\u5728\u4fdd\u4fdd\u5355-" + DateUtil.getCurrentDateTime((String)"yyyyMMdd") + ".xls";
        try {
            fileName = new String(fileName.getBytes("gb2312"), "ISO8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ExcelUtil util = new ExcelUtil(PolicyExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
        try (ServletOutputStream os = response.getOutputStream();){
            List<PolicyExcelVo> listMap = this.dao.downAllPolicy();
            util.exportExcel(listMap, "\u767e\u8054\u4fdd\u5728\u4fdd\u4fdd\u5355", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

