<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>

<!DOCTYPE HTML>
<html>
  <head>
    <title>设置佣金</title>
    <link rel="stylesheet" href="${ctxsta}/common/bootstrap-table-master/bootstrap-table.min.css" />
    <link rel="stylesheet" href="${ctxsta}/common/bootstrap-datepicker-master/css/bootstrap-datepicker.min.css" />
  	 <link href="${ctxsta}/admin/product/css/bootstrap.min.css" rel="stylesheet">
    <link href="${ctxsta}/admin/product/css/public.css" rel="stylesheet">

    <!--[if lt IE 9]>
    <script src="${ctxsta}/admin/product/js/html5shiv.min.js"></script>
    <script src="${ctxsta}/admin/product/js/respond.min.js"></script>
    <![endif]-->
  </head>
  
  <body >
  <div class="container money">
      <form class="form-horizontal" action="${ctx}/ins/productFee/saveProductFeeData" method="POST">
          <input type="hidden" name="pid" value="${product.id}">
          <div class="inform">
              <h3>产品信息</h3>
              <table class="table table-bordered">
                  <tr>
                      <td>产品名称：</td>
                      <td>${product.insuranceName}</td>
                      <td>产品ID：</td>
                      <td>${product.id}</td>
                  </tr>
                  <tr>
                      <td>属性：</td>
                      <td>${fns:getDictLabel(product.property, "property", "")}</td>
                      <td>保险分类：</td>
                      <td><%--${product.responsibilityType}--%>
                          <c:forEach items="${listType}" var="type" varStatus="index">
                              <c:if test="${index.count eq  '1'}"   >
                              ${type.typeName}
                             </c:if>
                              <c:if test="${index.count ne  '1'}"   >
                                  -${type.typeName}
                              </c:if>

                          </c:forEach>
                      </td>
                  </tr>
                  <tr>
                      <td>保险公司：</td>
                      <td>${product.supplier.companyName}</td>
                      <td>保险公司报案电话：</td>
                      <td>${product.companyPhone}</td>
                  </tr>
              </table>
          </div>
          <div class="commission">
              <h3>佣金填写</h3>
              <table class="table table-bordered">
                  <tr>
                      <td>总佣金：</td>
                      <td>
                          <input type="text" placeholder="00.00" class="prodcutfee" name="totalBrokerage" value="${product.totalBrokerage}"/>
                          <span> %</span>
                          <span class="remind">根据协议约定填写产品佣金比例</span>
                      </td>
                      <td>最低佣金：</td>
                      <td>
                          <input type="text" placeholder="00.00" name="minBrokerage" class="prodcutfee" value="${product.minBrokerage}"/>
                          <span> %</span>
                          <span class="remind">将影响渠道方的佣金比例</span>
                      </td>
                  </tr>
              </table>
          </div>
          <div class="operation">
              <table class="table table-bordered">
                  <thead>
                  <tr>
                      <td colspan="4">
                          <h3>操作记录</h3>
                      </td>
                  </tr>
                  </thead>
                  <tbody>
                  <tr>
                      <td>操作时间</td>
                      <td>操作人员</td>
                      <td>操作事项</td>
                      <td>备注</td>
                  </tr>
                  <c:if test="${ empty  logList }">
                      <tr>
                          <td colspan="4">没有操作记录</td>
                      </tr>
                  </c:if>
                  <c:if test="${ not empty  logList }">
                      <c:forEach  var="log" items="${logList }">
                      <tr>
                          <td ><fmt:formatDate type="both" dateStyle="medium" timeStyle="medium"  value="${log.create_time}" /></td>
                          <td >${log.createBy.userName}</td>
                          <td >${log.updateStatus}</td>
                          <td >${log.remarks}</td>
                      </tr>
                      </c:forEach>
                  </c:if>

                  </tbody>
              </table>
          </div>
          <div class="surviv">
              <a class="btn btn-long btn-lightgreen" id="submit" onclick="checkForm(this)" href="#">提交</a>
            <%--  <a class="btn btn-long btn-lightgreen">保存并关闭</a>--%>
              <a class="btn btn-long btn-lightgreen" onclick="hideWidow()">关闭</a>
          </div>
      </form>
  </div>
    <bcxinFooter>
    <!-- 自定义js -->
    <script type="text/javascript">

        function  hideWidow() {
            layer_close();
        }

        function replaceNotNumber(hehe)
        {
            var regu = "^([0-9])[0-9]*(\\.\\w*)?$";

            if(regu.test(hehe.value))
            {
                layer.msg("请输入数字！");
                hehe.value = hehe.value.replace(pattern,"");
            }

        }
        function  checkForm(obj){

            var flag=false;
            $(".prodcutfee").each(function () {
                if($(this).val()==null ||$(this).val()==""){
                    flag=true;
                }
            });
            if(flag){
                layer.msg("请填写总佣金和最低佣金！");
            }else{
                toAjaxSubmit(obj);
            }

        }

    </script>
    </bcxinFooter>

  </body>
</html>
