<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>商品列表</title>
    <link rel="stylesheet" href="${ctxsta}/common/bootstrap-table-master/bootstrap-table.min.css"/>
    <link rel="stylesheet" href="${ctxsta}/common/bootstrap-datepicker-master/css/bootstrap-datepicker.min.css"/>
</head>

<body class="gray-bg">
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">

                <div class="ibox-content">
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <div id="toolbar" class="btn-group m-t-sm">
                                        <%-- 	member_show('创建菜单','${ctx}/sysmenu/list/add',null,null,'900',null) --%>
                                        <shiro:hasPermission name="product:list:change">
                                            <button type="button" class="btn btn-default" title="分配产品列表"
                                                    onclick="member_show('分配分销商','${ctx}/ins/product/changeList',null,null,'950','600')">
                                                <i class="glyphicon glyphicon-plus">分配分销商</i>
                                            </button>
                                        </shiro:hasPermission>
                                    </div>
                                    <table id="table"
                                           data-toggle="table"
                                      <%--     data-height="500"--%>
                                           <%--data-show-refresh="true"--%>
                                           data-show-toggle="true"
                                           data-search="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="stargazers_count"
                                           data-sort-order="desc"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-halign="center" data-align="center" data-sortable="true">id</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">产品名称</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">产品分类</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">供应商</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">状态</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">上架时间</th>
                                            <th data-halign="center" data-align="center">操作</th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                        <c:forEach items="${plst}" var="product">
                                            <tr>
                                                <td>${product.id}<%-- --${topBuyersVo.oid} --%></td>
                                                <td>${product.insuranceName}</td>
                                                <td>${fns:getDictLabel (product.productType,"product_type","")}</td>
                                                <td>${product.supplier.companyName}</td>
                                                <td>${fns:getDictLabel (product.status,"status","正常")}</td>
                                                <td><fmt:formatDate value="${product.create_time}"
                                                                    pattern="yyyy/MM/dd"/></td>
                                                <td class="td-manage" style="text-align: center; ">
                                                    <c:if test="${product.status==1}"><a class="like text-info"
                                                                                         href="javascript:void(0)"
                                                                                         onClick="product_stop(this,${product.id})"
                                                                                         title="冻结"><i
                                                            class="glyphicon glyphicon-pause"></i></a></c:if>
                                                    <c:if test="${product.status==0}"><a class="like text-info"
                                                                                         href="javascript:void(0)"
                                                                                         onClick="product_start(this,${product.id})"
                                                                                         title="启用"><i
                                                            class="glyphicon glyphicon-play"></i></a></c:if>

                                                    <shiro:hasPermission name="productfee:data:edit">
                                                        <a class="edit m-l-sm text-warning"
                                                           onclick="member_show('设置佣金','${ctx}/ins/productFee/setFee/${product.id}',null,null,'1200',null)"
                                                           title="佣金"> <i class="glyphicon glyphicon-edit"></i>
                                                        </a>
                                                    </shiro:hasPermission>

                                                    <!-- <a class="remove m-l-sm text-danger"
                                                        href="javascript:void(0)" onclick="InsTopBuyers_del(this,1)"
                                                        title="删除"> <i class="glyphicon glyphicon-remove"></i>
                                                    </a> -->
                                                </td>

                                            </tr>

                                        </c:forEach>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <!-- 自定义js -->
    <script type="text/javascript">

        /*产品冻结-冻结*/
        function product_stop(obj, id) {
            layer.confirm('确认要下架吗？', {
                btn: ['确定', '取消'] //按钮
            }, function () {
                $.ajax({
                    data: {'accountId': id, 'status': 0},
                    dataType: 'json',
                    type: 'post',
                    url: '${ctx}' + '/ins/product/list/audit',
                    success: function (result) {
                        if (result.success == true) {
                            $(obj).parents("tr").find(".td-manage").prepend('<a class="like text-info" href="javascript:void(0)" onClick="member_start(this,\'' + id + '\')" title="启用"><i class="glyphicon glyphicon-play"></i></a>');
                            $(obj).parents("tr").find(".td-status").html('<span class="label label-danger">冻结</span>');
                            $(obj).remove();
                            layer.msg('已冻结!', {icon: 5, time: 1000});
                        } else {
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }
        /*产品-启用*/
        function product_start(obj, id) {
            layer.confirm('确认要上架吗？', {
                btn: ['确定', '取消'] //按钮
            }, function () {
                $.ajax({
                    data: {'accountId': id, 'status': 1},
                    dataType: 'json',
                    type: 'post',
                    url: '${ctx}' + '/ins/product/list/audit',
                    success: function (result) {
                        if (result.success == true) {
                            $(obj).parents("tr").find(".td-manage").prepend('<a class="like text-info" href="javascript:void(0)" onClick="member_stop(this,\'' + id + '\')" title="下架"><i class="glyphicon glyphicon-pause"></i></a>');
                            $(obj).parents("tr").find(".td-status").html('<span class="label label-primary">正常</span>');
                            $(obj).remove();
                            layer.msg('已启用!', {icon: 6, time: 1000});
                        } else {
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }
        function InsTopBuyers_del(obj, id) {
            layer.confirm('确认要删除吗？', {
                btn: ['确定', '取消'] //按钮
            }, function () {
                $.ajax({
                    type: 'delete',
                    dataType: 'json',
                    url: '${ctx}/InsTopBuyers/list/' + id + '/delete',
                    success: function (result) {
                        if (result.success == true) {
                            $(obj).parents("tr").remove();
                            layer.msg('已删除!', {icon: 1, time: 1000});
                        } else {
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }

    </script>
</bcxinFooter>

</body>
</html>
