<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>审核产品列表</title>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-sm-12">
            <div class="float-e-margins">
                <div class="ibox-title">
                    <h5>搜索查询</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link">
                            <i class="fa fa-chevron-up"></i>
                        </a>
                        <a class="close-link">
                            <i class="fa fa-times"></i>
                        </a>
                    </div>
                </div>
                <div class="ibox-content search-query">
                    <form>
                        <div class="col-sm-6">
                            <div class="form-group" id="data_5">
                                <label class="control-label">添加时间</label>
                                <div class="input-daterange input-group" id="datepicker">
                                    <input type="text" class="form-control" id="begincreate_time" name="begincreate_time"
                                           value=""/>
                                    <span class="input-group-addon">到</span>
                                    <input type="text" class="form-control" id="endcreate_time" name="endcreate_time"
                                           value=""/>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label">会员名称</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" name="searchContent">
                                    <span class="input-group-btn"><button type="sumbit"
                                                                          class="btn btn-primary">搜索</button> </span>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>用户列表</h5>
                    <div class="ibox-tools">
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                        <a class="close-link"><i class="fa fa-times"></i></a>
                    </div>
                </div>
                <div class="ibox-content">
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <div id="toolbar" class="btn-group m-t-sm">
                                        <%--  <button type="button" class="btn btn-default"  title="创建用户" onclick="member_show('创建用户','${ctx}/sysuser/list/add',null,null,'900',null)">
                                              <i class="glyphicon glyphicon-plus">创建用户</i>
                                          </button>--%>
                                    </div>
                                    <table id="table"
                                           data-toggle="table"
                                           <%--data-show-refresh="true"--%>
                                           data-search="true"
                                           data-show-toggle="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="stargazers_count"
                                          <%-- data-url="${ctx}/sysuser/list"--%>
                                           data-query-params="queryParams"
                                           data-sort-order="desc"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-halign="center" data-align="center" data-sortable="true">产品名称</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">产品分类</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">供应商</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">邮箱</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">提交原因</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">状态</th>
                                            <th data-halign="center" data-align="center" data-sortable="true">提交时间</th>
                                            <th data-halign="center" data-align="center">操作</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <c:forEach items="${plist}" var="productLog">
                                            <tr>
                                                <td>${productLog.id}</td>
                                                <td>${productLog.productName}</td>
                                                <td>${productLog.productType}</td>
                                                <td>${productLog.commitReason}</td>
                                                <td>${productLog.id}</td>
                                                <td>${productLog.id}</td>
                                                <td>${productLog.status}</td>
                                                <td>查看</td>


                                            </tr>
                                        </c:forEach>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script type="text/javascript">

        // 日期插件
        $(document).ready(function () {
            $('#data_5 .input-daterange').datepicker({
                keyboardNavigation: false,
                forceParse: false,
                autoclose: true,
                format: 'yyyy/MM/dd',
            });
            //拖动面板
            $(".sortable-list").sortable({
                connectWith: ".connectList"
            }).disableSelection();

            $('#table').bootstrapTable({
                refresh: function () {
                }
            });
        })
        /*用户-删除*/
        function member_del(obj, id) {
            layer.confirm('确认要删除吗？', {
                btn: ['确定', '取消'] //按钮
            }, function () {
                $.ajax({
                    type: 'delete',
                    dataType: 'json',
                    url: '${ctx}/sysuser/list/' + id + '/delete',
                    success: function (result) {
                        if (result.success == true) {
                            $(obj).parents("tr").remove();
                            layer.msg('已删除!', {icon: 1, time: 1000});
                        } else {
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }
        /*用户-重置密码*/
        function member_repwd(obj, id) {
            layer.confirm('确认要重置密码吗？', {
                btn: ['确定', '取消'] //按钮
            }, function () {
                $.ajax({
                    type: 'post',
                    dataType: 'json',
                    url: '${ctx}/sysuser/list/' + id + '/repwd',
                    success: function (result) {
                        if (result.success == true) {
                            layer.msg(result.message, {icon: 1, time: 1000});
                        } else {
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }
        /*用户-冻结*/
        function member_stop(obj, id) {
            layer.confirm('确认要冻结吗？', {
                btn: ['确定', '取消'] //按钮
            }, function () {
                $.ajax({
                    data: {'accountId': id, 'status': 0},
                    dataType: 'json',
                    type: 'post',
                    url: '${ctx}/sysuser/list/audit',
                    success: function (result) {
                        if (result.success == true) {
                            $(obj).parents("tr").find(".td-manage").prepend('<a class="like text-info" href="javascript:void(0)" onClick="member_start(this,' + id + ')" title="启用"><i class="glyphicon glyphicon-play"></i></a>');
                            $(obj).parents("tr").find(".td-status").html('<span class="label label-danger">冻结</span>');
                            $(obj).remove();
                            layer.msg('已冻结!', {icon: 5, time: 1000});
                        } else {
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }
        /*用户-启用*/
        function member_start(obj, id) {
            layer.confirm('确认要启用吗？', {
                btn: ['确定', '取消'] //按钮
            }, function () {
                $.ajax({
                    data: {'accountId': id, 'status': 1},
                    dataType: 'json',
                    type: 'post',
                    url: '${ctx}/sysuser/list/audit',
                    success: function (result) {
                        if (result.success == true) {
                            $(obj).parents("tr").find(".td-manage").prepend('<a class="like text-info" href="javascript:void(0)" onClick="member_stop(this,' + id + ')" title="冻结"><i class="glyphicon glyphicon-pause"></i></a>');
                            $(obj).parents("tr").find(".td-status").html('<span class="label label-primary">正常</span>');
                            $(obj).remove();
                            layer.msg('已启用!', {icon: 6, time: 1000});
                        } else {
                            layer.alert(result.message, {icon: 2});
                        }
                    }
                })
            });
        }
    </script>
</bcxinFooter>
</body>
</html>
