<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
  <head>
    <title>分销商列表</title>
    <link rel="stylesheet" href="${ctxsta}/common/bootstrap-table-master/bootstrap-table.min.css" />
    <link rel="stylesheet" href="${ctxsta}/common/bootstrap-datepicker-master/css/bootstrap-datepicker.min.css" />
  	 <link href="${ctxsta}/admin/product/css/bootstrap.min.css" rel="stylesheet">
    <link href="${ctxsta}/admin/product/css/font-awesome.min.css" rel="stylesheet">
    <link href="${ctxsta}/admin/product/css/common.css" rel="stylesheet">
    <link href="${ctxsta}/admin/product/css/establish.css" rel="stylesheet">
    <link rel="stylesheet" href="${ctxsta}/admin/product/css/style.min.css"/>
    <!--[if lt IE 9]>
    <script src="${ctxsta}/admin/product/js/html5shiv.min.js"></script>
    <script src="${ctxsta}/admin/product/js/respond.min.js"></script>
    <![endif]-->
  </head>
  
  <body class="gray-bg">
	<div class="container content ">
        <div class="nav-head">
            <div class="step step2">
                <ul>
                    <li >
                        <strong>选择需分配的产品</strong>
                    </li>
                    <li class="current">
                        <strong>选择一级分销商</strong>
                    </li>
                    <li>
                        <strong>设置佣金</strong>
                    </li>
                    <li>
                        <strong>完成</strong>
                    </li>
                </ul>
            </div>
        </div>

    
    <div class="create">
        <form class="form-horizontal" id="Form1" action="${ctx}/ins/product/saveNextFeeData" method="POST">

            <div class="row search">
                <div class="col-xs-1 keyword">
                    <span>关键字</span>
                </div>
                <div class="col-xs-4">
                    <input type="text" class="form-control" placeholder="产品名称/供应商名称/产品id"/>
                </div>
                <div class="col-xs-6">
                    <div class="col-xs-6 dataStart">
                        <span>日期</span>
                        <input placeholder="请选择日期" id="start" class="laydate-icon form-control">
                        <i></i>
                    </div>
                    <div class="col-xs-6 dataEnd">
                        <span class="go">至</span>
                        <input placeholder="请选择日期" id="end" class="laydate-icon form-control" >
                        <i></i>
                    </div>
                </div>
                <div class="col-xs-1">
                    <button type="button" class="btn btn-search">搜索</button>
                </div>
            </div>


            <table class="table table-bordered">
                <thead>
                <tr>
                    <td class="check"><input type="checkbox" id="chk_all" /></td>
                    <td>ID</td>
                    <td>一级分销商名称</td>
                    <td>开通时间</td>
                    <td>状态</td>
                    <td>联系方式</td>
                </tr>
                </thead>
                <tbody>
              
                	<c:forEach items="${slist}" var="syscompany">
							<tr>
					            <td class="check"><input type="checkbox" name="companyName" value="${syscompany.id}" onclick="changeNum()"/></td>
			                    <td>${syscompany.id}</td>
			                    <td>${syscompany.companyName}</td>
			                    <td><fmt:formatDate type="both" dateStyle="medium" timeStyle="medium"  value="${syscompany.create_time}" /></td>
			                    <td>${fns:getDictLabel (syscompany.status,"status","正常")}</td>
			                    <td>${syscompany.companyPhone}</td>
			                </tr>
	               </c:forEach>
                
                </tbody>
            </table>
            <div class="row choice">
                <div class="col-xs-6">
                    <p>已选择 <span id="checkNum">0</span> 名分销商</p>
                </div>
            </div>

            <div class="row">
                <div class="row finish">
                    <div class="col-sm-9 col-sm-offset-2">
                        <a class="btn btn-long btn-lightgreen"  href="${ctx}/ins/product/changeList">上一步</a>
                        <a class="btn btn-long btn-lightgreen" onclick="tijiaoForm()">下一步</a>
                        <a onclick="hideWidow()" class="btn btn-long btn-lightgreen">取消分配</a>

                    </div>
                </div>

            </div>
        </form>
    </div>

</div>
 
    <bcxinFooter>
        <link rel="stylesheet" href="${ctxsta}/common/icheck/flat/green.css" />
        <script src="${ctxsta}/common/icheck/icheck.min.js"></script>
    <!-- 自定义js -->
    <script type="text/javascript">

        $(document).ready(function() {
            $('input').iCheck({
                checkboxClass: 'icheckbox_flat-green',
                radioClass: 'iradio_flat-green'
            });
        });

        $(document).ready(function () {
            $('#chk_all').on('ifChecked ifUnchecked', function(event) {
                if (event.type == 'ifChecked') {
                    $("input[name='companyName']").iCheck('check');
                } else {
                    $("input[name='companyName']").iCheck('uncheck');
                }
                changeNum();
            });
            $("input[name='companyName']").on('ifChanged', function(event){
                changeNum();
            });
        })

//        $("#chk_all").click(function(){
//            $("[name=companyName]:checkbox").attr("checked",this.checked);
//        });
        function  hideWidow() {
            layer_close();
        }
	    function  tijiaoForm(){
            var checks = document.getElementsByName("companyName");
            var n = 0;
            for(i=0;i<checks.length;i++){
                if(checks[i].checked)
                    n++;
            }
            if(n==0){
                layer.msg('至少需要选中一个');
            }else{
                $('#Form1').submit();
            }

		}
		function  changeNum(){
			var boxArray = document.getElementsByName('companyName');
			 var total = 0;
			for(var i=0;i<boxArray.length;i++){
				if(boxArray[i].checked){
					total++;
				}
			}
		    $("#checkNum").html(total); 
		    // alert("选中"+boxArray.length);
		
		} 
    </script>
    </bcxinFooter>

  </body>
</html>

<script type="text/javascript" src="${ctxsta}/admin/product/js/data/laydate.js"></script>
<script type="text/javascript">
    //日期范围限制
    var start = {
        elem: '#start',
        format: 'YYYY-MM-DD',
        min: laydate.now(), //设定最小日期为当前日期
        max: '2099-06-16', //最大日期
        istime: true,
        istoday: false,
        choose: function(datas){
            end.min = datas; //开始日选好后，重置结束日的最小日期
            end.start = datas //将结束日的初始值设定为开始日
            //end.max = time1;
        }
    };
    var end = {
        elem: '#end',
        format: 'YYYY-MM-DD',
        min: laydate.now(),
        max: '2099-06-16',
        istime: true,
        istoday: false,
        choose: function(datas){
            start.max = datas; //结束日选好后，充值开始日的最大日期
        }
    };
    Date.prototype.Format = function (fmt) { //author: meizz
        var o = {
            "M+": this.getMonth() + 1, //月份
            "d+": this.getDate(), //日
            "h+": this.getHours(), //小时
            "m+": this.getMinutes(), //分
            "s+": this.getSeconds(), //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds() //毫秒
        };
        if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        for (var k in o)
            if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
        return fmt;
    }
    laydate(start);
    laydate(end);
</script>
