<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<%@ taglib uri="/WEB-INF/tlds/fns.tld" prefix="fns" %>
<!DOCTYPE HTML>
<html>
<head>
<title>创建全球十大买家</title>
	<%@include file="/WEB-INF/include/head.jsp"%>
</head>
<body class="gray-bg">
	<div class="wrapper add-member-content animated fadeInRight">
		<div class="row">
			<div class="col-sm-12">
				<div class="ibox float-e-margins">
					<!-- 投保单信息  -->
					<div class="ibox-title">
						<h5>投保单信息</h5>
					</div>
					<div class="ibox-content">
						<table class="table table-bordered">
							<tr>
								<td>投保单号</td>
								<td>${topBuyersVo.policy_serial_number}</td>
								<td>投保人中文名</td>
								<td>${topBuyersVo.applicant_name}</td>
							</tr>
							<tbody>
								<tr>
									<td>投保金额</td>
									<%--<td>${topBuyersVo.insuredAmount}</td>--%>
									<td>保费</td>
									<td>${topBuyersVo.premium}</td>
								</tr>
								<tr>
									<td>保险期间起始时间</td>
									<td colspan="3">

										${topBuyersVo.start_date}-${topBuyersVo.end_date}
									</td>
								</tr>
							</tbody>
						</table>
					</div>
					<!-- 投保单信息end -->
					<!--   买家信息 -->
					<form id="InsTopBuyersform"  action="${ctx}/exports/credit/quotaApproval"  method="post">

					<div class="ibox-title">
						<h5>买方信息</h5>
					</div>
					<div class="ibox-content">
						<table class="table table-bordered">
							<tbody>
							<tr>
								<td>买方代码</td>
								<td><input name="buyerCode" value="${topBuyersVo.code}"/></td>
								<td>买方名称</td>
								<td>${topBuyersVo.customer_name}</td>
							</tr>
								<tr>
									<td>买方证照号码</td>
									<td>${topBuyersVo.id_no}</td>
									<td>买方所属州/地区</td>
									<td>${topBuyersVo.address}</td>
								</tr>
								<tr>
									<td>买方所属国家</td>
									<td>${topBuyersVo.country}</td>
									<td>买方所在城市</td>
									<td>${topBuyersVo.city}</td>
								</tr>
								<tr>
									<td>买方所属街道</td>
									<td>${topBuyersVo.street}</td>
									<td>买方门牌号</td>
									<td>${topBuyersVo.house_num}</td>
								</tr>
								<tr>
									<td>公司级别</td>
									<td>${fns:getDictLabel (topBuyersVo.video_level,"accountType","")}</td>
									<td>行业类别</td>
									<td>${fns:getDictLabel (topBuyersVo.vocation,"enterpriseType","")}</td>
								</tr>
								<tr>
									<td>注册资本</td>
									<td>${topBuyersVo.capital}</td>
									<td>员工数</td>
									<td>${topBuyersVo.emp_num}</td>
								</tr>
								<tr>
									<td>联系人</td>
									<td>${topBuyersVo.linkman}</td>
									<td>电话号码</td>
									<td>${topBuyersVo.phone}</td>
								</tr>
							</tbody>
						</table>
					</div>
					<!--   买家信息end -->
					<!--   信用限额信息 -->
					<div class="ibox-title">
						<h5>信用限额</h5>
					</div>
					<div class="ibox-content">
						<table class="table table-bordered">
								<input type="hidden" name="oid" value="${topBuyersVo.oid}">
								<input  type="hidden"  name="replaystatus"  id="replaystatus" value="1">
								<input  type="hidden"  name="reply_remark"  id="replyRemark"  value="${topBuyersVo.reply_remark}"/>
							<tr>
								<td>限额类型</td>
								<td>${fns:getDictLabel(topBuyersVo.limit_type,"applicationLimitType","")} </td>
								<td>申请信用限额</td>
								<td>${topBuyersVo.amount_requested}</td>
							</tr>
							<tbody>
								<tr>
									<td>销售常用付款方式</td>
									<td>${fns:getDictLabel(topBuyersVo.payment_terms,"paymentTerms","")}</td>
									<td>买家信用期限</td>
									<td>${topBuyersVo.credit_period}</td>
								</tr>
								<tr>
									<td>批复信用限额</td>
									<td><input type="text" name="reply_amount" value="${topBuyersVo.reply_amount}" />   </td>
									<td>信用限额批复时间<%-- ${topBuyersVo.reply_date} --%></td>
									<td><input type="date" name="reply_date" value="<c:if test="${not empty  topBuyersVo.reply_date }"> <fmt:formatDate value="${topBuyersVo.reply_date}" pattern="yyyy-MM-dd" /></c:if>" /></td>
								</tr>
								<tr>
									<td>备注</td>
									<td colspan="3">${topBuyersVo.remark}</td>

								</tr>
							</tbody>
						</table>
					</div>
					<!--   信用限额信息end -->
					<!--   操作记录信息 -->
					<%--<div class="ibox-title">
						<h5>操作记录</h5>
					</div>
					<div class="ibox-content">
						<table class="table table-bordered">
							<tr>
									<td>操作时间</td>
									<td>操作人员</td>
									<td>操作事项</td>
									<td>备注</td>
							</tr>
							<tbody>
								<tr>
									<td></td>
									<td colspan="3"></td>
								</tr>
							</tbody>
						</table>
					</div>--%>
					<!--   操作记录end -->
					<div class="form-group">
						<div class="col-sm-4 col-sm-offset-4 add-submit">
								<button class="btn btn-primary dictsubmit" type="button"  onclick="history.go(-1)">返回</button>
							    <button class="btn btn-primary dictsubmit" type="button"
								id="submit" onclick="toAjaxTiaoZhuangSubmit(this,'${ctx}')">审核通过</button>
								    <button class="btn btn-primary dictsubmit" type="button"
								id="submitFail" onclick="shenheFail(this)">审核不通过</button>
						</div>
					</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	</div>
	<bcxinFooter> <!-- iCheck -->
		<script src="${ctxsta}/common/icheck/icheck.min.js"></script> <!-- 自定义js -->
		<script type="text/javascript">
			$(document).ready(function() {
				$('input').iCheck({
					checkboxClass : 'icheckbox_flat-green',
					radioClass : 'iradio_flat-green'
				});
			});
			//表单验证-添加管理员验证
			$(function() {
				$('#InsTopBuyersform').bootstrapValidator({
					container : 'tooltip',
					message : 'This value is not valid',
					feedbackIcons : {
						valid : 'glyphicon glyphicon-ok',
						invalid : 'glyphicon glyphicon-remove',
						validating : 'glyphicon glyphicon-refresh'
					}
				})
			})
			/**审核不通过*/
            function  shenheFail(obj){
                layer.prompt({title: '审核不通过的理由', formType: 2}, function(text, index){
                    $("#replyRemark").val(text);
                    $("#replaystatus").val("0");
                    layer.close(index);
                    $(obj.closest('form')).ajaxSubmit(function(result) {
                        if (result.success == true) {
                            top.layer.msg(result.message, {
                                shade : 0.3,
                                time : 1000
                            }, function() {
                                history.go(-1);
                            });
                        } else {
                            top.layer.msg(result.message, {
                                icon : 2,
                                time : 1000
                            });
                        }
                        return false;
                    });
                });
                return false;
            }
		</script>
	</bcxinFooter>
</body>
</html>
