<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html lang="zh-cn">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title></title>
	<%@include file="/WEB-INF/include/head.jsp"%>
</head>
<body>
<div class="container bid">
	<div class="content">
		<h3>基础信息</h3>
		<p class="clearfix"><span class="pull-right">订单状态：${fns:getDictLabel (orderVo.policy_status,"order_status","")}</span></p>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">订单号</li>
					<li class="no-bor">${orderVo.trade_serial_number}</li>
					<li class="no-bor">下单时间</li>
					<li class="no-bor">${orderVo.start_time}</li>
					<li class="no-bor">支付方式</li>
					<li class="no-bor">
						<c:set var="paymentMethods" value="${empty transactionList ? '' : transactionList[0].pay_type}"></c:set>
						${empty paymentMethods ? '' : fns:getDictLabel (paymentMethods,"pay_type","")}
					</li>
					<li class="no-bor">最后支付时间</li>
					<li class="no-bor">
						<c:set var="endTimes" value="${empty transactionList ? '' : transactionList[transactionList.size()-1].end_time}"></c:set>
						<c:if test="${not empty endTimes }">
							<fmt:formatDate value="${endTimes}" type="both" pattern="yyyy-MM-dd HH:mm:ss"/>
						</c:if>
					</li>
					<li class="no-bor">支付流水号</li>
					<li class="no-bor">
						<c:forEach items="${transactionList}" var="list">
							${list.trade_serial_number}<br/>
						</c:forEach>
						<%--${empty transactionList ? '' : transactionList.size()}
						${orderVo.pay_methods eq '2' ? '/4' : '/1'}
						<c:if test="${not empty transactionList}">
							<a href="javascript:void(0)" onclick="member_show('支付详情','${ctx}/ins/policy/initTransactionDetail/${orderVo.oid}','','','900',null)" title="支付详情">
								支付详情
							</a>
						</c:if>--%>
					</li>
					<li class="no-bor">下单帐号</li>
					<li class="no-bor">${orderVo.login_name}</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">产品信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">产品名称</li>
					<li class="no-bor" title="${orderVo.product_name}">${orderVo.product_name}</li>
					<li class="no-bor">保费（元）</li>
					<li class="no-bor">${orderVo.gross_premium}</li>
					<li class="no-bor">保险期限</li>
					<li class="no-bor" id="days"></li>
					<li class="no-bor">生效日期</li>
					<li class="no-bor">${orderVo.inception_date}</li>
					<li class="no-bor">保险地区</li>
					<li class="no-bor">${reg_policy}</li>
					<li class="no-bor">保险金额</li>
					<li class="no-bor">${orderVo.insured_amount}</li>
				</ul>
				<table class="table ">
					<tbody>
					<tr>
						<td class="col-sm-4 col-xs-4">保障责任</td>
						<td class="col-sm-2 col-xs-2">
							<c:set var="irp_1" value="${ vo.responsibilityVoList[0] }"></c:set>
							<c:choose>
								<c:when test="${empty irp_1.insurance_amount_max && not empty irp_1.fcy}">
									保险金额
								</c:when>
								<c:when test="${empty irp_1.fcy && not empty irp_1.insurance_amount_max}">
									赔偿限额
								</c:when>
								<c:otherwise>
									保险金额
								</c:otherwise>
							</c:choose>
						</td>
						<td class="col-sm-2 col-xs-2">免赔额</td>
						<td class="col-sm-2 col-xs-2">赔付比例</td>
						<td class="col-sm-2 col-xs-2">免赔天数</td>
					</tr>
					<c:forEach items="${ vo.responsibilityVoList }" var="irp">
						<tr <c:choose>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '0' && irp.is_optional eq '2'}">
								hidden
							</c:when>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '1' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障一')}">
								hidden
							</c:when>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '2' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障二')}">
								hidden
							</c:when>
							<c:when test="${empty vo.is_contain_repo && irp.is_optional eq '2'}">
								hidden
							</c:when>
							<c:otherwise>

							</c:otherwise>
						</c:choose>>
							<td class="col-sm-4 col-xs-4" style="text-align:left; <c:if test="${irp.name eq '烈士褒扬金'}">color: red;</c:if>">${irp.name}<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="${irp.explain_product}"/></td>
							<td class="col-sm-2 col-xs-2" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
								<c:choose>
									<c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元/天
													</c:if>
												</c:if>
											</span>
									</c:when>
									<c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元/天
													</c:if>
												</c:if>
											</span>
									</c:when>
									<c:otherwise>
										<span>-</span>
									</c:otherwise>
								</c:choose>
							</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.deductible_days ? '-' : irp.deductible_days}</td>
						</tr>
					</c:forEach>
					</tbody>
				</table>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">工程概况</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">工程类型</li>
					<li class="no-bor">
						${vo1.type eq '1' ? '国家重点工程' : vo1.type eq '2' ? '省重点工程' : vo1.type eq '3' ? '市重点工程' : vo1.type eq '4' ? '其他' : ''}
					</li>
					<li class="no-bor">计划工期</li>
					<li class="no-bor">${vo1.project_time_com}</li>
					<li class="no-bor">中标价（万元）</li>
					<li class="no-bor">${ vo1.bidding}</li>
					<li class="no-bor">企业资质类别</li>
					<li class="no-bor">
						${vo1.aptitude_type eq '1' ? '施工总承包' : vo1.aptitude_type eq '2' ? '施工专业承包' : vo1.aptitude_type eq '3' ? '设计' : vo1.aptitude_type eq '4' ? '监理' : ''}
					</li>
					<li class="no-bor">企业资质等级</li>
					<li class="no-bor">
						${vo1.aptitude_level eq '1' ? '特级' : vo1.aptitude_level eq '2' ? '一级' : vo1.aptitude_level eq '3' ? '二级' : vo1.aptitude_level eq '4' ? '三级' : ''}
					</li>
					<li class="no-bor">企业性质</li>
					<li class="no-bor">
						${vo1.nature_type eq '1' ? '央企' : vo1.nature_type eq '2' ? '省属国企' : vo1.nature_type eq '3' ? '市属国企' : vo1.nature_type eq '4' ? '县属及以下国企' : vo1.nature_type eq '5' ? '民营企业' : vo1.nature_type eq '6' ? '事业单位' : vo1.nature_type eq '7' ? '外资企业' : ''}
					</li>
					<li class="no-bor">信用等级</li>
					<li class="no-bor">${ vo1.credit_level}</li>
					<li class="no-bor">企业资产负债率</li>
					<li class="no-bor">${ vo1.debt_ratio}%</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">投保人信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">公司名称（中文）</li>
					<li class="no-bor" title="${ vo2.roleSubjectList[0].name_cn}">${ vo2.roleSubjectList[0].name_cn}</li>
					<li class="no-bor">公司名称（英文）</li>
					<li class="no-bor"></li>
					<li class="no-bor">${vo.roleSubjectList[0].id_type eq '1' ? '组织机构代码' : vo.roleSubjectList[0].id_type eq '2' ? '统一社会信用代码' : '证件号码' }</li>
					<li class="no-bor">${ vo2.roleSubjectList[0].organization_code}</li>
					<li class="no-bor">联系电话</li>
					<li class="no-bor">${ vo2.roleSubjectList[0].phone}</li>
					<li class="no-bor">联系地址</li>
					<li class="wd80 no-bor" title="${reg_role}${ vo2.roleSubjectList[0].reg_address}">${reg_role}${ vo2.roleSubjectList[0].reg_address}</li>
					<li class="no-bor">联系人</li>
					<li class="no-bor no-rigbor" title="${ vo2.roleSubjectList[0].link_name}">${ vo2.roleSubjectList[0].link_name}</li>
					<li class="no-bor">手机号</li>
					<li class="no-bor rig-bor">${ vo2.roleSubjectList[0].link_tel}</li>
					<li class="no-bor">电邮地址</li>
					<li class="wd80">${ vo2.roleSubjectList[0].link_email}</li>
				</ul>
			</div>
			<div class="img-show col-xs-12">
				<ul>
					<c:if test="${ not empty vo2.roleSubjectList[0].app_tax_path&&vo2.roleSubjectList[0].app_tax_path.length()>1}">
						<li>
							<img src="${ vo2.roleSubjectList[0].app_tax_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">税务登记证</span>
								<a target="_blank" href="${ vo2.roleSubjectList[0].app_tax_path}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo2.roleSubjectList[0].app_organizing_path&&vo2.roleSubjectList[0].app_organizing_path.length()>1}">
						<li>
							<img src="${ vo2.roleSubjectList[0].app_organizing_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">组织机构代码证</span>
								<a target="_blank" href="${ vo2.roleSubjectList[0].app_organizing_path}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo2.roleSubjectList[0].app_business_path&&vo2.roleSubjectList[0].app_business_path.length()>1}">
						<li>
							<img src="${ vo2.roleSubjectList[0].app_business_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">营业执照</span>
								<a target="_blank" href="${ vo2.roleSubjectList[0].app_business_path}">下载</a>
							</p>
						</li>
					</c:if>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">被投保人信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">公司名称（中文）</li>
					<li class="no-bor" title="${ vo2.roleSubjectList[1].name_cn}">${ vo2.roleSubjectList[1].name_cn}</li>
					<li class="no-bor">公司名称（英文）</li>
					<li class="no-bor"></li>
					<li class="no-bor">${vo.roleSubjectList[1].id_type eq '1' ? '组织机构代码' : vo.roleSubjectList[1].id_type eq '2' ? '统一社会信用代码' : '证件号码' }</li>
					<li class="no-bor">${ vo2.roleSubjectList[1].organization_code}</li>
					<li class="no-bor">联系电话</li>
					<li class="no-bor">${vo2.roleSubjectList[1].phone}</li>
					<li class="no-bor">联系地址</li>
					<li class="wd80 no-bor" title="${ vo2.roleSubjectList[1].address}">${ vo2.roleSubjectList[1].address}</li>
					<li class="no-bor">联系人</li>
					<li class="no-bor no-rigbor" title="${vo2.roleSubjectList[1].link_name}">${vo2.roleSubjectList[1].link_name}</li>
					<li class="no-bor">手机号</li>
					<li class="no-bor rig-bor">${vo2.roleSubjectList[1].link_tel}</li>
					<%--<li class="no-bor">电邮地址</li>
					<li class="wd80">${map['ins_email']}</li>--%>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">投保基本信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">项目名称及标段</li>
					<li class="no-bor" title="${vo2.project_name}">${vo2.project_name}</li>
					<li class="no-bor">工程造价（元）</li>
					<li class="no-bor">${vo2.predict_cost}</li>
					<li class="no-bor">计划工期</li>
					<li class="no-bor">${vo2.project_time}</li>
					<li class="no-bor">工程建设地点</li>
					<li class="no-bor" title="${vo2.project_address}">${vo2.project_address}</li>
					<li class="no-bor">保险期间</li>
					<li class="no-bor">${vo2.inception_date}~${vo2.planned_end_date}</li>
					<li class="no-bor">司法管辖</li>
					<li class="no-bor">中华人民共和国司法管辖（港澳台除外）</li>
					<li class="no-bor">争议处理</li>
					<li class="no-bor">${empty vo2.dispute ? '' : vo2.dispute eq '0' ? '诉讼' : '仲裁，仲裁机构'}&nbsp;&nbsp;${empty vo2.dispute ? '' : vo2.dispute eq '0' ? '' : vo2.arbitral_institution}</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">企业相关资料</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li title="企业营业执照、组织机构代码证及税务登记证">企业营业执照、组织机...</li>
					<li class="wd80">
						<c:if test="${not empty vo3.subfile_dm}">
							<a target="_blank" href="${vo3.subfile_dm}">下载附件</a>
						</c:if>
					</li>
					<li title="资质证书（说明：指特级、一级、二级、三级等）">资质证书（说明：指特级...</li>
					<li class="wd80">
						<c:if test="${not empty vo3.subfile_zz}">
							<a target="_blank" href="${vo3.subfile_zz}">下载附件</a>
						</c:if>
					</li>
					<li title="安全生产许可证">安全生产许可证</li>
					<li class="wd80">
						<c:if test="${not empty vo3.subfile_aq}">
							<a target="_blank" href="${vo3.subfile_aq}">下载附件</a>
						</c:if>
					</li>
					<li title="企业章程原件扫描件">企业章程原件扫描件</li>
					<li class="wd80">
						<c:if test="${not empty vo3.subfile_zc}">
							<a target="_blank" href="${vo3.subfile_zc}">下载附件</a>
						</c:if>
					</li>
					<li title="经审计部门审计的近2年财务报表扫描件">经审计部门审计的近...</li>
					<li class="wd80">
						<c:if test="${not empty vo3.subfile_cw}">
							<a target="_blank" href="${vo3.subfile_cw}">下载附件</a>
						</c:if>
					</li>
					<li title="企业银行开户许可证扫描件">企业银行开户许可证...</li>
					<li class="wd80">
						<c:if test="${not empty vo3.subfile_kh}">
							<a target="_blank" href="${vo3.subfile_kh}">下载附件</a>
						</c:if>
					</li>
					<li title="企业贷款卡扫描件">企业贷款卡扫描件</li>
					<li class="wd80">
						<c:if test="${not empty vo3.subfile_hk}">
							<a target="_blank" href="${vo3.subfile_hk}">下载附件</a>
						</c:if>
					</li>
					<li title="企业近2年纳税证明">企业近2年纳税证明</li>
					<li class="wd80">
						<c:if test="${not empty vo3.subfile_ns}">
							<a target="_blank" href="${vo3.subfile_ns}">下载附件</a>
						</c:if>
					</li>
					<li title="企业近三个月银行对账单">企业近三个月银行对...</li>
					<li class="wd80">
						<c:if test="${not empty vo3.subfile_dz}">
							<a target="_blank" href="${vo3.subfile_dz}">下载附件</a>
						</c:if>
					</li>
					<li title="企业近三年工程业绩（包括中标通知书、合同、竣工备案表）">企业近三年工程业绩...</li>
					<li class="wd80">
						<c:if test="${not empty vo3.subfile_yj}">
							<a target="_blank" href="${vo3.subfile_yj}">下载附件</a>
						</c:if>
					</li>
					<li title="企业在建工程业绩清单（中标通知书、合同）">企业在建工程业绩清...</li>
					<li class="wd80">
						<c:if test="${not empty vo3.subfile_qd}">
							<a target="_blank" href="${vo3.subfile_qd}">下载附件</a>
						</c:if>
					</li>
					<li title="本投保项目的项目经理个人简历、过往项目施工经验介绍">本投保项目的项目经...</li>
					<li class="wd80">
						<c:if test="${not empty vo3.subfile_js}">
							<a target="_blank" href="${vo3.subfile_js}">下载附件</a>
						</c:if>
					</li>
					<li title="本投保项目的招标文件、中标通知书、建筑工程施工合同副本">本投保项目的招标文...</li>
					<li class="wd80">
						<c:if test="${not empty vo3.subfile_ht}">
							<a target="_blank" href="${vo3.subfile_ht}">下载附件</a>
						</c:if>
					</li>
					<li title="其它认为需要提供的材料（如企业获得的荣誉等）">其它认为需要提供的...</li><%-- style="height: 80px;"--%>
					<li class="wd80"><%-- style="height: 80px;line-height: 80px"--%>
						<c:if test="${not empty vo3.subfile_cl}">
							<a target="_blank" href="${vo3.subfile_cl}">下载附件</a>
						</c:if>
					</li>
				</ul>
			</div>
		</div>
	</div>
	<!-- 票单信息 start -->
	<div class="content">
		<h3 class="mb20">单证信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">是否需要纸质保单</li>
					<li class="no-bor">
						${vo2.mailPolicyVo.need_insur_bill eq '0' ? '否' : '是'}
					</li>
					<li class="no-bor">收件人</li>
					<li class="no-bor">
						${ vo2.mailPolicyVo.receiver_name}
					</li>
					<li class="no-bor">收件人手机</li>
					<li class="no-bor">
						${ vo2.mailPolicyVo.receiver_mobile}
					</li>
					<li class="no-bor">收件地址</li>
					<li class="no-bor">
						${ vo2.mailPolicyVo.receiver_address_detail}
					</li>
					<li class="no-bor">是否需要纸质发票</li>
					<li class="no-bor">
						${vo2.mailPolicyVo.need_receipt eq '0' ? '否' : '是'}
					</li>
					<li class="no-bor">发票种类</li>
					<li class="no-bor">
						${vo2.mailPolicyVo.need_receipt eq '0' ? '' : vo2.mailPolicyVo.invoice_type eq '0' ? '增值税普通发票' : '增值税专用发票'}
					</li>
					<c:if test="${vo2.mailPolicyVo.invoice_type eq '0'}">
						<li class="no-bor">收件单位</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.receipt_head}">
							${ vo2.mailPolicyVo.receipt_head}
						</li>
						<li class="no-bor">收件人</li>
						<li class="no-bor">
							${ vo2.mailPolicyVo.taker_name}
						</li>
						<li class="no-bor">收件人手机</li>
						<li class="no-bor">
							${ vo2.mailPolicyVo.taker_mobile}
						</li>
						<li class="no-bor">收件地址</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.taker_address_detail}">
							${ vo2.mailPolicyVo.taker_address_detail}
						</li>
						<li class="no-bor">纳税人识别号</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.taxpayer_number_invoice}">
								${ vo2.mailPolicyVo.taxpayer_number_invoice}
						</li>
					</c:if>
					<c:if test="${vo2.mailPolicyVo.invoice_type eq '1'}">
						<li class="no-bor">纳税人识别号</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.taxpayer_number_invoice}">
								${ vo2.mailPolicyVo.taxpayer_number_invoice}
						</li>
						<li class="no-bor">注册地址</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.register_address_invoice}">
								${ vo2.mailPolicyVo.register_address_invoice}
						</li>
						<li class="no-bor">开户银行</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.bank_invoice}">
								${ vo2.mailPolicyVo.bank_invoice}
						</li>
						<li class="no-bor">电话</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.receipt_phone}">
								${ vo2.mailPolicyVo.receipt_phone}
						</li>
						<li class="no-bor">银行账号</li>
						<li class="no-bor" title="${ vo2.mailPolicyVo.bank_account_invoice}">
								${ vo2.mailPolicyVo.bank_account_invoice}
						</li>
					</c:if>
				</ul>
			</div>
			<div class="img-show col-xs-12">
				<ul>
					<c:if test="${ not empty vo2.mailPolicyVo.tax_cert}">
						<li>
							<img src="${ vo2.mailPolicyVo.tax_cert}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">税务登记证</span>
								<a target="_blank" href="${ vo2.mailPolicyVo.tax_cert}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo2.mailPolicyVo.tax_prove}">
						<li>
							<img src="${ vo2.mailPolicyVo.tax_prove}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">一般纳税人证明</span>
								<a target="_blank" href="${ vo2.mailPolicyVo.tax_prove}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo2.mailPolicyVo.bank_licence}">
						<li>
							<img src="${ vo2.mailPolicyVo.bank_licence}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">银行开户许可证</span>
								<a target="_blank" href="${ vo2.mailPolicyVo.bank_licence}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo2.mailPolicyVo.business_license}">
						<li>
							<img src="${ vo2.mailPolicyVo.business_license}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">营业执照副本</span>
								<a target="_blank" href="${ vo2.mailPolicyVo.business_license}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo2.mailPolicyVo.auth_cert}">
						<li>
							<img src="${ vo2.mailPolicyVo.auth_cert}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">增票授权委托书</span>
								<a target="_blank" href="${ vo2.mailPolicyVo.auth_cert}">下载</a>
							</p>
						</li>
					</c:if>
				</ul>
			</div>
		</div>
	</div>
	<!-- 票单信息  end -->
	<c:if test="${ not empty orderVo.external_reference && not empty orderVo.insure_path}">
		<div class="content">
			<h3 class="mb20">保单信息</h3>
			<div class="row bid-context">
				<div class="col-sm-12">
					<ul class="bid-ul">
						<li> 电子保单</li>
						<li class="wd80">
							<a target="_blank" href="${orderVo.insure_path}">查看</a>
						</li>
					</ul>
				</div>
			</div>
		</div>
	</c:if>
	<c:if test="${ not empty orderVo.remarks}">
		<div class="content">
			<h3 class="mb20">其它</h3>
			<div class="row bid-context">
				<div class="col-sm-12">
					<ul class="bid-ul">
						<li> 备注</li>
						<li class="wd80">
								${ orderVo.remarks}
						</li>
					</ul>
				</div>
			</div>
		</div>
	</c:if>
	<%--<div class="operation">
		<div class="row oper-deta">
			<div class="col-xs-12">
				<h3>操作记录</h3>
				<ul class="detail">
					<li class="bc">操作时间</li>
					<li class="bc">操作人员</li>
					<li class="bc">操作事项</li>
					<li class="bc">备注</li>
					<li></li>
					<li></li>
					<li></li>
					<li></li>
					<li></li>
					<li></li>
					<li></li>
					<li></li>
				</ul>
			</div>
		</div>
	</div>--%>
	<%--<div class="examine text-center">
		<a class="btn btn-long btn-lightgreen">核保/承保</a>
		<a class="btn btn-long btn-lightgreen">票单配送</a>
	</div>--%>
</div>
<bcxinFooter>
	<script type="text/javascript" src="${ctxsta}/admin/product/js/jquery-1.11.3.js"></script>
	<script>
        $(function(){
            function lineHeight(name){
                var height=parseFloat($("."+name+">li:nth-child(2)").css("height"));
                $("."+name+">li:first-child").css("line-height",height+"px").css("padding","0");
            }
            lineHeight("big");
            lineHeight("img-look");
            lineHeight("addr");
            lineHeight("day");
            btnCount_Click();
        })
        function  btnCount_Click(){//d1失效日期，d2生效日期
            var d1 = '${orderVo.planned_end_date}';
            var d2 = '${orderVo.inception_date}';
            var days = '';
            if(d1 != '' && d2 != ''){
                days = DateDiff(d1,d2)+'天';
            }
            $("#days").html(days);
        }

        //计算天数差的函数，通用
        function  DateDiff(sDate1,  sDate2){    //sDate1和sDate2是2006-12-18格式
            var  aDate,  oDate1,  oDate2,  iDays
            aDate  =  sDate1.split("-")
            oDate1  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])    //转换为12-18-2006格式
            aDate  =  sDate2.split("-")
            oDate2  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])
            iDays  =  parseInt(Math.abs(oDate1  -  oDate2)  /  1000  /  60  /  60  /24) + 1    //把相差的毫秒数转换为天数
            return  iDays
        }
	</script>
</bcxinFooter>
</body>
</html>
