<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
<title>核保</title>
	<%@include file="/WEB-INF/include/head.jsp"%>
</head>
<body class="gray-bg">
	<div class="wrapper add-member-content animated fadeInRight">
		<div class="row">
			<div class="col-sm-12">
				<div class="ibox float-e-margins">
				<form id="undform" class="form-horizontal" action="${ctx}/ins/policy/updateOrderAudit" method="POST">
				<input type="hidden" name="order_id" id="order_id" value="${orderVo.oid}"/>
				<input type="hidden" name="oid" id="oid" value="${underwriteVo.oid}"/>
				<input type="hidden" name="signOperate" id="signOperate" value="1"/>
					<!-- 投保信息 start -->
					<div class="ibox-title">
						<h5>
							投保单信息
						</h5>
					</div>
					<div class="ibox-content">
						<div class="form-group">

							<label class="col-sm-2 control-label">产品名称：</label>
							<div class="col-sm-4 form-control-static">
								${orderVo.product_name}
							</div>
							<label class="col-sm-2 control-label">投保单号：</label>
							<div class="col-sm-4 form-control-static">
								${orderVo.policy_serial_number}
							</div>
						</div>
					</div>
					<div class="ibox-title">
						<h5>
							被保险人信息
						</h5>
					</div>
					<div class="ibox-content">
						<div class="form-group">
							<label class="col-sm-2 control-label">被保险人名称：</label>
							<div class="col-sm-4 form-control-static">
								${orderVo.insured_role}
							</div>
							<label class="col-sm-2 control-label">共同被保险人：</label>
							<div class="col-sm-4 form-control-static">
								-
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">承保经营范围：</label>
							<div class="col-sm-4 form-control-static">
								${orderVo.business_scope}
							</div>
							<label class="col-sm-2 control-label"></label>
							<div class="col-sm-4 form-control-static">
							</div>
						</div>
					</div>
					<div class="ibox-title">
						<h5>
							投保计划
						</h5>
					</div>
					<div class="ibox-content">
						<div class="form-group">
							<label class="col-sm-2 control-label">核保报价日期：</label>
							<div class="col-sm-4 form-control-static">
								${underwriteVo.underwrite_time}
							</div>
							<label class="col-sm-2 control-label">保单币种：</label>
							<div class="col-sm-4 form-control-static">
								${fns:getDictLabel (orderVo.policy_currency,"annualCurrency","")}
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">保险期限：</label>
							<div class="col-sm-4 form-control-static">
								一年
								<input type="hidden" id="deadline" name="deadline" value="一年"/>
							</div>
							<label class="col-sm-2 control-label">保险公司：</label>
							<div class="col-sm-4 form-control-static">
								${orderVo.insurance_name}
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">承保范围：</label>
							<div class="col-sm-4">
							<c:choose>
									<c:when test="${orderVo.product_code  eq 'XYX-DQCK'}">
									<select id="coverage" name="coverage" class="form-control">
										<option value="100000023"<c:if test="${underwriteVo.coverage eq '100000023'}"> selected</c:if>>出口信用商业风险</option>
										<option value="100000024"<c:if test="${underwriteVo.coverage eq '100000024'}"> selected</c:if>>出口信用政治风险</option>
										</select>
									</c:when>
									<c:when  test="${orderVo.product_code  eq 'XYX-XWCK'}">
									<select id="coverage" name="coverage" class="form-control">
										<option value="100000021"<c:if test="${underwriteVo.coverage eq '100000021'}"> selected</c:if>>出口信用商业风险</option>
										<option value="100000022"<c:if test="${underwriteVo.coverage eq '100000022'}"> selected</c:if>>出口信用政治风险</option>
									</select>
									</c:when>
									<c:otherwise>
										<input type="text" id="coverage" name="coverage" value="${underwriteVo.coverage}" class="form-control"/>
									</c:otherwise>
							</c:choose>
							<%--<input type="text" id="coverage" name="coverage" value="${underwriteVo.coverage}" class="form-control"/>--%>
							</div>
							<label class="col-sm-2 control-label">可保营业额：</label>
							<div class="col-sm-4 ">
								<input type="text" Data-Val="Point Required" name="business_volume" id="businessVolume" value="${underwriteVo.business_volume}" class="form-control" onblur="isochronousAmountData('yearPremium','initialPremium')"/>
							</div>
						</div>
					</div>
					<div class="ibox-title">
						<h5>
							承保条件
						</h5>
					</div>
					<div class="ibox-content">
						<div class="form-group">
							<label class="col-sm-2 control-label">最高赔偿限额：</label>
							<div class="col-sm-4 " id="do_amount_max">
								<c:if test="${'XYX-XWCK' eq orderVo.product_code}">
									${underwriteVo.insurance_amount_max}<input type="hidden" id="insurance_amount_max" name="insurance_amount_max" value="${underwriteVo.insurance_amount_max}"/>
								</c:if>
								<c:if test="${'XYX-XWCK' != orderVo.product_code}">
									<input type="text" Data-Val="Required" id="insurance_amount_max" name="insurance_amount_max" value="${underwriteVo.insurance_amount_max}" class="form-control"/>
								</c:if>
							</div>
							<label class="col-sm-2 control-label">逾期欠款通知最后期限(天)：</label>
							<div class="col-sm-4 ">
								<c:if test="${!empty insProduct.balance_overdue_deadline}">
								<select id="balance_overdue_deadline" name="balance_overdue_deadline" class="form-control">
									<option value="">--请选逾期最后期限--</option>
										<c:forEach items="${fn:split(insProduct.balance_overdue_deadline,',')}" var="value">
										  <option value="${value}"<c:if test="${value eq underwriteVo.balance_overdue_deadline}"> selected="selected"</c:if>>${value}</option>
										</c:forEach>
								</select>
								</c:if>
								<c:if test="${empty insProduct.balance_overdue_deadline}">
									<input id="balance_overdue_deadline" name="balance_overdue_deadline" value="${underwriteVo.balance_overdue_deadline}" class="form-control" />
								</c:if>
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">开票期限(天)：</label>
							<div class="col-sm-4 ">
								<c:if test="${not empty insProduct.make_invoice_deadline}">
								<select id="make_invoice_deadline" name="make_invoice_deadline" class="form-control">
									<option value="">--请选开票期限--</option>
									<c:forEach items="${fn:split(insProduct.make_invoice_deadline,',')}" var="value">
	                                 <option value="${value}"<c:if test="${value eq underwriteVo.make_invoice_deadline}"> selected="selected"</c:if>>${value}</option>
	                                </c:forEach>
								</select>
								</c:if>
								<c:if test="${empty insProduct.make_invoice_deadline}">
									<input id="make_invoice_deadline" name="make_invoice_deadline" value="${underwriteVo.make_invoice_deadline}" class="form-control"/>
								</c:if>
							</div>
							<label class="col-sm-2 control-label">营业额申报期限(天)：</label>
							<div class="col-sm-4 ">
								<c:if test="${!empty insProduct.turnover_filing_period_mt}">
								<select id="declareTime" name="declare_time" class="form-control">
									<option value="">--请选申报期限--</option>
									<c:forEach items="${fn:split(insProduct.turnover_filing_period_mt,',')}" var="value">
	                                 <option value="${value}"<c:if test="${value eq underwriteVo.declare_time}"> selected="selected"</c:if>>${value}</option>
	                                </c:forEach>
								</select>
								</c:if>
								<c:if test="${empty insProduct.turnover_filing_period_mt}">
									<input id="declareTime" name="declare_time" value="${underwriteVo.declare_time}" class="form-control"/>
								</c:if>
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">特殊条件：</label>
							<div class="col-sm-10">
								<textarea id="specialIf" class="form-control" name="special_if" rows="" cols="65">${underwriteVo.special_if}</textarea>
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">备注：</label>
							<div class="col-sm-10">
								<textarea id="underwrite_remark" class="form-control" name="underwrite_remark" rows="" cols="65">${underwriteVo.underwrite_remark}</textarea>
							</div>
						</div>
					</div>
					<!-- 投保信息 end -->
					<c:if test="${not empty insProduct.country_area_risk_type}">
					<!-- 国家分类承保条件 start -->
					<div class="ibox-title">
						<h5>
							国家分类承保条件
						</h5>
					</div>
					<div class="ibox-content">
						<table class="table table-bordered">
							<thead>
								<tr>
									<th>国家/地区危险等级分类</th>
									<th>保险费率</th>
									<th>最长信用账期</th>
									<th>延长保障期限</th>
									<th>不可撤销合同期限(月)</th>
									<th>信用限额</th>
									<th>信用限额承保比例</th>
									<th>核准信用限额承保比例</th>
									<th>各保险责任索赔等待期</th>
									<th>自负额</th>
								</tr>
							</thead>
							<tbody>
								<c:forEach items="${fn:split(insProduct.country_area_risk_type,',')}" varStatus="index" var="riskValue">
								<input type="hidden" name="riskDutyVoList[${index.index}].oid" id="riskDutyVoListOid_${index.index}" value="${underwriteVo.riskDutyVoList[index.index].oid}">
		                        <tr>
		                            <td>
		                            <input type="hidden" name="riskDutyVoList[${index.index}].country_area_risk_type" id="country_area_risk_type_${index.index}" value="${riskValue}"/>
		                            ${riskValue}
		                            </td>
		                            <td>
									<input type="text" class="form-control" name="riskDutyVoList[${index.index}].rate" value="${underwriteVo.riskDutyVoList[index.index].rate}"/>
		                            </td>
		                            <td>
										<%--请选信用账期--%>
									<select name="riskDutyVoList[${index.index}].long_credit" id="long_credit_${index.index}">
										<c:if test="${empty insProduct.credit_payment_days}">
											<option value="">无</option>
										</c:if>
										<c:forEach items="${fn:split(insProduct.credit_payment_days,',')}" var="value">
		                                	 <option value="${value}" <c:if test="${value eq underwriteVo.riskDutyVoList[index.index].long_credit}">selected</c:if>>${value}</option>
		                                </c:forEach>
									</select> 
		                            </td>
		                            <td>
										<%--请选保障期限--%>
									 <select name="riskDutyVoList[${index.index}].grace_period" id="grace_period_${index.index}">
										 <c:if test="${empty insProduct.extend_guarantee_deadline}">
											 <option value="">无</option>
										 </c:if>
										<c:forEach items="${fn:split(insProduct.extend_guarantee_deadline,',')}" var="value">
		                                 <option value="${value}" <c:if test="${value eq underwriteVo.riskDutyVoList[index.index].grace_period}">selected</c:if>>${value}</option>
		                                </c:forEach>
									</select> 
		                            </td>
		                            <td>
										<%--不可撤销合同期限--%>
										<select name="riskDutyVoList[${index.index}].un_repeal_period" id="un_repeal_period_${index.index}">
											<c:if test="${empty insProduct.an_contract_deadline}">
											<option value="">无</option>
											</c:if>
										<c:forEach items="${fn:split(insProduct.an_contract_deadline,',')}" var="value">
											<option value="${value}" <c:if test="${value eq underwriteVo.riskDutyVoList[index.index].un_repeal_period}">selected</c:if>>${value}</option>
										</c:forEach>
		                            </td>
		                            <td>
		                            	<input type="text" name="riskDutyVoList[${index.index}].credit_quota" id="credit_quota_${index.index}"  class="form-control" value="${underwriteVo.riskDutyVoList[index.index].credit_quota}"/>
		                            </td>
		                            <td>
										<%--请选承保比例--%>
									<select name="riskDutyVoList[${index.index}].credit_quota_rate" id="credit_quota_rate_${index.index}">
										<c:if test="${empty insProduct.proportion}">
											<option value="">无</option>
										</c:if>
										<c:forEach items="${fn:split(insProduct.proportion,',')}" var="value">
		                                 	<option value="${value}" <c:if test="${fns:isContrastNumber(value,underwriteVo.riskDutyVoList[index.index].credit_quota_rate)}">selected</c:if>>${value*100}%</option>
		                                </c:forEach>
									</select>
		                            </td>
		                            <td>
										<%--核准信用限额承保比例--%>
									<select name="riskDutyVoList[${index.index}].approve_quota_rate" id="approve_quota_rate_${index.index}">
										<c:if test="${empty insProduct.proportion}">
											<option value="">无</option>
										</c:if>
										<c:forEach items="${fn:split(insProduct.proportion,',')}" var="value">
											<option value="${value}" <c:if test="${fns:isContrastNumber(value,underwriteVo.riskDutyVoList[index.index].approve_quota_rate)}">selected</c:if>>${value*100}%</option>
										</c:forEach>
									</select>
		                            </td>
		                            <td>
									<select name="riskDutyVoList[${index.index}].claim_period" id="claim_period_${index.index}">
										<c:if test="${!empty underwriteVo.riskDutyVoList[index.index].claim_period}">
											<option value="${underwriteVo.riskDutyVoList[index.index].claim_period}" selected>${underwriteVo.riskDutyVoList[index.index].claim_period}</option>
										</c:if>
										<option value="150">150</option>
										<option value="180">180</option>
										<option value="360">360</option>
									</select>
		                            </td>
		                            <td>
		                            <input type="text" name="riskDutyVoList[${index.index}].deductible" id="deductible_${index.index}" value="${ underwriteVo.riskDutyVoList[index.index].deductible}" class="form-control"/>
		                            </td>
		                        </tr>
		                        </c:forEach>
							</tbody>
						</table>
					</div>
					</c:if>
					<!-- 国家分类承保条件 start -->
					<div class="ibox-title">
						<h5>
							保险费及其他费用
						</h5>
					</div>
					<div class="ibox-content">
						<div class="form-group">
	
							<label class="col-sm-2 control-label">总保险费率：</label>
							<div class="col-sm-4">
								<input type="hidden" name="total_rate" id="totalRate" value="${underwriteVo.total_rate}"/>
								<span id="setTotalRate">${underwriteVo.total_rate}</span>
							</div>
							<label class="col-sm-2 control-label">保费缴纳方式：</label>
							<div class="col-sm-4">
								<c:set var="paymentWayList" value="${fn:split(insProductgg.pay_methods,',')}"/>
								<select id="paymentWay" name="payment_way" onchange="premiumControl(this,'yearPremium','initialPremium');" class="form-control">
									<option value="">--请选缴纳方式--</option>
									<c:forEach begin="0" end="${fn:length(paymentWayList)-1}" varStatus="i">
	                                 <option value="${paymentWayList[i.index]}"<c:if test="${paymentWayList[i.index] eq underwriteVo.payment_way}"> selected="selected"</c:if>>${fns:getDictLabel (paymentWayList[i.index],"pay_methods","")}</option>
	                                </c:forEach>
								</select>
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">预计年度保费：</label>
							<div class="col-sm-4">
								<input type="text" class="form-control" Data-Val="Point Required" name="year_premium" id="yearPremium" value="${ underwriteVo.year_premium }"<c:if test="${underwriteVo.payment_way eq '1'}"> disabled="disabled"</c:if><c:if test="${'2' eq underwriteVo.payment_way}"> onblur="onlyChange(this)"</c:if>>
							</div>
							<label class="col-sm-2 control-label">初始保费：</label>
							<div class="col-sm-4">
								<input type="text" class="form-control" Data-Val="Point Required" IS-MIRO="${'XYX-XWCK' eq orderVo.product_code ? '1' : ''}" name="initial_premium" id="initialPremium" value="${ underwriteVo.initial_premium }"<c:if test="${'1' eq underwriteVo.payment_way}"> onblur="isochronousAmountData('yearPremium','initialPremium')"</c:if>>
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">信用限额调查费：</label>
							<div class="col-sm-4">
								<input type="text" class="form-control" Data-Val="Point Required" name="credit_credit_fee" id="credit_credit_fee" value="${ underwriteVo.credit_credit_fee }">
							</div>
							<label class="col-sm-2 control-label"></label>
							<div class="col-sm-4">
							</div>
						</div>
						<div class="hr-line-dashed"></div>
						<c:if test="${orderVo.policy_status eq '2'}">
						<div class="form-group">
							<div class="col-sm-6 col-sm-offset-6 add-submit">
								<shiro:hasPermission name="orderForm:list:underwriting:edit">
									<button class="btn btn-primary dictsubmit" type="button" onclick="toAjaxSubmitByVerify(this)">核保确认</button>
									<button class="btn btn-primary dictsubmit" type="button" onclick="toAjaxSaveAndClose(this)">保存并关闭</button>
								</shiro:hasPermission>
								<shiro:hasPermission name="orderForm:list:declinature:edit">
									<button class="btn btn-primary dictsubmit" type="button" onclick="shenheFail()">核保不通过</button>
								</shiro:hasPermission>

								<%--<button class="btn btn-primary dictsubmit" type="button" onclick="addRemark()">添加备注</button>--%>
							</div>
						</div>
						</c:if>
					</div>
					<!-- 国家分类承保条件  end -->
					</form>
					<form id="declinature" class="form-horizontal" action="${ctx}/ins/policy/orderAuditFail" method="POST">
						<input type="hidden" name="ty" value="1"/>
						<input type="hidden" name="order_id" value="${orderVo.oid}">
						<input type="hidden" name="remarks" id="remarks2"/>
					</form>
				</div>
			</div>
		</div>
	</div>
	<bcxinFooter> <!-- iCheck -->
		<script src="${ctxsta}/common/icheck/icheck.min.js"/>
		<!-- 自定义js -->
		<script type="text/javascript">
            $(document).ready(function() {
                $('input').iCheck({
                    checkboxClass : 'icheckbox_flat-green',
                    radioClass : 'iradio_flat-green'
                });
            });
            //表单验证-添加管理员验证
            $(function() {
                $('#dictform').bootstrapValidator({
                    container : 'tooltip',
                    message : 'This value is not valid',
                    feedbackIcons : {
                        valid : 'glyphicon glyphicon-ok',
                        invalid : 'glyphicon glyphicon-remove',
                        validating : 'glyphicon glyphicon-refresh'
                    },
                    fields : {
                        'dict.value' : {
                            message : '字典名验证失败',
                            validators : {
                                notEmpty : {
                                    message : '字典用户名不能为空'
                                }
                            }
                        },
                        'dict.label' : {
                            message : '字典排序验证失败',
                            validators : {
                                notEmpty : {
                                    message : '字典排序不能为空'
                                }
                            }
                        }
                    }
                })
            })
		</script>
	<script type="text/javascript">
        function customsVerify(){
            var flag = true;
            $("input[Data-Val]").each(function(){
                var dataVal = $(this).attr("Data-Val");
                if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                    if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            layer.msg("必填项不能为空！");
                            $(this).focus();
                            flag = false;
                            return true;
                        }

                    }
                }
            });
            if(flag){
                $("select[Data-Val]").each(function(){
                    var dataVal = $(this).attr("Data-Val");
                    if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                        if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                            if($(this).val() == ''){
                                document.getElementById(this.id).scrollIntoView();
                                layer.msg("必填项不能为空！");
                                $(this).focus();
                                flag = false;
                                return true;
                            }
                        }
                    }
                });

            }
            return flag;
        }
        function  shenheFail(){
            layer.prompt({title: '核保不通过的理由', formType: 2}, function(text, index){
                $("#remarks2").val(text);
                layer.close(index);
                var index0 = layer.load(0, {shade: false});
                $('#declinature').ajaxSubmit(function(result) {
                    if (result.success == true) {
                        window.parent.layer.msg(result.msg, {
                            shade : 0.3,
                            time : 1000
                        }, function() {
                            window.parent.location.reload(); // 刷新父页面
                        });
                    } else {
                        window.parent.layer.msg(result.msg, {
                            icon : 2,
                            time : 1000
                        });
                    }
                    layer.close(index0);
                    return false;
                });
            });
        }
        function  toAjaxSubmitByVerify(obj){
            if(customsVerify()){
                toAjaxSubmit(obj);
            }
        }
        function  toAjaxSaveAndClose(obj){
            $("#signOperate").val("");
            toAjaxSubmit(obj);
        }
        function addRemark(obj){
            layer.prompt({title: '添加备注', formType: 2}, function(text, index){
                $("#remarks").val(text);
                layer.close(index);
                //toAjaxFaildSubmit($('#failsform'));
            });
        }
        function premiumControl(_this,_year,_init){
            if(_this.value == "1"){//一次性
				$("#"+_year).attr("disabled",true);
                $("#"+_year).attr("onblur","");
                $("#"+_init).attr("onblur","isochronousAmountData('"+_year+"','"+_init+"')");
			}else/* if(_this.value == "2")*/{//分期
                $("#"+_year).attr("disabled",false);
                $("#"+_year).attr("onblur","onlyChange(this)");
                $("#"+_init).attr("onblur","");
            }
		}
		function isochronousAmountData(_year,_init){
            var amot = $("#"+_init).val();

            var ins_amot = $("#businessVolume").val();
            if(amot != ""&&!isNaN(amot)){
                $("#"+_year).val(amot);
                if(ins_amot != ""&&!isNaN(ins_amot)){
                    var rate = (parseFloat(amot)/parseFloat(ins_amot)).toFixed(4);
                    $("#totalRate").val(rate);
                    $("#setTotalRate").html(rate);

                    var isM = $("#"+_init).attr("IS-MIRO");
                    if(isM == "1"){
                        var _prm = parseFloat(amot)*60;
                        $("#do_amount_max").html(_prm + '<input type="hidden" id="insurance_amount_max" name="insurance_amount_max" value="'+_prm+'"/>');
					}
                }else{
                    $("#businessVolume").val('');
                }
            }else{
                $("#"+_init).val('');
            }
		}
        function onlyChange(_obj){
            var amot = $(_obj).val();
            var ins_amot = $("#businessVolume").val();
            if(amot != ""&&!isNaN(amot)){
                if(ins_amot != ""&&!isNaN(ins_amot)){
                    var rate = (parseFloat(amot)/parseFloat(ins_amot)).toFixed(4);
                    $("#totalRate").val(rate);
                    $("#setTotalRate").html(rate);
                }else{
                    $("#businessVolume").val('');
                }
            }else{
                $(_obj).val('');
            }

        }
        $(function(){
            $("label").each(function(){
                var _class = $(this).attr("class");
                if(_class != undefined){
                    if(_class == "col-sm-2 control-label"&&$(this).html() != ''){
                        var _div = $(this).next();
                        if(_div.is('div')&&_div.html().trim().length == 0){
                            _div.html('-');
                        }
                    }
                }
            });
        });
	</script>
	</bcxinFooter>
</body>
</html>
