<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>订单管理-订单详情</title>
    <link href="${ctxsta}/admin/product/css/public.css" rel="stylesheet">
    <link href="${ctxsta}/admin/product/css/management.css" rel="stylesheet">
    <!--[if lt IE 9]>
    <script src="${ctxsta}/admin/product/js/html5shiv.min.js"></script>
    <script src="${ctxsta}/admin/product/js/respond.min.js"></script>
    <![endif]-->
</head>
<body>
<div class="container bid detail-buss">
    <div class="content">
        <h3>基础信息</h3>
       <%-- <p class="clearfix"><span class="pull-right">订单状态：未支付</span></p>--%>
        <div class="row bid-context ml-15px">
            <div class="col-sm-12">
                <ul class="bid-ul">
                    <li>订单号</li>
                    <li>${vo.tradeSerialNumber}</li>
                    <li>下单时间</li>
                    <li><fmt:formatDate type="both" dateStyle="medium" timeStyle="medium" value="${vo.startTime}"/></li>
                    <li>外部订单号</li>
                    <li>-</li>
                    <li>是否购买保险</li>
                    <li>${vo.buyPolicy}</li>
                    <li>支付方式</li>
                    <li>${vo.paymentType}</li>
                    <li>最后支付时间</li>
                    <li>${vo.paymentDate}</li>
                    <li>支付期数</li>
                    <li>${vo.paymentStage}</li>
                    <li>下单帐号</li>
                    <li>-</li>
                </ul>
            </div>
        </div>
    </div>
    <div class="content">
        <h3 class="mb20">产品信息</h3>
        <div class="row bid-context ml-15px">
            <div class="col-sm-12">
                <ul class="bid-ul">
                    <li>产品名称</li>
                    <li>${vo.productNames}</li>
                    <li>购买数量</li>
                    <li>${vo.number}</li>
                    <li>视频有效期</li>
                    <li><fmt:formatDate type="both" dateStyle="medium" timeStyle="medium" value="${vo.startDate}"/>
                        至
                        <fmt:formatDate type="both" dateStyle="medium" timeStyle="medium" value="${vo.endDate}"/></li>
                    <li>订单金额</li>
                    <li><fmt:formatNumber type="number" value="${vo.amount}" pattern="0.00" maxFractionDigits="2"/></li>
                </ul>
            </div>
        </div>
    </div>
    <div class="content">
        <h3 class="mb20">分销信息</h3>
        <div class="product">
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-3 col-xs-3">可分销金额</td>
                            <td class=" col-sm-3 col-xs-3"><fmt:formatNumber type="number" value="${vo.fcy}" pattern="0.00" maxFractionDigits="2"/></td>
                            <td class="tablebg_f5f8fa col-sm-3 col-xs-3">所属分销商</td>
                            <td class=" col-sm-3 col-xs-3">${vo.sysCompany.companyName}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
    $(function(){
        function lineHeight(name){
            var height=parseFloat($("."+name+">li:nth-child(2)").css("height"));
            $("."+name+">li:first-child").css("line-height",height+"px").css("padding","0");
        }
        lineHeight("big");
        lineHeight("img-look");
        lineHeight("addr");
        lineHeight("day");
    })
</script>
</body>
</html>