<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
	<title>支付详情</title>
	<%@include file="/WEB-INF/include/head.jsp"%>

</head>

<body class="gray-bg">
<div class="wrapper add-member-content animated fadeInRight">
	<div class="row">
		<div class="col-sm-12">
			<div class="ibox float-e-margins">
				<!-- 基础信息 start -->
				<div class="ibox-title">
					<h5> 基础信息</h5>
				</div>
				<div class="ibox-content">
					<div class="hr-line-dashed"></div>
					<div class="form-group">
						<label class="col-sm-2 control-label">订单号：</label>
						<div class="col-sm-4">
							${orderVo.trade_serial_number}
						</div>
						<label class="col-sm-2 control-label">下单时间：</label>
						<div class="col-sm-4">
							${fn:substring(orderVo.start_time, 0, fn:length(orderVo.start_time)-3)}
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-2 control-label">支付方式：</label>
						<div class="col-sm-4">${empty transactionList ? '-' : fns:getDictLabel(transactionList[0].pay_type,"pay_type","")}</div>
						<label class="col-sm-2 control-label">最后支付时间：</label>
						<div class="col-sm-4">
							<c:set var="endTimes" value="${empty transactionList ? '' : transactionList[transactionList.size()-1].end_time}"></c:set>
							<c:if test="${not empty endTimes }">
								<fmt:formatDate value="${endTimes}" type="both" pattern="yyyy-MM-dd HH:mm:ss"/>
							</c:if>
						</div>
					</div>
					<div class="form-group">
						<label class="col-sm-2 control-label">支付次数：</label>
						<div class="col-sm-4">${transactionList.size()>0 ? transactionList.size() : '0'}/${orderVo.pay_methods eq '1' ? '1' : orderVo.pay_methods eq '2' ? '4' : '0'}</div>
						<label class="col-sm-2 control-label">下单帐号：</label>
						<div class="col-sm-4">${orderVo.login_name}</div>
					</div>
				</div>
				<!-- 基础信息 end -->
				<!-- 支付详情 start -->
				<div class="ibox-title">
					<h5> 支付详情 </h5>
				</div>
				<div class="ibox-content">
					<form id="transactionForm" action="${ctxapi}/myPolicy/updateTransactionPayOrderNumber" method="POST">
						<input type="hidden" name="order_id" value="${orderVo.oid}">
						<input type="hidden" name="sup_id" value="${sup_id}">
						<table class="table table-bordered">
							<tbody>
							<tr>
								<td>支付时间</td>
								<td>支付单号</td>
								<td>支付方式</td>
								<td>剩余期数</td>
								<td>本期应付金额</td>
								<td>本期实付金额</td>
								<td>剩余应付金额</td>
								<td colspan="2">操作</td>
							</tr>
							<c:if test="${transactionList.size() == 0}">
								<tr>
									<td colspan="7">暂无支付信息！</td>
								</tr>
							</c:if>
							<c:forEach items="${ transactionList }" var="transaction" varStatus="index">
								<tr>
									<td><fmt:formatDate pattern="yyyy-MM-dd" value="${transaction.start_time}" /></td>
									<td>
										<c:if test="${transaction.transaction_status != '1'}">
											<input type="text" id="junior_${transaction.ins_transaction_id }" style="width: 100px" value="" DATA-SG="${transaction.ins_transaction_id }" onblur="numVerify('hjunior',this,'pocket_${transaction.ins_transaction_id }')">
											<input type="hidden" name="pay_order_number" id="hjunior_${transaction.ins_transaction_id  }">
										</c:if>
										<c:if test="${transaction.transaction_status eq '1'}">
											${ transaction.pay_order_number}
										</c:if>
									</td>
									<td>${fns:getDictLabel(transaction.pay_type,"pay_type","")}</td>
									<td>${ (index.index+1) == 5 ? 0 : ((orderVo.pay_methods eq '2' ? 4 : 1) -(index.index+1))}</td>
									<td>${ transaction.pay_amount}</td>
									<td>
										<c:if test="${transaction.transaction_status != '1'}">
											<input type="text" id="pocket_${transaction.ins_transaction_id }" style="width: 100px" value="" DATA-SG="${transaction.ins_transaction_id }" onblur="numVerify1('hjunior',this,'junior_${transaction.ins_transaction_id }')">
										</c:if>
										<c:if test="${transaction.transaction_status eq '1'}">
											${ transaction.out_of_pocket}
										</c:if>
									</td>
									<td>
										<c:set var="sum" value="0"></c:set>
										<c:forEach begin="0" end="${index.index}" var="i">
											<c:set var="sum" value="${sum+transactionList[i].out_of_pocket}"></c:set>
										</c:forEach>
											${ (orderVo.gross_premium - sum)<=0? 0 : orderVo.gross_premium - sum}
									</td>
									<td>
										<c:if test="${transaction.transaction_status != '1'}">
											<a href="javascript:void(0);" onclick="submitPay(this)">修改</a>
										</c:if>
										<c:if test="${not empty transaction.pay_order_url}">
											<a target="_blank" href="${ transaction.pay_order_url}">下载支付凭证</a>
										</c:if>
									</td>
								</tr>
							</c:forEach>
							</tbody>
						</table>
					</form>
				</div>
				<!-- 支付详情  end-->
			</div>
		</div>
	</div>
</div>
<bcxinFooter> <!-- iCheck --> <script
		src="${ctxsta}/common/icheck/icheck.min.js"></script> <!-- 自定义js --> <script
		type="text/javascript">
    $(document).ready(function() {
        $('input').iCheck({
            checkboxClass : 'icheckbox_flat-green',
            radioClass : 'iradio_flat-green'
        });
    });
    //表单验证-添加管理员验证
    $(function() {
        $('#dictform').bootstrapValidator({
            container : 'tooltip',
            message : 'This value is not valid',
            feedbackIcons : {
                valid : 'glyphicon glyphicon-ok',
                invalid : 'glyphicon glyphicon-remove',
                validating : 'glyphicon glyphicon-refresh'
            },
            fields : {
                'dict.value' : {
                    message : '字典名验证失败',
                    validators : {
                        notEmpty : {
                            message : '字典用户名不能为空'
                        }
                    }
                },
                'dict.label' : {
                    message : '字典排序验证失败',
                    validators : {
                        notEmpty : {
                            message : '字典排序不能为空'
                        }
                    }
                }
            }
        })
    })
</script>
	<script>
		function submitPay(_this){
		    var pon = $("input[name='pay_order_number']").val();
            if(pon.split(';').length == 3){
                toAjaxSubmit(_this);
            }else{
                layer.msg("请完善信息后提交！");
			}
		}
        function numVerify(_sn,_this,_id){
            var result = $('#'+_this.id).val();
            var result2 = $('#'+_id).val();
            if(result != '' && result2 != ''){
                $('#'+_sn+'_'+$(_this).attr("DATA-SG")).val($(_this).attr("DATA-SG")+';'+result+';'+result2);
            }else{
                $('#'+_sn+'_'+$(_this).attr("DATA-SG")).val('');
            }
        }
        function numVerify1(_sn,_this,_id){
            var result = $('#'+_id).val();
            var result2 = $('#'+_this.id).val();
            if(result != '' && result2 != ''){
                $('#'+_sn+'_'+$(_this).attr("DATA-SG")).val($(_this).attr("DATA-SG")+';'+result+';'+result2);
            }else{
                $('#'+_sn+'_'+$(_this).attr("DATA-SG")).val('');
            }
        }
	</script>
</bcxinFooter>
</body>
</html>