<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE HTML>
<html>
<head>
<title>承保</title>
	<%@include file="/WEB-INF/include/head.jsp"%>
</head>

<body class="gray-bg">
	<div class="wrapper add-member-content animated fadeInRight">
		<div class="row">
			<div class="col-sm-12">
				<div class="ibox float-e-margins">
					<!-- 投保信息 start -->
					<div class="ibox-title">
						<h5>
							投保单信息
						</h5>
					</div>
					<div class="ibox-content">
						<div class="form-group">
	
							<label class="col-sm-2 control-label">产品名称：</label>
							<div class="col-sm-4">
								${orderVo.product_name}
							</div>
							<label class="col-sm-2 control-label">投保单号：</label>
							<div class="col-sm-4">
								${orderVo.policy_serial_number}
							</div>
						</div>
					</div>
					<div class="ibox-title">
						<h5>
							被保险人信息
						</h5>
					</div>
					<div class="ibox-content">
						<div class="form-group">
	
							<label class="col-sm-2 control-label">被保险人名称：</label>
							<div class="col-sm-4">
								${orderVo.insured_role}
							</div>
							<label class="col-sm-2 control-label">共同被保险人：</label>
							<div class="col-sm-4">
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">承保经营范围：</label>
							<div class="col-sm-4">
								${orderVo.business_scope}
							</div>
							<label class="col-sm-2 control-label"></label>
							<div class="col-sm-4">
							</div>
						</div>
					</div>
					<div class="ibox-title">
						<h5>
							投保计划
						</h5>
					</div>
					<div class="ibox-content">
						<div class="form-group">
	
							<label class="col-sm-2 control-label">核保报价日期：</label>
							<div class="col-sm-4">
								${underwriteVo.underwrite_time}
							</div>
							<label class="col-sm-2 control-label">保单币种：</label>
							<div class="col-sm-4">
								${fns:getDictLabel (orderVo.policy_currency,"annualCurrency","")}
							</div>
						</div>
						<div class="form-group">
	
							<label class="col-sm-2 control-label">保险期限：</label>
							<div class="col-sm-4">
								${underwriteVo.deadline}
							</div>
							<label class="col-sm-2 control-label">保险公司：</label>
							<div class="col-sm-4">
								${orderVo.insurance_name}
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">承保范围：</label>
							<div class="col-sm-4">
								<c:if test="${underwriteVo.coverage eq 100000021 || underwriteVo.coverage  eq 100000023}">
								 	出口信用商业风险
								</c:if>
								<c:if test="${underwriteVo.coverage eq 100000022 || underwriteVo.coverage  eq 100000024}">
									出口信用政治风险
								</c:if>

							</div>
							<label class="col-sm-2 control-label">可保营业额：</label>
							<div class="col-sm-4">
								${underwriteVo.business_volume}
							</div>
						</div>
					</div>
					<div class="ibox-title">
						<h5>
							承保条件
						</h5>
					</div>
					<div class="ibox-content">
						<div class="form-group">
							<label class="col-sm-2 control-label">最高赔偿限额：</label>
							<div class="col-sm-4">
								${underwriteVo.insurance_amount_max}
							</div>
							<label class="col-sm-2 control-label">逾期欠款通知最后期限：</label>
							<div class="col-sm-4">
								${underwriteVo.balance_overdue_deadline}
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">开票期限：</label>
							<div class="col-sm-4">
								${underwriteVo.make_invoice_deadline}
							</div>
							<label class="col-sm-2 control-label">营业额申报期限：</label>
							<div class="col-sm-4">
								${underwriteVo.declare_time}
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">特殊条件：</label>
							<div class="col-sm-10">
								${underwriteVo.special_if}
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">备注：</label>
							<div class="col-sm-10">
								${underwriteVo.underwrite_remark}
							</div>
						</div>

					</div>
					<!-- 投保信息 end -->
					<c:if test="${ underwriteVo.riskDutyVoList.size()>0 }">
					<!-- 国家分类承保条件 start -->
					<div class="ibox-title">
						<h5>
							国家分类承保条件
						</h5>
					</div>
					<div class="ibox-content">
						<table class="table table-bordered">
							<thead>
								<tr>
									<th>国家/地区危险等级分类</th>
									<th>保险费率(%)</th>
									<th>最长信用账期(天)</th>
									<th>延长保障期限(天)</th>
									<th>不可撤销合同期限(月)</th>
									<th>信用限额</th>
									<th>信用限额承保比例(%)</th>
									<th>核准信用限额承保比例(%)</th>
									<th>各保险责任索赔等待期(天)</th>
									<th>自负额</th>
								</tr>
							</thead>
							<tbody>
								<c:forEach items="${ underwriteVo.riskDutyVoList }" varStatus="index">
		                        <tr>
		                            <td>${underwriteVo.riskDutyVoList[index.index].country_area_risk_type}</td>
		                            <td><fmt:formatNumber value="${underwriteVo.riskDutyVoList[index.index].rate}" pattern="0.00" maxFractionDigits="2"/>%</td>
		                            <td>${underwriteVo.riskDutyVoList[index.index].long_credit}</td>
		                            <td>${underwriteVo.riskDutyVoList[index.index].grace_period}</td>
		                            <td>${underwriteVo.riskDutyVoList[index.index].un_repeal_period}</td>
		                            <td>${underwriteVo.riskDutyVoList[index.index].credit_quota}</td> 
		                            <td><fmt:formatNumber value="${underwriteVo.riskDutyVoList[index.index].credit_quota_rate*100}" pattern="0.00" maxFractionDigits="2"/>%</td>
		                            <td><fmt:formatNumber value="${underwriteVo.riskDutyVoList[index.index].approve_quota_rate*100}" pattern="0.00" maxFractionDigits="2"/>%</td>
		                            <td>${underwriteVo.riskDutyVoList[index.index].claim_period}</td>
		                            <td>${underwriteVo.riskDutyVoList[index.index].deductible}</td> 
		                        </tr>
		                        </c:forEach>
	
							</tbody>
						</table>
	
					</div>
					</c:if>
					
					<!-- 国家分类承保条件 start -->
					<div class="ibox-title">
						<h5>
							保险费及其他费
						</h5>
					</div>
					<div class="ibox-content">
						<div class="form-group">
	
							<label class="col-sm-2 control-label">总保险费率：</label>
							<div class="col-sm-4">
								${ underwriteVo.total_rate }
							</div>
							<label class="col-sm-2 control-label">保费缴纳方式：</label>
							<div class="col-sm-4">
								${fns:getDictLabel (underwriteVo.payment_way,"pay_methods","")}
							</div>
						</div>
						<div class="form-group">
	
							<label class="col-sm-2 control-label">预计年度保费：</label>
							<div class="col-sm-4">
								${underwriteVo.year_premium}
							</div>
							<label class="col-sm-2 control-label">初始保费：</label>
							<div class="col-sm-4">
								${underwriteVo.initial_premium}
							</div>
						</div>
						<div class="form-group">
	
							<label class="col-sm-2 control-label">信用限额调查费：</label>
							<div class="col-sm-4">
								${underwriteVo.credit_credit_fee}
							</div>
							<label class="col-sm-2 control-label"></label>
							<div class="col-sm-4">
							</div>
						</div>
					</div>
					<!-- 国家分类承保条件  end -->

					<!-- 承保信息 start -->
					<div class="ibox-title">
						<h5>
							承保信息
						</h5>
					</div>
					<div class="ibox-content">
					<form id="undform" class="form-horizontal" action="${ctxapi}/myPolicy/updateOrderUnderwriting" method="POST">
						<input type="hidden" name="oid" value="${orderVo.oid}"/>
						<input type="hidden" name="underwritingOid" id="underwritingOid" value="${underwriteVo.oid}"/>
						<input type="hidden" name="signOperate" id="signOperate" value="1"/>
						<input type="hidden" name="sup_id" value="${sup_id}">
						<div class="form-group">
							<label class="col-sm-2 control-label">保单生效时间：</label>
							<div class="col-sm-4">
								<div id="data_5">
									<div class="input-daterange input-group">
										<input type="text" class="form-control" id="begincreate_time" Data-Val="Required" name="inception_date"  value="${orderVo.inception_date}" readonly="readonly"/>
										<span class="input-group-addon">到</span>
										<input type="text" class="form-control" id="endcreate_time" Data-Val="Required" name="planned_end_date"  value="${orderVo.planned_end_date}" readonly="readonly"/>
									</div>
								</div>
							</div>
							<label class="col-sm-2 control-label">承保时间：</label>
							<div class="col-sm-4">
								<input type="text"  class="form-control" Data-Val="Required" name="acceptance_time" id="acceptanceTime" value="${ underwriteVo.acceptance_time }" readonly="readonly">
							</div>
						</div>
						<div class="form-group">
							<label class="col-sm-2 control-label">承保保费：</label>
							<div class="col-sm-4">
								<input type="hidden" name="gross_premium" id="grossPremium" value="${ underwriteVo.year_premium }">
								${ underwriteVo.year_premium }
							</div>
							<label class="col-sm-2 control-label">保单号</label>
							<div class="col-sm-4">
								<input type="text"  class="form-control" Data-Val="Required" name="external_reference" id="externalReference" value="${ orderVo.external_reference }">
							</div>
						</div>
						<div class="hr-line-dashed"></div>
						<div class="form-group">
							<div class="col-sm-6 col-sm-offset-6 add-submit">
								<button class="btn btn-primary dictsubmit" type="button" onclick="toAjaxSubmitByVerify(this)">承保确认</button>
								<button class="btn btn-primary dictsubmit" type="button" onclick="shenheFail()">承保不通过</button>
								<button class="btn btn-primary dictsubmit" type="button" onclick="toAjaxSaveAndClose(this)">保存并关闭</button>
								<button class="btn btn-primary dictsubmit hidden" type="button" onclick="addRemark()">添加备注</button>
							</div>
						</div>
						</form>
						<form id="declinature" class="form-horizontal" action="${ctxapi}/myPolicy/orderAuditFail" method="POST">
							<input type="hidden" name="ty" value="2"/>
							<input type="hidden" name="remarks" id="remarks2"/>
							<input type="hidden" name="order_id" value="${orderVo.oid}"/>
							<input type="hidden" name="sup_id" value="${sup_id}">
						</form>
					</div>
					<!-- 承保信息  end -->

				</div>
			</div>
		</div>
	</div>
	<bcxinFooter> <!-- iCheck --> <script
		src="${ctxsta}/common/icheck/icheck.min.js"></script> <!-- 自定义js -->
		<script src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />" type="text/javascript"></script>
		<script
		type="text/javascript">
            Date.prototype.pattern=function(fmt) {
                var o = {
                    "M+" : this.getMonth()+1, //月份
                    "d+" : this.getDate(), //日
                    "h+" : this.getHours()%12 == 0 ? 12 : this.getHours()%12, //小时
                    "H+" : this.getHours(), //小时
                    "m+" : this.getMinutes(), //分
                    "s+" : this.getSeconds(), //秒
                    "q+" : Math.floor((this.getMonth()+3)/3), //季度
                    "S" : this.getMilliseconds() //毫秒
                };
                var week = {
                    "0" : "/u65e5",
                    "1" : "/u4e00",
                    "2" : "/u4e8c",
                    "3" : "/u4e09",
                    "4" : "/u56db",
                    "5" : "/u4e94",
                    "6" : "/u516d"
                };
                if(/(y+)/.test(fmt)){
                    fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
                }
                if(/(E+)/.test(fmt)){
                    fmt=fmt.replace(RegExp.$1, ((RegExp.$1.length>1) ? (RegExp.$1.length>2 ? "/u661f/u671f" : "/u5468") : "")+week[this.getDay()+""]);
                }
                for(var k in o){
                    if(new RegExp("("+ k +")").test(fmt)){
                        fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
                    }
                }
                return fmt;
            }
            var curDate = new Date();
            var date = new Date((curDate/1000+86400)*1000);
            var nextDate = date.pattern("yyyy/MM/dd");
            $(document).ready(function() {
                $('input').iCheck({
                    checkboxClass : 'icheckbox_flat-green',
                    radioClass : 'iradio_flat-green'
                });
            });
            var start = {
                elem: '#begincreate_time',
                format: 'YYYY/MM/DD',
                min: laydate.now(), //设定最小日期为当前日期
                max: '2099/06/16', //最大日期
                istime: true,
                istoday: false,
                choose: function(datas){
                    end.min = datas; //开始日选好后，重置结束日的最小日期
                    end.start = datas //将结束日的初始值设定为开始日
                    //end.max = "2016-04-29";
                    var ars = datas.split("/");
                    var years = Number(ars[0])+1;
                    var mon = ars[1];
                    var days = ars[2];
                    if (((years % 4)==0) && ((years % 100)!=0) || ((years % 400)==0)) {
                        if(ars[1] == "2"){
                            if(ars[2] == "28"){
                                days = Number(ars[2])+1;
                            }
                        }
                    }
                    var timesend = years +"/"+ mon +"/"+ days;
                    //var tiD = new Date(years,mon,days);
                    //var datee = new Date(tiD.setFullYear(tiD.getFullYear()+1));
                    //var nextDate1 = tiD.pattern("yyyy-MM-dd");
                    end.max = timesend;
                }
            };

            var end = {
                elem: '#endcreate_time',
                format: 'YYYY/MM/DD',
                min: laydate.now(),
                max: '2099/06/16',
                istime: true,
                istoday: false
            };
            var acceptance = {
                elem: '#acceptanceTime',
                format: 'YYYY/MM/DD',
                min: '1900/01/01',
                max: '2099/06/16',
                istime: true,
                istoday: false
            };
            laydate(start);
            laydate(end);
            laydate(acceptance);
			$(document).ready(function() {
				$('input').iCheck({
					checkboxClass : 'icheckbox_flat-green',
					radioClass : 'iradio_flat-green'
				});
			});
			//表单验证-添加管理员验证
			$(function() {
				$('#dictform').bootstrapValidator({
					container : 'tooltip',
					message : 'This value is not valid',
					feedbackIcons : {
						valid : 'glyphicon glyphicon-ok',
						invalid : 'glyphicon glyphicon-remove',
						validating : 'glyphicon glyphicon-refresh'
					},
					fields : {
						'dict.value' : {
							message : '字典名验证失败',
							validators : {
								notEmpty : {
									message : '字典用户名不能为空'
								}
							}
						},
						'dict.label' : {
							message : '字典排序验证失败',
							validators : {
								notEmpty : {
									message : '字典排序不能为空'
								}
							}
						}
					}
				})
			})


		</script>
    <script>
        function customsVerify(){
            var flag = true;
            $("input[Data-Val]").each(function(){
                var dataVal = $(this).attr("Data-Val");
                if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                    if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            layer.msg("必填项不能为空！");
                            $(this).focus();
                            flag = false;
                            return true;
                        }

                    }
                }
            });
            if(flag){
                $("select[Data-Val]").each(function(){
                    var dataVal = $(this).attr("Data-Val");
                    if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                        if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                            if($(this).val() == ''){
                                document.getElementById(this.id).scrollIntoView();
                                layer.msg("必填项不能为空！");
                                $(this).focus();
                                flag = false;
                                return true;
                            }
                        }
                    }
                });

            }
            return flag;
        }
        function  shenheFail(){
            layer.prompt({title: '承保不通过的理由', formType: 2}, function(text, index){
                $("#remarks2").val(text);
                layer.close(index);
                var index0 = layer.load(0, {shade: false});
                $('#declinature').ajaxSubmit(function(result) {
                    if (result.success == true) {
                        window.parent.layer.msg(result.msg, {
                            shade : 0.3,
                            time : 1000
                        }, function() {
                            window.parent.location.reload(); // 刷新父页面
                        });
                    } else {
                        window.parent.layer.msg(result.msg, {
                            icon : 2,
                            time : 1000
                        });
                    }
                    layer.close(index0);
                    return false;
                });
            });
        }
        function  toAjaxSubmitByVerify(obj){
            if(customsVerify()){
                toAjaxSubmit(obj);
            }
        }
        function  toAjaxSaveAndClose(obj){
            $("#signOperate").val("");
            toAjaxSubmit(obj);
        }
        function addRemark(obj){
            layer.prompt({title: '添加备注', formType: 2}, function(text, index){
                $("#remarks").val(text);
                layer.close(index);
            });
        }
        $(function(){
            $("label").each(function(){
                var _class = $(this).attr("class");
                if(_class != undefined){
                    if(_class == "col-sm-2 control-label"&&$(this).html() != ''){
                        var _div = $(this).next();
                        if(_div.is('div')&&_div.html().trim().length == 0){
                            _div.html('-');
                        }
                    }
                }
            });
        });
    </script>
	</bcxinFooter>
</body>
</html>
