<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html lang="zh-cn">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title></title>
	<%@include file="/WEB-INF/include/head.jsp"%>
</head>
<body>
<div class="container bid">
	<div class="content">
		<h3>基础信息</h3>
		<p class="clearfix"><span class="pull-right">订单状态：${fns:getDictLabel (orderVo.policy_status,"order_status","")}</span></p>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">订单号</li>
					<li class="no-bor">${orderVo.trade_serial_number}</li>
					<li class="no-bor">下单时间</li>
					<li class="no-bor">${orderVo.start_time}</li>
					<li class="no-bor">支付方式</li>
					<li class="no-bor">
						<c:set var="paymentMethods" value="${empty transactionList ? '' : transactionList[0].pay_type}"></c:set>
						${empty paymentMethods ? '' : fns:getDictLabel (paymentMethods,"pay_type","")}
					</li>
					<li class="no-bor">最后支付时间</li>
					<li class="no-bor">
						<c:set var="endTimes" value="${empty transactionList ? '' : transactionList[transactionList.size()-1].end_time}"></c:set>
						<c:if test="${not empty endTimes }">
							<fmt:formatDate value="${endTimes}" type="both" pattern="yyyy-MM-dd HH:mm:ss"/>
						</c:if>
					</li>
					<li class="no-bor">支付流水号</li>
					<li class="no-bor">
						<c:forEach items="${transactionList}" var="list">
							${list.trade_serial_number}<br/>
						</c:forEach>
						<%--${empty transactionList ? '' : transactionList.size()}
						${orderVo.pay_methods eq '2' ? '/4' : '/1'}
						<c:if test="${not empty transactionList}">
							<a href="javascript:void(0)" onclick="member_show('支付详情','${ctx}/ins/policy/initTransactionDetail/${orderVo.oid}','','','900',null)" title="支付详情">
								支付详情
							</a>
						</c:if>--%>
					</li>
					<li class="no-bor">下单帐号</li>
					<li class="no-bor">${orderVo.login_name}</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">产品信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">产品名称</li>
					<li class="no-bor" title="${orderVo.product_name}">${orderVo.product_name}</li>
					<li class="no-bor">保费（元）</li>
					<li class="no-bor">${orderVo.gross_premium}</li>
					<li class="no-bor">保险期限</li>
					<li class="no-bor" id="days"></li>
					<li class="no-bor">生效日期</li>
					<li class="no-bor">${orderVo.inception_date}</li>
					<li class="no-bor">保险地区</li>
					<li class="no-bor">${reg_policy}</li>
					<li class="no-bor">保险金额</li>
					<li class="no-bor">${orderVo.insured_amount}</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">投保人信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">公司名称（中文）</li>
					<li class="no-bor" title="${ vo.roleSubjectList[0].name_cn}">${ vo.roleSubjectList[0].name_cn}</li>
					<li class="no-bor">公司名称（英文）</li>
					<li class="no-bor"></li>
					<li class="no-bor">${vo.roleSubjectList[0].id_type eq '1' ? '组织机构代码' : vo.roleSubjectList[0].id_type eq '2' ? '统一社会信用代码' : '证件号码' }</li>
					<li class="no-bor">${ vo.roleSubjectList[0].organization_code}</li>
					<li class="no-bor">企业资质等级</li>
					<li class="no-bor">${vo.aptitude_level eq '1' ? '特级' : vo.aptitude_level eq '2' ? '一级' : vo.aptitude_level eq '3' ? '二级' : vo.aptitude_level eq '4' ? '三级' : vo.aptitude_level eq '5' ? '其它' : '' }</li>
					<li class="no-bor">联系电话</li>
					<li class="no-bor">${ vo.roleSubjectList[0].phone}</li>
					<li class="no-bor">联系人</li>
					<li class="no-bor no-rigbor" title="${ vo.roleSubjectList[0].link_name}">${ vo.roleSubjectList[0].link_name}</li>
					<li class="no-bor">手机号</li>
					<li class="no-bor rig-bor">${ vo.roleSubjectList[0].link_tel}</li>
					<li class="no-bor">电邮地址</li>
					<li class="no-bor rig-bor">${ vo.roleSubjectList[0].link_email}</li>
					<li class="no-bor">联系地址</li>
					<li class="wd80 no-bor" title="${reg_role}${ vo.roleSubjectList[0].reg_address}">${reg_role}${ vo.roleSubjectList[0].reg_address}</li>
				</ul>
			</div>
			<div class="img-show col-xs-12">
				<ul>
					<c:if test="${ not empty vo.roleSubjectList[0].app_tax_path}">
						<li>
							<img src="${ vo.roleSubjectList[0].app_tax_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">税务登记证</span>
								<a target="_blank" href="${ vo.roleSubjectList[0].app_tax_path}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo.roleSubjectList[0].app_organizing_path}">
						<li class="no-bor">
							<img src="${ vo.roleSubjectList[0].app_organizing_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">组织机构代码证</span>
								<a target="_blank" href="${ vo.roleSubjectList[0].app_organizing_path}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo.roleSubjectList[0].app_business_path}">
						<li class="no-bor">
							<img src="${ vo.roleSubjectList[0].app_business_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">营业执照</span>
								<a target="_blank" href="${ vo.roleSubjectList[0].app_business_path}">下载</a>
							</p>
						</li>
					</c:if>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">被投保人信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">公司名称（中文）</li>
					<li class="no-bor" title="${ vo.roleSubjectList[1].name_cn}">${ vo.roleSubjectList[1].name_cn}</li>
					<li class="no-bor">公司名称（英文）</li>
					<li class="no-bor"></li>
					<li class="no-bor">${vo.roleSubjectList[1].id_type eq '1' ? '组织机构代码' : vo.roleSubjectList[1].id_type eq '2' ? '统一社会信用代码' : '证件号码' }</li>
					<li class="no-bor">${ vo.roleSubjectList[1].organization_code}</li>
					<li class="no-bor">联系电话</li>
					<li class="no-bor">${vo.roleSubjectList[1].phone}</li>
					<li class="no-bor">联系地址</li>
					<li class="wd80 no-bor" title="${reg_role_1}${ vo.roleSubjectList[1].reg_address}">${reg_role_1}${ vo.roleSubjectList[1].reg_address}</li>
					<li class="no-bor">联系人</li>
					<li class="no-bor no-rigbor">${vo.roleSubjectList[1].link_name}</li>
					<li class="no-bor">手机号</li>
					<li class="no-bor rig-bor">${vo.roleSubjectList[1].link_tel}</li>
					<%--<li class="no-bor">电邮地址</li>
					<li class="wd80">${map['ins_email']}</li>--%>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">投保基本信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">招标代理机构</li>
					<li class="no-bor" title="${vo.bid_name}">${vo.bid_name}</li>
					<li class="no-bor">项目名称及标段</li>
					<li class="no-bor" title="${vo.project_name}">${vo.project_name}</li>
					<li class="no-bor">招标文件编号</li>
					<li class="no-bor">${vo.invitation_code}</li>
					<li class="no-bor">投标日期</li>
					<li class="no-bor">${vo.bid_time}</li>
					<li class="no-bor">投标有效期</li>
					<li class="no-bor">${vo.bid_period}</li>
					<li class="no-bor">工程类型</li>
					<li class="no-bor">
						<c:forEach items="${ otList }" var="list">
							<c:if test="${vo.office_type eq list.value }">${list.name }</c:if>
						</c:forEach>
					</li>
					<li class="no-bor">计划工期</li>
					<li class="no-bor">${vo.project_time}</li>
					<li class="no-bor">工程建设地点</li>
					<li class="no-bor" title="${ reg_policy}${ vo.address}">${ reg_policy}${ vo.address}</li>
					<li class="no-bor">保险期间</li>
					<li class="no-bor">${vo.inception_date}~${vo.planned_end_date}</li>
					<li class="no-bor">司法管辖</li>
					<li class="no-bor">中华人民共和国司法管辖（港澳台除外）</li>
					<li class="no-bor">争议处理</li>
					<li class="no-bor">${empty vo.dispute ? '' : vo.dispute eq '0' ? '诉讼' :'仲裁，仲裁机构'}&nbsp;&nbsp;${vo.dispute eq '1'?vo.arbitral_institution:''}</li>
				</ul>
			</div>
		</div>
	</div>
	<!-- 票单信息 start -->
	<div class="content">
		<h3 class="mb20">单证信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">是否需要纸质保单</li>
					<li class="no-bor">
						${vo.mailPolicyVo.need_insur_bill eq '0' ? '否' : '是'}
					</li>
					<li class="no-bor">收件人</li>
					<li class="no-bor">
						${ vo.mailPolicyVo.receiver_name}
					</li>
					<li class="no-bor">收件人手机</li>
					<li class="no-bor">
						${ vo.mailPolicyVo.receiver_mobile}
					</li>
					<li class="no-bor">收件地址</li>
					<li class="no-bor">
						${ vo.mailPolicyVo.receiver_address_detail}
					</li>
					<li class="no-bor">是否需要纸质发票</li>
					<li class="no-bor">
						${vo.mailPolicyVo.need_receipt eq '0' ? '否' : '是'}
					</li>
					<li class="no-bor">发票种类</li>
					<li class="no-bor">
						${vo.mailPolicyVo.need_receipt eq '0' ? '' : vo.mailPolicyVo.invoice_type eq '0' ? '增值税普通发票' : '增值税专用发票'}
					</li>
					<c:if test="${vo.mailPolicyVo.invoice_type eq '0'}">
						<li class="no-bor">收件单位</li>
						<li class="no-bor" title="${ vo.mailPolicyVo.receipt_head}">
								${ vo.mailPolicyVo.receipt_head}
						</li>
						<li class="no-bor">收件人</li>
						<li class="no-bor">
								${ vo.mailPolicyVo.taker_name}
						</li>
						<li class="no-bor">收件人手机</li>
						<li class="no-bor">
								${ vo.mailPolicyVo.taker_mobile}
						</li>
						<li class="no-bor">收件地址</li>
						<li class="no-bor" title="${ vo.mailPolicyVo.taker_address_detail}">
								${ vo.mailPolicyVo.taker_address_detail}
						</li>
						<li class="no-bor">纳税人识别号</li>
						<li class="no-bor" title="${ vo.mailPolicyVo.taxpayer_number_invoice}">
								${ vo.mailPolicyVo.taxpayer_number_invoice}
						</li>
					</c:if>
					<c:if test="${vo.mailPolicyVo.invoice_type eq '1'}">
						<li class="no-bor">纳税人识别号</li>
						<li class="no-bor" title="${ vo.mailPolicyVo.taxpayer_number_invoice}">
								${ vo.mailPolicyVo.taxpayer_number_invoice}
						</li>
						<li class="no-bor">注册地址</li>
						<li class="no-bor" title="${ vo.mailPolicyVo.register_address_invoice}">
								${ vo.mailPolicyVo.register_address_invoice}
						</li>
						<li class="no-bor">开户银行</li>
						<li class="no-bor" title="${ vo.mailPolicyVo.bank_invoice}">
								${ vo.mailPolicyVo.bank_invoice}
						</li>
						<li class="no-bor">电话</li>
						<li class="no-bor" title="${ vo.mailPolicyVo.receipt_phone}">
								${ vo.mailPolicyVo.receipt_phone}
						</li>
						<li class="no-bor">银行账号</li>
						<li class="no-bor" title="${ vo.mailPolicyVo.bank_account_invoice}">
								${ vo.mailPolicyVo.bank_account_invoice}
						</li>
					</c:if>
				</ul>
			</div>
			<div class="img-show col-xs-12">
				<ul>
					<c:if test="${ not empty vo.mailPolicyVo.tax_cert}">
						<li>
							<img src="${ vo.mailPolicyVo.tax_cert}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">税务登记证</span>
								<a target="_blank" href="${ vo.mailPolicyVo.tax_cert}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo.mailPolicyVo.tax_prove}">
						<li>
							<img src="${ vo.mailPolicyVo.tax_prove}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">一般纳税人证明</span>
								<a target="_blank" href="${ vo.mailPolicyVo.tax_prove}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo.mailPolicyVo.bank_licence}">
						<li>
							<img src="${ vo.mailPolicyVo.bank_licence}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">银行开户许可证</span>
								<a target="_blank" href="${ vo.mailPolicyVo.bank_licence}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo.mailPolicyVo.business_license}">
						<li>
							<img src="${ vo.mailPolicyVo.business_license}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">营业执照副本</span>
								<a target="_blank" href="${ vo.mailPolicyVo.business_license}">下载</a>
							</p>
						</li>
					</c:if>
					<c:if test="${ not empty vo.mailPolicyVo.auth_cert}">
						<li>
							<img src="${ vo.mailPolicyVo.auth_cert}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">增票授权委托书</span>
								<a target="_blank" href="${ vo.mailPolicyVo.auth_cert}">下载</a>
							</p>
						</li>
					</c:if>
				</ul>
			</div>
		</div>
	</div>
	<!-- 票单信息  end -->
	<c:if test="${ not empty orderVo.external_reference && not empty orderVo.insure_path}">
		<div class="content">
			<h3 class="mb20">保单信息</h3>
			<div class="row bid-context">
				<div class="col-sm-12">
					<ul class="bid-ul">
						<li> 电子保单</li>
						<li class="wd80">
							<a target="_blank" href="${orderVo.insure_path}">查看</a>
						</li>
					</ul>
				</div>
			</div>
		</div>
	</c:if>
	<c:if test="${ not empty orderVo.remarks}">
		<div class="content">
			<h3 class="mb20">其它</h3>
			<div class="row bid-context">
				<div class="col-sm-12">
					<ul class="bid-ul">
						<li> 备注</li>
						<li class="wd80">
								${ orderVo.remarks}
						</li>
					</ul>
				</div>
			</div>
		</div>
	</c:if>
	<div class="operation">
		<div class="row oper-deta">
			<div class="col-xs-12">
				<h3>操作记录</h3>
				<ul class="detail">
					<li class="bc">操作时间</li>
					<li class="bc">操作人员</li>
					<li class="bc">操作事项</li>
					<li class="bc">备注</li>
					<c:forEach items="${logList}" var="list">
						<li><fmt:formatDate value="${list.createTime}" pattern="yyyy/MM/dd HH:mm:ss" /></li>
						<li>${not empty list.company_id ? list.company_id : list.createBy.id}</li>
						<li>${list.title}</li>
						<li>${not empty list.company_id ? 'BLB' : 'YWZC'}</li>
					</c:forEach>
				</ul>
			</div>
		</div>
	</div>
	<%--<div class="examine text-center">
		<a class="btn btn-long btn-lightgreen">核保/承保</a>
		<a class="btn btn-long btn-lightgreen">票单配送</a>
	</div>--%>
</div>
<bcxinFooter>
<script type="text/javascript" src="${ctxsta}/admin/product/js/jquery-1.11.3.js"></script>
	<script>
        $(function(){
            function lineHeight(name){
                var height=parseFloat($("."+name+">li:nth-child(2)").css("height"));
                $("."+name+">li:first-child").css("line-height",height+"px").css("padding","0");
            }
            lineHeight("big");
            lineHeight("img-look");
            lineHeight("addr");
            lineHeight("day");
            btnCount_Click();
        })
        function  btnCount_Click(){//d1失效日期，d2生效日期
            var d1 = '${orderVo.planned_end_date}';
            var d2 = '${orderVo.inception_date}';
            var days = '';
            if(d1 != '' && d2 != ''){
                days = DateDiff(d1,d2)+'天';
            }
            $("#days").html(days);
        }

        //计算天数差的函数，通用
        function  DateDiff(sDate1,  sDate2){    //sDate1和sDate2是2006-12-18格式
            var  aDate,  oDate1,  oDate2,  iDays
            aDate  =  sDate1.split("-")
            oDate1  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])    //转换为12-18-2006格式
            aDate  =  sDate2.split("-")
            oDate2  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])
            iDays  =  parseInt(Math.abs(oDate1  -  oDate2)  /  1000  /  60  /  60  /24) + 1    //把相差的毫秒数转换为天数
            return  iDays
        }
	</script>
</bcxinFooter>
</body>
</html>
