<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html lang="zh-cn">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title></title>
	<%@include file="/WEB-INF/include/head.jsp"%>
	<style>
		.bid-context table{
			width: 100%;

		}
		.bid-context table thead tr{
			background: #eee;
		}
		.bid-context table tr{
			line-height: 40px;
		}
		.bid-context table tr td{
			text-align: center;
			border: 1px solid #ddd;
		}
	</style>
</head>
<body>
<div class="container bid">
	<div class="content">
		<h3>基础信息</h3>
		<p class="clearfix"><span class="pull-right">订单状态：${fns:getDictLabel (orderVo.policy_status,"order_status","")}</span></p>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">订单号</li>
					<li class="no-bor">${orderVo.trade_serial_number}</li>
					<li class="no-bor">投保单号</li>
					<li class="no-bor">${orderVo.policy_serial_number}</li>
					<li class="no-bor">下单时间</li>
					<li class="no-bor">${orderVo.start_time}</li>
					<li class="no-bor">支付方式</li>
					<li class="no-bor">
						<c:set var="paymentMethods" value="${empty transactionList ? '' : transactionList[0].payment_method}"></c:set>
						${empty paymentMethods ? '-' : fns:getDictLabel (paymentMethods,"pay_type","")}
					</li>
					<li class="no-bor">最后支付时间</li>
					<li class="no-bor">
						<c:set var="endTimes" value="${empty transactionList ? '' : transactionList[transactionList.size()-1].end_time}"></c:set>
						<c:if test="${not empty endTimes }">
							<fmt:formatDate value="${endTimes}" type="both" pattern="yyyy-MM-dd HH:mm:ss"/>
						</c:if>
					</li>
					<li class="no-bor">支付流水号</li>
					<li class="no-bor">
						<c:forEach items="${transactionList}" var="list">
							${list.trade_serial_number}<br/>
						</c:forEach>
						<%--${empty transactionList ? '-' : transactionList.size()}
						${orderVo.pay_methods eq '2' ? '/4' : '/1'}
						<c:if test="${not empty transactionList}">
							<a href="javascript:void(0)" onclick="member_show('支付详情','${ctx}/ins/policy/initTransactionDetail/${orderVo.oid}','','','900',null)" title="支付详情">
								支付详情
							</a>
						</c:if>--%>
					</li>
					<li class="no-bor">下单帐号</li>
					<li class="no-bor">${orderVo.login_name}</li>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">产品信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">产品名称</li>
					<li class="no-bor">${orderVo.product_name}</li>
					<li class="no-bor">保费（元）</li>
					<li class="no-bor">${orderVo.gross_premium}</li>
					<li class="no-bor">保险期限</li>
					<li class="no-bor" id="days"></li>
					<li class="no-bor">总保额</li>
					<li class="no-bor"><fmt:formatNumber value="${orderVo.insured_amount}" type="number"/></li>
					<li class="no-bor">生效日期</li>
					<li class="wd80 no-bor">
						${vo.inception_date}
						零时起至
						${vo.planned_end_date}二十四时止
					</li>
					<li class="no-bor">受益人</li>
					<li class="wd80 no-bor">
						法定继承人
					</li>
				</ul>
				<%--<table>
					<thead>
					<tr>
						<td class="col-sm-6 col-xs-6">保障责任</td>
						<td class="col-sm-6 col-xs-6">保险金额</td>
					</tr>
					</thead>
					<tbody>
					<c:if test="${fn:contains(orderVo.product_code, 'GZX-CA')}">
							<tr>
								<c:if test="${ vo.activity_scheme eq '1' }">
									<td class="col-sm-6 col-xs-6">方案一</td>
									<td class="col-sm-6 col-xs-6">100 万元</td>
								</c:if>
								<c:if test="${ vo.activity_scheme eq '2' }">
									<td class="col-sm-6 col-xs-6">方案二</td>
									<td class="col-sm-6 col-xs-6">200 万元</td>
								</c:if>
								<c:if test="${ vo.activity_scheme eq '3' }">
									<td class="col-sm-6 col-xs-6">方案三</td>
									<td class="col-sm-6 col-xs-6">500 万元</td>
								</c:if>
							</tr>
					</c:if>
					<c:if test="${fn:contains(orderVo.product_code, 'GZX-PAC')}">
							<tr>
								<c:if test="${ vo.activity_scheme eq '1' }">
									<td class="col-sm-6 col-xs-6">方案一</td>
									<td class="col-sm-6 col-xs-6">100 万元</td>
								</c:if>
								<c:if test="${ vo.activity_scheme eq '2' }">
									<td class="col-sm-6 col-xs-6">方案二</td>
									<td class="col-sm-6 col-xs-6">200 万元</td>
								</c:if>
								<c:if test="${ vo.activity_scheme eq '3' }">
									<td class="col-sm-6 col-xs-6">方案三</td>
									<td class="col-sm-6 col-xs-6">500 万元</td>
								</c:if>
							</tr>
					</c:if>
					<c:if test="${fn:contains(orderVo.product_code, 'GZX-HT')}">
						<tr>
							<td class="col-sm-6 col-xs-6">大型活动公众责任</td>
							<td class="col-sm-6 col-xs-6">活动人数≤5000人
								每人每次赔偿限额：25万
								每次事故及累计限额：人民币500万≤累计赔偿限额＜人民币1000万
								活动人数：5001-10000
								每人每次赔偿限额：25万
								每次事故及累计限额：人民币1000万≤累计赔偿限额＜人民币1500万
								活动人数：10001-50000
								每人每次赔偿限额：25万
								每次事故及累计限额：人民币1500万≤累计赔偿限额＜人民币2000万
								活动人数：50000以上
								每人每次赔偿限额：25万
								每次事故及累计限额：人民币2000万≤累计赔偿限额＜人民币3500万</td>
						</tr>
					</c:if>
					</tbody>
				</table>--%>
				<table class="table ">
					<tbody>
					<tr>
						<td class="col-sm-4 col-xs-4">保障责任</td>
						<td class="col-sm-2 col-xs-2">
							<c:set var="irp_1" value="${ vo.responsibilityVoList[0] }"></c:set>
							<c:choose>
								<c:when test="${empty irp_1.insurance_amount_max && not empty irp_1.fcy}">
									保险金额
								</c:when>
								<c:when test="${empty irp_1.fcy && not empty irp_1.insurance_amount_max}">
									赔偿限额
								</c:when>
								<c:otherwise>
									保险金额
								</c:otherwise>
							</c:choose>
						</td>
						<td class="col-sm-2 col-xs-2">免赔额</td>
						<td class="col-sm-2 col-xs-2">赔付比例</td>
						<td class="col-sm-2 col-xs-2">免赔天数</td>
					</tr>
					<c:forEach items="${ vo.responsibilityVoList }" var="irp">
						<tr <c:choose>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '0' && irp.is_optional eq '2'}">
								hidden
							</c:when>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '1' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障一')}">
								hidden
							</c:when>
							<c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '2' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障二')}">
								hidden
							</c:when>
							<c:when test="${empty vo.is_contain_repo && irp.is_optional eq '2'}">
								hidden
							</c:when>
							<c:otherwise>

							</c:otherwise>
						</c:choose>>
							<td class="col-sm-4 col-xs-4" style="text-align:left; <c:if test="${irp.name eq '烈士褒扬金'}">color: red;</c:if>">${irp.name}<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="${irp.explain_product}"/></td>
							<td class="col-sm-2 col-xs-2" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
								<c:choose>
									<c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
													<c:if test="${irp.fcy/10000 >= 1}">
														${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.fcy/10000 < 1}">
														${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
														元/天
													</c:if>
												</c:if>
											</span>
									</c:when>
									<c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
													-
												</c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元
													</c:if>
												</c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
													<c:if test="${irp.insurance_amount_max/10000 >= 1}">
														${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
														万元/天
													</c:if>
													<c:if test="${irp.insurance_amount_max/10000 < 1}">
														${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
														元/天
													</c:if>
												</c:if>
											</span>
									</c:when>
									<c:otherwise>
										<span>-</span>
									</c:otherwise>
								</c:choose>
							</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</td>
							<td class="col-sm-2 col-xs-2" >${empty irp.deductible_days ? '-' : irp.deductible_days}</td>
						</tr>
					</c:forEach>
					</tbody>
				</table>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">投保人信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">投保单位</li>
					<li class="no-bor" title="${vo.roleSubjectList[0].name_cn}">${vo.roleSubjectList[0].name_cn}</li>
					<li class="no-bor">营业性质</li>
					<li class="wd80 no-bor">
						<c:forEach items="${natureList }" var="list">
							<c:if test="${list.value eq vo.roleSubjectList[0].com_nature}">
								${list.name}
							</c:if>
						</c:forEach>
						<c:forEach items="${natureList }" var="list">
							<c:if test="${list.value eq vo.roleSubjectList[0].nature_two}">
								${list.name}
							</c:if>
						</c:forEach>
					</li>
					<li class="no-bor">投保人地址</li>
					<li class="no-bor" title="${reg_role}${vo.roleSubjectList[0].reg_address}">
						${reg_role}${vo.roleSubjectList[0].reg_address}
					</li>
					<li class="no-bor">证件类型</li>
					<li class="no-bor">
						<c:if test="${fn:contains(orderVo.product_code, 'GZX-HT')}">
							<c:if test="${vo.roleSubjectList[0].id_type eq '7'}">
								营业执照
							</c:if>
							<c:if test="${vo.roleSubjectList[0].id_type eq '8'}">
								税务登记证
							</c:if>
							<c:if test="${vo.roleSubjectList[0].id_type eq '9'}">
								组织机构代码证
							</c:if>
						</c:if>
						<c:if test="${fn:contains(orderVo.product_code, 'GZX-PAC')||fn:contains(orderVo.product_code, 'GZX-CA')}">
							<c:forEach items="${comTypeList }" var="list">
								<c:if test="${list.value eq vo.roleSubjectList[0].id_type}">
									${list.name}
								</c:if>
							</c:forEach>
						</c:if>
					</li>
					<li class="no-bor">证件号码</li>
					<li class="no-bor">${vo.roleSubjectList[0].organization_code}</li>
					<li class="no-bor">联系人姓名</li>
					<li class="no-bor" title="${vo.roleSubjectList[0].link_name}">${vo.roleSubjectList[0].link_name}</li>
					<li class="no-bor">联系人手机</li>
					<li class="no-bor">${vo.roleSubjectList[0].link_tel}</li>
					<li class="no-bor">投保人证件扫描件</li>


				</ul>
			</div>
			<div class="img-show col-xs-12">
				<ul>
					<c:if test="${ not empty vo.roleSubjectList[0].app_organizing_path}">
						<li>
							<img src="${ vo.roleSubjectList[0].app_organizing_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">附件</span>
								<a target="_blank" href="${ vo.roleSubjectList[0].app_organizing_path}">下载</a>
							</p>
						</li>
					</c:if>
				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">被保人信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">被保人单位</li>
					<li class="no-bor" title="${vo.roleSubjectList[1].name_cn}">${vo.roleSubjectList[1].name_cn}</li>
					<li class="no-bor">营业性质</li>
					<li class="wd80 no-bor">
						<c:forEach items="${natureList }" var="list">
							<c:if test="${list.value eq vo.roleSubjectList[1].com_nature}">
								${list.name}
							</c:if>
						</c:forEach>
						<c:forEach items="${natureList }" var="list">
							<c:if test="${list.value eq vo.roleSubjectList[1].nature_two}">
								${list.name}
							</c:if>
						</c:forEach>
					</li>
					<li class="no-bor">详细地址</li>
					<li class="no-bor" title="${reg_role_1}${vo.roleSubjectList[1].reg_address}">
						${reg_role_1}${vo.roleSubjectList[1].reg_address}
					</li>
					<li class="no-bor">证件类型</li>
					<li class="no-bor">
						<c:if test="${fn:contains(orderVo.product_code, 'GZX-HT')}">
							<c:if test="${vo.roleSubjectList[1].id_type eq '7'}">
								营业执照
							</c:if>
							<c:if test="${vo.roleSubjectList[1].id_type eq '8'}">
								税务登记证
							</c:if>
							<c:if test="${vo.roleSubjectList[1].id_type eq '9'}">
								组织机构代码证
							</c:if>
						</c:if>
						<c:if test="${fn:contains(orderVo.product_code, 'GZX-PAC')||fn:contains(orderVo.product_code, 'GZX-CA')}">
							<c:forEach items="${comTypeList }" var="list">
								<c:if test="${list.value eq vo.roleSubjectList[1].id_type}">
									${list.name}
								</c:if>
							</c:forEach>
						</c:if>
					</li>
					<li class="no-bor">证件号码</li>
					<li class="no-bor">${vo.roleSubjectList[1].organization_code}</li>
					<li class="no-bor">联系人姓名</li>
					<li class="no-bor" title="${vo.roleSubjectList[1].link_name}">${vo.roleSubjectList[1].link_name}</li>
					<li class="no-bor">联系人手机</li>
					<li class="no-bor">${vo.roleSubjectList[1].link_tel}</li>
					<li class="no-bor">投保人证件扫描件</li>

				</ul>
			</div>
			<div class="img-show col-xs-12">
				<ul>
					<c:if test="${ not empty vo.roleSubjectList[1].app_organizing_path}">
						<li>
							<img src="${ vo.roleSubjectList[1].app_organizing_path}" alt="1" style="width: 100px;"/>
							<p>
								<span class="pull-left">附件</span>
								<a target="_blank" href="${ vo.roleSubjectList[1].app_organizing_path}">下载</a>
							</p>
						</li>
					</c:if>
				</ul>
			</div>
		</div>
	</div>

	<div class="content">
		<h3 class="mb20">活动信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">活动名称</li>
					<li class="no-bor" title="${vo.report_name}">${vo.report_name}</li>
					<li class="no-bor">活动类型</li>
					<li class="no-bor">
						<c:if test="${vo.report_active eq 'ZL'}">
							展览展销类
						</c:if>
						<c:if test="${vo.report_active eq 'WY'}">
							文艺演出类
						</c:if>
						<c:if test="${vo.report_active eq 'TY'}">
							体育赛事类
						</c:if>
						<c:if test="${vo.report_active eq 'QT'}">
							其他类活动
						</c:if>
					</li>
					<li class="no-bor">活动期间</li>
					<li class="no-bor">${vo.report_begin_date}—${vo.report_end_date}</li>
					<c:if test="${fn:contains(orderVo.product_code, 'GZX-PAC')||fn:contains(orderVo.product_code, 'GZX-CA')}">
						<li class="no-bor">临建设施搭建天数</li>
						<li class="no-bor">
								${vo.buss_days}
						</li>
						<li class="no-bor">临建设施拆除天数</li>
						<li >
								${vo.tear_days}
						</li>
					</c:if>
					<li class="no-bor">承保区域</li>
					<li class="no-bor">${vo.report_local}</li>
					<li class="no-bor">活动地点</li>
					<li class="no-bor">
						<c:if test="${vo.activity_local eq 'INDOOR'}">
							室内场馆
						</c:if>
						<c:if test="${vo.activity_local eq 'OPEN'}">
							露天场馆
						</c:if>
						<c:if test="${vo.activity_local eq 'OUTDOOR'}">
							户外场馆
						</c:if>
					</li>
					<c:if test="${fn:contains(orderVo.product_code, 'GZX-PAC')||fn:contains(orderVo.product_code, 'GZX-CA')}">
						<li class="no-bor">展览会场所面积（平米）</li>
						<li class="no-bor">
								${vo.ex_acreage}
						</li>
					</c:if>
					<c:if test="${fn:contains(orderVo.product_code, 'GZX-HT')}">
						<li class="no-bor">消防情况</li>
						<li class="no-bor">
							<c:if test="${vo.activity_fire_fight eq 'ACCEPTANCE'}">
								有消防验收
							</c:if>
							<c:if test="${vo.activity_fire_fight eq 'EXTINGUISHER'}">
								无消防验收但配备灭火器
							</c:if>
							<c:if test="${vo.activity_fire_fight eq 'NO_EXTINGUISHER'}">
								无消防验收无灭火器
							</c:if>
						</li>
						<li class="no-bor">有无危险环节（如烟花）</li>
						<li >
							<c:if test="${vo.danger eq 'HAVE'}">
								有
							</c:if>
							<c:if test="${vo.danger eq 'WITHOUT'}">
								无
							</c:if>
						</li>
					</c:if>

					<li class="no-bor">预计活动参与总人数</li>
					<li >
						${vo.people_num}
					</li>
					<li class="no-bor">预计天数</li>
					<li >
						${vo.activity_days}
					</li>

				</ul>
			</div>
		</div>
	</div>

	<div class="content">
		<h3 class="mb20">保险方案</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<c:if test="${fn:contains(orderVo.product_code, 'GZX-CA')}">
						<li class="no-bor">每人每次事故赔偿限额</li>
						<li class="no-bor">
							<c:if test="${ empty vo.activity_scheme || vo.activity_scheme eq '1' }">
								<span>10万</span>
							</c:if>
							<c:if test="${ vo.activity_scheme eq '2' }">
								<span>15万</span>
							</c:if>
							<c:if test="${ vo.activity_scheme eq '3' }">
								<span>20万</span>
							</c:if>
						</li>
						<li class="no-bor">每次事故及累计赔偿限额</li>
						<li class="no-bor">
							<c:if test="${ empty vo.activity_scheme || vo.activity_scheme eq '1' }">
								<span>100万</span>
							</c:if>
							<c:if test="${ vo.activity_scheme eq '2' }">
								<span>200万</span>
							</c:if>
							<c:if test="${ vo.activity_scheme eq '3' }">
								<span>500万</span>
							</c:if>
						</li>
					</c:if>
					<c:if test="${fn:contains(orderVo.product_code, 'GZX-PAC')}">
						<li class="no-bor">每人每次事故赔偿限额</li>
						<li class="no-bor">
							<c:if test="${ empty vo.activity_scheme || vo.activity_scheme eq '1' }">
								<span>10万</span>
							</c:if>
							<c:if test="${ vo.activity_scheme eq '2' }">
								<span>15万</span>
							</c:if>
							<c:if test="${ vo.activity_scheme eq '3' }">
								<span>20万</span>
							</c:if>
						</li>
						<li class="no-bor">每次事故及累计赔偿限额</li>
						<li class="no-bor">
							<c:if test="${ empty vo.activity_scheme || vo.activity_scheme eq '1' }">
								<span>100万</span>
							</c:if>
							<c:if test="${ vo.activity_scheme eq '2' }">
								<span>200万</span>
							</c:if>
							<c:if test="${ vo.activity_scheme eq '3' }">
								<span>500万</span>
							</c:if>
						</li>
					</c:if>
					<c:if test="${fn:contains(orderVo.product_code, 'GZX-HT')}">
						<li class="no-bor">每人每次事故赔偿限额</li>
						<li class="no-bor">25万元</li>
						<li class="no-bor">每次事故及累计赔偿限额</li>
						<li class="no-bor">
							<fmt:formatNumber value="${orderVo.insured_amount}" type="number"/>万
						</li>
					</c:if>

					<li class="no-bor">保险期间</li>
					<li class="wd80 no-bor">
						${vo.inception_date}
						零时起至
						${vo.planned_end_date}二十四时止
					</li>
					<li class="no-bor">免赔设定</li>
					<li class="wd80 no-bor">财产损失500元，人身伤害无免赔</li>
					<li class="no-bor">总保险费</li>
					<li  class="wd80 no-bor">${vo.premium}</li>

				</ul>
			</div>
		</div>
	</div>
	<div class="content">
		<h3 class="mb20">争议处理</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li>解决方式</li>
					<li><c:if test="${vo.dispute eq '1'}">仲裁:${vo.policy_extra_dispute}</c:if>
						<c:if test="${vo.dispute eq '0'}">诉讼</c:if>
					</li>
				</ul>
			</div>
		</div>
	</div>

	<div class="content">
		<h3 class="mb20">退保账户信息</h3>
		<div class="row bid-context">
			<div class="col-sm-12">
				<ul class="bid-ul">
					<li class="no-bor">开户名</li>
					<li class="wd80 no-bor">${vo.roleSubjectList[0].account_name}</li>
					<li class="no-bor">账户开户行</li>
					<li class="wd80 no-bor">${vo.roleSubjectList[0].bank_name}</li>
					<li class="no-bor">银行账号</li>
					<li class="wd80 no-bor">${vo.roleSubjectList[0].bank_account}</li>
				</ul>
			</div>
		</div>
	</div>

	<!-- 票单信息 start -->
	<div class="ibox-title">
		<h5>
			单证信息
		</h5>
	</div>
	<div class="ibox-content">

		<div class="hr-line-dashed"></div>
		<div class="form-group">
			<label class="col-sm-7 control-label">保单信息：</label>
		</div>

		<div class="hr-line-dashed"></div>
		<div class="form-group">
			<label class="col-sm-2 control-label">是否需要纸质保单：</label>
			<div class="col-sm-10">
				${vo.mailPolicyVo.need_insur_bill eq '0' ? '否' : '是'}
			</div>
		</div>

		<div class="hr-line-dashed"></div>
		<div class="form-group">
			<label class="col-sm-2 control-label">收件人：</label>
			<div class="col-sm-4">
				${ vo.mailPolicyVo.receiver_name}
			</div>
			<label class="col-sm-2 control-label">收件人手机：</label>
			<div class="col-sm-4">
				${ vo.mailPolicyVo.receiver_mobile}
			</div>
		</div>
		<div class="hr-line-dashed"></div>
		<div class="form-group">
			<label class="col-sm-2 control-label">收件地址：</label>
			<div class="col-sm-10">
				${ vo.mailPolicyVo.receiver_address_detail}
			</div>
		</div>

		<div class="hr-line-dashed"></div>
		<div class="form-group">
			<label class="col-sm-2 control-label">是否需要纸质发票：</label>
			<div class="col-sm-4">
				${vo.mailPolicyVo.need_receipt eq '0' ? '否' : '是'}
			</div>
			<c:if test="${vo.mailPolicyVo.need_receipt eq '1'}">
				<label class="col-sm-2 control-label">发票种类：</label>
				<div class="col-sm-4">
						${vo.mailPolicyVo.need_receipt eq '0' ? '' : vo.mailPolicyVo.invoice_type eq '0' ? '增值税普通发票' : '增值税专用发票'}
				</div>
			</c:if>

		</div>
		<c:if test="${vo.mailPolicyVo.need_receipt eq '1'}">
			<div class="hr-line-dashed"></div>

			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">收件人手机：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.taker_mobile}
				</div>
				<label class="col-sm-2 control-label">收件地址：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.taker_address_detail}
				</div>

			</div>
			<div class="form-group">

				<label class="col-sm-2 control-label">收件人：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.taker_name}
				</div>
				<label class="col-sm-2 control-label">纳税人识别号：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.taxpayer_number_invoice}
				</div>

			</div>
		</c:if>
		<c:if test="${vo.mailPolicyVo.invoice_type eq '1'}">
			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">单位名称：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.receipt_head}
				</div>
				<label class="col-sm-2 control-label">银行账号：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.bank_account_invoice}
				</div>
			</div>


			<div class="hr-line-dashed"></div>
			<div class="form-group">

				<label class="col-sm-2 control-label">注册地址：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.register_address_invoice}
				</div>

			</div>
			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">开户银行：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.bank_invoice}
				</div>
				<label class="col-sm-2 control-label">电话：</label>
				<div class="col-sm-4">
						${ vo.mailPolicyVo.receipt_phone}
				</div>

			</div>


			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label style="display: block;float: left;width: 25%;text-align: center;">税务登记证：</label>
				<div style="float: left;width: 25%">&nbsp;
					<c:if test="${not empty vo.mailPolicyVo.tax_cert}">
						<img alt="税务登记证" src="${ vo.mailPolicyVo.tax_cert}" style="width: 100px;height: 100px">
						<a href="${ vo.mailPolicyVo.tax_cert}"  target="_blank">下载</a>

					</c:if>
				</div>
				<label style="display: block;float: left;width: 25%;text-align: center;">一般纳税人证明：</label>
				<div style="float: left;width: 25%">&nbsp;
					<c:if test="${not empty vo.mailPolicyVo.tax_prove}">
						<img alt="一般纳税人证明" src="${ vo.mailPolicyVo.tax_prove}" style="width: 100px;height: 100px">
						<a href="${ vo.mailPolicyVo.tax_prove}"  target="_blank">下载</a>

					</c:if>
				</div>
				<label style="display: block;float: left;width: 25%;text-align: center;">银行开户许可证：</label>
				<div style="float: left;width: 25%">&nbsp;
					<c:if test="${not empty vo.mailPolicyVo.bank_licence}">
						<img alt="银行开户许可证" src="${ vo.mailPolicyVo.bank_licence}" style="width: 100px;height: 100px">
						<a href="${ vo.mailPolicyVo.bank_licence}"  target="_blank">下载</a>
					</c:if>
				</div>
				<label style="display: block;float: left;width: 25%;text-align: center;">营业执照副本：</label>
				<div style="float: left;width: 25%">&nbsp;
					<c:if test="${not empty vo.mailPolicyVo.business_license}">
						<img alt="营业执照副本" src="${ vo.mailPolicyVo.business_license}" style="width: 100px;height: 100px">
						<a href="${ vo.mailPolicyVo.business_license}"  target="_blank">下载</a>

					</c:if>
				</div>
				<label style="display: block;float: left;width: 25%;text-align: center;">增票授权委托书：</label>
				<div style="float: left;width: 25%">&nbsp;
					<c:if test="${not empty vo.mailPolicyVo.auth_cert}">
						<img alt="增票授权委托书" src="${ vo.mailPolicyVo.auth_cert}" style="width: 100px;height: 100px">
						<a href="${ vo.mailPolicyVo.auth_cert}"  target="_blank">下载</a>
					</c:if>
				</div>
			</div>
		</c:if>
	</div>
	<c:if test="${ not empty orderVo.external_reference && not empty orderVo.insure_path}">
		<div class="ibox-title">
			<h5>
				保单信息
			</h5>
		</div>
		<div class="ibox-content">
			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">电子保单：</label>
				<div class="col-sm-10">
					<a target="_blank" href="${orderVo.insure_path}">查看</a>
				</div>
			</div>
		</div>
	</c:if>
	<c:if test="${ not empty orderVo.remarks}">
		<div class="ibox-title">
			<h5>
				其它
			</h5>
		</div>
		<div class="ibox-content">
			<div class="hr-line-dashed"></div>
			<div class="form-group">
				<label class="col-sm-2 control-label">备注:</label>
				<div class="col-sm-10">
						${ orderVo.remarks}
				</div>
			</div>
		</div>
	</c:if>
	<div class="operation">
		<div class="row oper-deta">
			<div class="col-xs-12">
				<h3>操作记录</h3>
				<ul class="detail">
					<li class="bc">操作时间</li>
					<li class="bc">操作人员</li>
					<li class="bc">操作事项</li>
					<li class="bc">备注</li>
					<c:forEach items="${logList}" var="list">
						<li><fmt:formatDate value="${list.createTime}" pattern="yyyy/MM/dd HH:mm:ss" /></li>
						<li>${not empty list.company_id ? list.company_id : list.createBy.id}</li>
						<li>${list.title}</li>
						<li>${not empty list.company_id ? 'BLB' : 'YWZC'}</li>
					</c:forEach>
				</ul>
			</div>
		</div>
	</div>
	</div>
</div>
<bcxinFooter>
<script type="text/javascript" src="${ctxsta}/admin/product/js/jquery-1.11.3.js"></script>
	<script>
        $(function(){
            function lineHeight(name){
                var height=parseFloat($("."+name+">li:nth-child(2)").css("height"));
                $("."+name+">li:first-child").css("line-height",height+"px").css("padding","0");
            }
            lineHeight("big");
            lineHeight("img-look");
            lineHeight("addr");
            lineHeight("day");
            btnCount_Click();
        })
        function  btnCount_Click(){//d1失效日期，d2生效日期
            var d1 = '${orderVo.planned_end_date}';
            var d2 = '${orderVo.inception_date}';
            var days = '';
            if(d1 != '' && d2 != ''){
                days = DateDiff(d1,d2)+'天';
            }
            $("#days").html(days);
        }

        //计算天数差的函数，通用
        function  DateDiff(sDate1,  sDate2){    //sDate1和sDate2是2006-12-18格式
            var  aDate,  oDate1,  oDate2,  iDays
            aDate  =  sDate1.split("-")
            oDate1  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])    //转换为12-18-2006格式
            aDate  =  sDate2.split("-")
            oDate2  =  new  Date(aDate[1]  +  '-'  +  aDate[2]  +  '-'  +  aDate[0])
            iDays  =  parseInt(Math.abs(oDate1  -  oDate2)  /  1000  /  60  /  60  /24) + 1    //把相差的毫秒数转换为天数
            return  iDays
        }
	</script>
</bcxinFooter>
</body>
</html>
