<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>信息统计</title>
    <%@include file="/WEB-INF/include/head.jsp"%>
    <style>
        .ibox-content{
            background-color: #fff !important;
        }
    </style>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">

    <div class="row">
        <div class="col-sm-6">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>用户登录数据</h5>
                    <div class="ibox-tools" style="bottom: 8px;">
                        <select class="form-control" onchange="u1($(this).val())">
                            <c:forEach items="${ys}" var="y">
                                <option value="${y}" <c:if test="${y eq ty}"> selected</c:if>>${y}年</option>
                            </c:forEach>
                        </select>
                    </div>
                </div>
                <div class="ibox-content" id="chartmain" style="height: 400px">
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>用户注册数据</h5>
                    <div class="ibox-tools" style="bottom: 8px;">
                        <select class="form-control" onchange="u2($(this).val())">
                            <c:forEach items="${ys}" var="y">
                                <option value="${y}" <c:if test="${y eq ty}"> selected</c:if>>${y}年</option>
                            </c:forEach>
                        </select>
                    </div>
                </div>
                <div class="ibox-content" id="userregchart" style="height: 400px">
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script type="text/javascript">
        function refresh(){
            $('#defaultTable').bootstrapTable('refresh');
        }
        $(document).ready(function () {
            //查询按钮
            $("#queryBtn").unbind('click').click(function(){
                $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});
            });

            //清空查询列表
            $("#clearQueryForm").unbind('click').click(function(){
                $("#queryForm").form("clear");
            });

        });
        function planFn(value, row, index){
            return row.plan_star_time + '~' + row.plan_end_time;
        }
        function informTypeFn(value, row, index){
            var it = '';
            if('1' == value){
                it = '系统升级';
            }else if('1' == value){
                it = '功能或产品推广';
            }
            return it;
        }
        function setY(){

        }
        function executeTypeFn(value, row, index){
            var it = '';
            if('1' == value){
                it = '每次';
            }else if('1' == value){
                it = '单次';
            }else if('1' == value){
                it = '暂停';
            }
            return it;
        }

        function rownumFn(value, row, index){
            var opt = $('#defaultTable').bootstrapTable('getOptions');
            if(opt.pageSize=="All") return index +1;
            return opt.pageSize * (opt.pageNumber - 1) + index + 1;
        }

        function formatOperationFn(index, row) {
            var str = "";
            //查看然后编辑按钮
            <shiro:hasPermission name="myinf:win:upd">
                var onClick = "layer_show('修改公告-"+row.city_name+"','${ctx}/myinf/win/upd?com_inform_id=${p.com_inform_id}',980,null);";
                str += '<a class="edit m-l-sm text-warning" href="javascript:void(0)" onclick="'+onClick+'" title="查看" > <i class="glyphicon glyphicon-edit"></i></a>';
            </shiro:hasPermission>
            <shiro:hasPermission name="myinf:win:del">
                var onClick2= "member_del(this,'"+row.com_inform_id+"')";
                str += '<a class="remove m-l-sm text-primary" href="javascript:void(0)" onclick="'+onClick2+'" title="删除" > <i class="glyphicon glyphicon-remove"></i></a>';
            </shiro:hasPermission>
                return str;
        }
        /*删除公告*/
        function member_del(obj, id) {
            layer.confirm('确认要删除该公告信息吗？', {  btn: ['确定', '取消'] }, function () {
                g_ajax('${ctx}/myinf/del',{com_inform_id:id}, function(json){
                    comm_back(json);
                });
            });
        }
        function comm_back(json){
            if (json.success == true) {
                $('#defaultTable').bootstrapTable('refresh');
                layer.msg(json.msg, {icon: 1, time: 1000});
            } else {
                layer.alert(json.msg, {icon: 2});
            }
        }

        function myQueryParams(params) { //limit offset order sort
            var obj = g_sobj($("#queryForm").form());
            for(var i in obj){
                if(obj[i]=="") eval("delete obj."+i);
            }
            return $.extend(obj, params);
        }
        function u1(y){
            g_ajax('${ctx}/mysta/user',{year:y}, function(json){
                if(json.success == true){
                    userchart(json);
                }
            });
        }
        function u2(y){
            g_ajax('${ctx}/mysta/user-reg',{year:y}, function(json){
                if(json.success == true){
                    userregchart(json);
                }
            });
        }
        $(function(){
            u1("2018");
            setTimeout(function(){u2("2018");},100);
        });

        function userregchart(json){
            option = {
                title : {
                    text: '年度平台用户注册数据统计',
                    subtext: 'BLB:百联保流量，THR:第三方平台流量'
                },
                tooltip : {
                    trigger: 'axis'
                },
                legend: {
                    data:['BLB','THR']
                },
                toolbox: {
                    show : true,
                    feature : {
                        dataView : {show: true, readOnly: false},
                        magicType : {show: true, type: ['line', 'bar']},
                        restore : {show: true},
                        saveAsImage : {show: true}
                    }
                },
                calculable : true,
                xAxis : [
                    {
                        type : 'category',
                        data : json.data.yms
                    }
                ],
                yAxis : [
                    {
                        type : 'value'
                    }
                ],
                series : [
                    {
                        name:'BLB',
                        type:'bar',
                        data:json.data.xds,
                        markPoint : {
                            data : [
                                {type : 'max', name: '最大值'},
                                {type : 'min', name: '最小值'}
                            ]
                        },
                        markLine : {
                            data : [
                                {type : 'average', name: '平均值'}
                            ]
                        }
                    },
                    {
                        name:'THR',
                        type:'bar',
                        data:json.data.cjs,
                        markPoint : {
                            data : [
                                {type : 'max', name: '最大值'},
                                {type : 'min', name: '最小值'}
                            ]
                        },
                        markLine : {
                            data : [
                                {type : 'average', name : '平均值'}
                            ]
                        }
                    }
                ]
            };

            //初始化echarts实例
            var myChart = echarts.init(document.getElementById('userregchart'));
            //使用制定的配置项和数据显示图表
            myChart.setOption(option);
        }

        function userchart(json){
            m_option = json.data.yms;
            var app = {};
            var posList = [
                'left', 'right', 'top', 'bottom',
                'inside',
                'insideTop', 'insideLeft', 'insideRight', 'insideBottom',
                'insideTopLeft', 'insideTopRight', 'insideBottomLeft', 'insideBottomRight'
            ];

            app.configParameters = {
                rotate: {
                    min: -90,
                    max: 90
                },
                align: {
                    options: {
                        left: 'left',
                        center: 'center',
                        right: 'right'
                    }
                },
                verticalAlign: {
                    options: {
                        top: 'top',
                        middle: 'middle',
                        bottom: 'bottom'
                    }
                },
                position: {
                    options: echarts.util.reduce(posList, function (map, pos) {
                        map[pos] = pos;
                        return map;
                    }, {})
                },
                distance: {
                    min: 0,
                    max: 100
                }
            };
            app.config = {
                rotate: 90,
                align: 'left',
                verticalAlign: 'middle',
                position: 'insideBottom',
                distance: 15,
                onChange: function () {
                    var labelOption = {
                        normal: {
                            rotate: app.config.rotate,
                            align: app.config.align,
                            verticalAlign: app.config.verticalAlign,
                            position: app.config.position,
                            distance: app.config.distance
                        }
                    };
                    myChart.setOption({
                        series: [{
                            label: labelOption
                        }, {
                            label: labelOption
                        }, {
                            label: labelOption
                        }, {
                            label: labelOption
                        }]
                    });
                }
            };


            var labelOption = {
                normal: {
                    show: true,
                    position: app.config.position,
                    distance: app.config.distance,
                    align: app.config.align,
                    verticalAlign: app.config.verticalAlign,
                    rotate: app.config.rotate,
                    formatter: '{c}  {name|{a}}',
                    fontSize: 16,
                    rich: {
                        name: {
                            textBorderColor: '#fff'
                        }
                    }
                }
            };

            option = {
                color: ['#003366', '#006699', '#4cabce'],
                title : {
                    text: '年度平台用户登录数据统计',
                    subtext: 'BLB:百联保，THR:第三方，SUM:总数'
                },
                tooltip: {
                    trigger: 'axis',
                    axisPointer: {
                        type: 'shadow'
                    }
                },
                legend: {
                    data: ['THR', 'BLB', 'SUM']
                },
                toolbox: {
                    show: true,
                    orient: 'vertical',
                    left: 'right',
                    top: 'center',
                    feature: {
                        mark: {show: true},
                        dataView: {show: true, readOnly: false},
                        magicType: {show: true, type: ['line', 'bar', 'stack', 'tiled']},
                        restore: {show: true},
                        saveAsImage: {show: true}
                    }
                },
                calculable: true,
                xAxis: [
                    {
                        type: 'category',
                        axisTick: {show: false},
                        data: m_option
                    }
                ],
                yAxis: [
                    {
                        type: 'value'
                    }
                ],
                series: [
                    {
                        name: 'THR',
                        type: 'bar',
                        barGap: 0,
                        data: json.data.thrs
                    },
                    {
                        name: 'BLB',
                        type: 'bar',
                        data: json.data.blbs
                    },
                    {
                        name: 'SUM',
                        type: 'line',
                        data: json.data.alls
                    }
                ]
            };

            //初始化echarts实例
            var myChart = echarts.init(document.getElementById('chartmain'));
            //使用制定的配置项和数据显示图表
            myChart.setOption(option);
        }

    </script>
</bcxinFooter>
</body>
</html>
