<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>结算账单</title>
    <%@include file="/WEB-INF/include/head.jsp"%>
</head>

<body>
<div class="wrapper wrapper-content animated fadeInRight">

    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>保全结算账单</h5>
                    <%--<div class="ibox-tools">--%>
                    <%--<a class="collapse-link"><i class="fa fa-chevron-up"></i></a>--%>
                    <%--<a class="close-link"><i class="fa fa-times"></i></a>--%>
                    <%--</div>--%>
                </div>

                <div class="ibox-content">
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <form id="queryForm">
                                        <table>
                                            <tr>
                                                <td style="padding-left:0px;">
                                                    <div style="display:inline;padding-left:9px;">
                                                        关键字:
                                                        <input  class="easyui-textbox" name="keyword" id="keyword" data-options="prompt:'请填写结算单号'" placeholder="" style="width:275px;" />
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        结算时间: 从 <input class="easyui-datebox" data-options="editable:false" name="star_pay_time" id="star_pay_time" style="width:125px;">
                                                        至 <input class="easyui-datebox" data-options="editable:false" name="end_pay_time" id="end_pay_time" style="width:125px;">
                                                    </div>

                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="queryBtn" type="button" class="btn  btn-primary btn-sm" >
                                                            <i class="glyphicon glyphicon-search"></i> 搜索</button>
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="clearQueryForm" type="button" class="btn btn-primary btn-sm " >
                                                            <i class="glyphicon glyphicon-minus"></i> 清空</button>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                    <%--<div id="toolbar" class="btn-group m-t-sm">
                                        <button type="button" class="btn btn-warning" onclick="exportExcel()" style="width: 70px;height: 30px;">
                                            <i class="glyphicon glyphicon-upload"></i><span> 导出</span>
                                        </button>
                                    </div>--%>
                                    <table id="defaultTable"
                                           data-toggle="table"
                                    <%--data-show-refresh="true"--%>
                                           data-search="false"
                                           data-show-toggle="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="star_pay_time"
                                           data-url="${ctxapi}/myApply/applySettlementPayList_table/${sup_id}"
                                           data-method="post"
                                           data-content-type="application/x-www-form-urlencoded; charset=UTF-8"
                                           data-side-pagination="server"
                                           data-page-list="[10, 25, 50, 100, ALL]"
                                           data-query-params="myQueryParams"
                                           data-sort-order="desc"
                                           load-success.bs.table="onLoadSuccessFn"
                                           data-toolbar="#toolbar">
                                        <thead>
                                        <tr>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="external_reference">结算单号</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="company_name" >保险公司</th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="record_count">结算单数 </th>
                                            <th data-halign="center" data-align="center" data-sortable="false" data-field="fact_total_amount">结算费用 </th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-formatter="formatStatsFn">结算状态 </th>
                                            <th data-halign="center" data-align="center" data-sortable="true" data-field="build_data" >结算生成时间 </th>
                                            <th data-halign="center" data-align="center" data-formatter="formatOperationFn">操作</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script type="text/javascript">
        $(document).ready(function () {
            //查询按钮
            $("#queryBtn").unbind('click').click(function(){
                $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});
            });

            //清空查询列表
            $("#clearQueryForm").unbind('click').click(function(){
                $("#queryForm").form("clear");
                $('#defaultTable').bootstrapTable('refresh');
            });

        });
        //关闭窗口
        function closeLayerOpen() {
            layer.closeAll();
        }
        function refresh(){
            $('#defaultTable').bootstrapTable('refresh');
        }
        function formatStatsFn(value, row) {
            if (row.pay_status == 3) return "<span style='color:darkgray'>已结算<span>";
            return "-";
        }

        function formatOperationFn(value, row) {
            var str = "";
            var onClick2 = "member_child_settlement('"+row.oid+"');";
            str += '<a class="like m-l-sm text-info" href="javascript:void(0)" onclick="'+onClick2+'" title="结算账单详情" > <i class="glyphicon glyphicon-list-alt"></i></a>';
            return str;
        }


        /*结算账单详情*/
        function member_child_settlement(_id) {
            member_show('结算账单详情','${ctxapi}/myApply/childSettlementList/'+_id,'',1000,1000,null);

        }
        /*缴费详情*/
        function member_detail( id) {
            member_show('缴费详情','${ctxapi}/myApply/payDetailByID/'+id,'',1000,1000,null);

        }

        function exportExcel(){
            var start_time = $("#star_pay_time").val();
            var end_time = $("#end_pay_time").val();
            var keyword = $("#keyword").val();

            var index = layer.confirm('该操作将根据搜索条件导出数据，是否继续？',{btn: ['导出','取消']}, function(){
                location.href='${ctxapi}/myApply/downSettlementPay?keyword='+keyword+'&start_time='+start_time+'&end_time='+end_time;
                layer.close(layer.index);
            });
        }
        function createPartBill(){
            var checkboxes = document.querySelectorAll('input[name="billId"]:checked'),
                values = [];

            checkboxes.forEach((checkbox) => {
                values.push(checkbox.value);
            });
            if(values.length == 0){
                layer.msg('请勾选账单');
                return false;
            }
            var index = layer.confirm('是否根据已勾选记录生成部分账单汇总？',{btn: ['生成','取消']}, function(){
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctxapi}/myApply/createPartBill',
                    data:{'isSummaryBill':'1','payIds':values.join(',')},
                    success:function(result){
                        layer.close(index);
                        if(result.status=='200'){
                            layer.msg(result.msg,{icon:1,time:1000});
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        function uploadSubmit(){
            var str = "<div style='width: 300px;'>" +
                "<p style='padding-bottom: 5px;'><textarea class=\"form-control\" rows=6 id=\"pdNo\" placeholder=\"请输入账单编号（多个“,”隔开）\" style=\"width: 100%\"></textarea></p>" +
                "</div>";
            var index = layer.confirm(str,{btn: ['提交','取消'], title: "生成部分账单"}, function(){
                var pdNo = $('#pdNo').val();
                if(pdNo == undefined){
                    layer.msg("请输入账单编号！", {icon: 2, time: 2000});
                    return;
                }
                pdNo = pdNo.replace('，',',').replace(' ','');
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctxapi}/myApply/createPartBillByNo',
                    data:{'isSummaryBill':'1','payNos':pdNo},
                    success:function(result){
                        if(result.status=='200'){
                            layer.msg(result.msg,{icon:1,time:1000});
                            layer.close(index);
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        /*完成保全缴费记录*/
        function member_over_pay( id) {
            var index = layer.confirm('您将完成该月结保全缴费记录，缴费状态将变更为“已支付”结束缴费流程，是否确定本次操作？',{btn: ['确定','取消'] //按钮
            }, function(){
                g_ajax('${ctxapi}/myApply/overPay',{pay_id:id}, function(result){
                    layer.msg(result.msg, {time:1000});
                });
            });
        }

        function comm_back(json){
            if (json.success == true) {
                $('#defaultTable').bootstrapTable('refresh');
                layer.msg(json.msg, {icon: 1, time: 1000});
            } else {
                layer.alert(json.msg, {icon: 2});
            }
        }

        function myQueryParams(params) { //limit offset order sort
            console.log("参数是："+params)
            var obj = g_sobj($("#queryForm").form());
            for(var i in obj){
                if(obj[i]=="") eval("delete obj."+i);
            }
            return $.extend(obj, params);
        }


    </script>
</bcxinFooter>
</body>
</html>
