<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>账单详情</title>
    <%@include file="/WEB-INF/include/head.jsp" %>
    <style>
        .bid-context table {
            width: 100%;

        }
        .buttonDiv
        {
            font-size:12px;
            text-align:center;
            padding:30px;
            vertical-align:middle ;
            line-height:22px;
            margin: 0 auto;

        }
        .bid-context table thead tr {
            background: #eee;
        }

        .bid-context table tr {
            line-height: 40px;
        }

        .bid-context table tr td {
            text-align: center;
            border: 1px solid #ddd;
        }
        .div1 {
            position: relative;
            left: 90px;
        }
        .div2 {
            width: 100px;
            height: 36px;
            background: #2178fc;
            color: #fff;
            text-align: center;
            line-height: 36px;
        }

        .upload_file {
            width: 200px;/*因为file-input在部分浏览器中会自带一个输入框，需要双击才可以点击上传,放大后将其定位到div外面就好啦*/
            height: 36px;
            position: absolute;
            left: 0px;
            top: 0;
            z-index:1;
            -moz-opacity: 0;
            -ms-opacity: 0;
            -webkit-opacity: 0;
            opacity: 0;  /*css属性——opcity不透明度，取值0-1*/
            filter: alpha(opacity=0); /*兼容IE8及以下--filter属性是IE特有的，它还有很多其它滤镜效果，而filter: alpha(opacity=0); 兼容IE8及以下的IE浏览器(如果你的电脑IE是8以下的版本，使用某些效果是可能会有一个允许ActiveX的提示,注意点一下就ok啦)*/
            cursor: pointer;
        }
    </style>
</head>

<body>
<!-- 基础信息 start -->
<div class="container bid">
    <div class="content">
        <h3>保全信息</h3>
        <div class="row bid-context" style="border: solid  0.5px">
            <div class="col-sm-12"  >
                <ul class="bid-ul">
                    <li class="no-bor">保单号</li>
                    <li class="no-bor" title="${insPreservationPayVo.external_reference}">${insPreservationPayVo.external_reference}</li>
                    <li class="no-bor">投保人</li>
                    <li class="no-bor"> ${insPreservationPayVo.app_role_name}</li>
                    <li class="no-bor">保险公司</li>
                    <li class="no-bor">${insPreservationPayVo.company_name}</li>
                    <li class="no-bor">保险期限</li>
                    <li class="no-bor" > ${insPreservationPayVo.inception_date}至${insPreservationPayVo.planned_end_date}</li>

                </ul>

            </div>
        </div>
    </div>
</div>

<div class="hr-line-dashed"></div>
<!-- 基础信息 end -->
<!-- 人员信息 start -->
<div class="container bid">
    <div class="content">
        <h3>批单信息</h3>
        <div class="col-sm-12">
            <table id="defaultTable"
                   data-toggle="table"
                   data-show-refresh="false"
                   data-search="false"
                   <%--data-show-toggle="true"--%>
                  <%-- data-show-export="true"--%>
                   <%--data-show-columns="true"--%>
                   data-striped="true"
                   data-pagination="true"
                   data-sort-name="ins_preservation_pay_id"
                   data-url="${ctxapi}/myApply/perserverPayDetail/${insPreservationPayVo.oid}"
                   data-method="post"
                   data-content-type="application/x-www-form-urlencoded; charset=UTF-8"
                   data-side-pagination="server"
                   data-page-list="[10, 25, 50, 100, ALL]"
                   data-query-params="myQueryParams"
                   data-sort-order="desc"
                   load-success.bs.table="onLoadSuccessFn"
                   data-toolbar="#toolbar">
                <thead>
                <tr>

                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="revise_serial_num_ins">批单号
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="revise_type"  data-formatter="formaTypeFn">批改类型
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="inception_date" >生效时间
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="revise_status" data-formatter="formatStatusFn">批改状态
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="add_count">增员
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="minus_count">减员
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="replace_count" >替换
                    </th>
                    <th data-halign="center" data-align="center" data-sortable="true"
                        data-field="total_premium">保全金额
                    </th>
                    </th>

                </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
<bcxinFooter>

    <script type="text/javascript">
        $(document).ready(function () {
            //查询按钮
            $("#queryBtn").unbind('click').click(function () {
                $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});
            });

            //清空查询列表
            $("#clearQueryForm").unbind('click').click(function () {
                $("#queryForm").form("clear");
            });
            updataButton();

        });
        function updataButton() {
            var status=${insPreservationPayVo.pay_status};
            if (status==0){
                $('#checkSubmit').show();
                $('#checkPay').hide();
            }else if (status==2){
                $('#checkSubmit').hide();
                $('#checkPay').show();
            }else{
                $('#checkSubmit').hide();
                $('#checkPay').hide();
            }
        }
        function refresh() {
            $('#defaultTable').bootstrapTable('refresh');
        }

        function loadCanvas(_imgPath){
            if(_imgPath==""||_imgPath==null){
                layer.msg("没有找到图片地址，请核实或者上传");
            }else{
            layer.open({
                type: 1,
                title: " ",
                closeBtn: 1,
                area: '516px',
                skin: 'layui-layer-nobg', //没有背景色
                shadeClose: true,
                content: "<img src='${ctx_defaul}"+_imgPath+"' width='100%'/>"
            });
            }

        }
        function uploadFilePay(_form){
            var formData = new FormData(document.forms.namedItem(_form));
            $.ajax({
                type: 'POST',
                url:'${ctxapi}/myApply/uploadFile/${insPreservationPayVo.oid}/2',
                dataType:"json",
                data: formData,
                processData: false,
                contentType: false,
                success: function(result) {
                    if(result.success) {
                        $("#showPicture").attr('onClick','loadCanvas(\''+result.msg+'\')');
                        $("#upload").val(result.msg);
                        $("#preserverAddress").val(result.msg);

                        layer.msg("上传图片成功", {time:1000 });
                        $("#showPicture").show;

                    }else {
                        layer.msg(result.msg);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg(textStatus);
                }
            });
        }
        function uploadJFFilePay(_form){
            var formData = new FormData(document.forms.namedItem(_form));
            $.ajax({
                type: 'POST',
                url:'${ctxapi}/myApply/uploadFile/${insPreservationPayVo.oid}/3',
                dataType:"json",
                data: formData,
                processData: false,
                contentType: false,
                success: function(result) {
                    if(result.success) {
                        $("#showJFPicture").attr('onClick','loadCanvas(\''+result.msg+'\')');
                        $("#uploadJF").val(result.msg);
                        $("#preserverJFAddress").val(result.msg);

                        layer.msg("上传图片成功", {time:1000 });
                        $("#showJFPicture").show();

                    }else {
                        layer.msg(result.msg);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg(textStatus);
                }
            });
        }
        function formatStatusFn(value, row) {
            if (row.revise_status == 1) return "<span style='color:darkgray'>待提交<span>";
            if (row.revise_status == 2) return "<span style='color:blue'>待审核<span>";
            if (row.revise_status == 3) return "<span style='color:red'>审核退回<span>";
            if (row.revise_status == 4) return  "<span style='color:green'>已审核<span>";
            if (row.revise_status == 5) return  "<span style='color:yellowgreen'>已生效<span>";
            return "";
        }
        function formaTypeFn(value, row) {

            if (row.revise_type == 1) return "增员";
            if (row.revise_type == 2) return "减员";
            if (row.revise_type == 3) return "替换";

            return "";
        }




        function checkReturn(){
            parent.closeLayerOpen();
        }
        function checkSubmit(){
            var fact_total_amount=$("#preserverCost").val();
            var pay_inform_path=$("#upload").val();
            g_ajax('${ctxapi}/myApply/updataPayStatus',{pay_id:'${insPreservationPayVo.oid}',fact_total_amount:fact_total_amount ,pay_inform_path: pay_inform_path ,pay_order_path: pay_order_path,pay_status:'1'}, function(result){
                layer.msg(result.msg, {time:1000});
                if(result.success){
                    setTimeout("reloadParent()",1200);

                        }else{
                    layer.msg(result.msg);
                        }
                    });
        }
        function reloadParent() {
            parent.refresh();
            parent.closeLayerOpen();
        }
        function checkPay(){
            g_ajax('${ctxapi}/myApply/updataPayStatus',{pay_id:'${insPreservationPayVo.oid}',fact_total_amount:"" ,pay_inform_path: "",pay_status:'3'}, function(result){

                if(result.success){
                    parent.refresh();
                    parent.closeLayerOpen();
                }else{
                    layer.msg(result.msg);
                }
            });
        }
        function comm_back(json) {
            if (json.success == true) {
                $('#defaultTable').bootstrapTable('refresh');
                layer.msg(json.msg, {icon: 1, time: 1000});
            } else {
                layer.alert(json.msg, {icon: 2});
            }
        }
        function myQueryParams(params) { //limit offset order sort
            console.log("参数是：" + params)
            var obj = g_sobj($("#queryForm").form());
            for (var i in obj) {
                if (obj[i] == "") eval("delete obj." + i);
            }
            return $.extend(obj, params);
        }


    </script>
</bcxinFooter>
</body>
</html>
