package com.bcxin.ins.models.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.MyTposThrUserService;
import com.bcxin.ins.core.util.CTLUtil;
import com.google.common.collect.Maps;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
* 类名称：WhiteUserController
* 类描述：白名单用户控制器
* 创建人:xiangyaoqi
* @version
 */
@Controller
@RequestMapping("${systemPath}/mywhiteuser")
public class WhiteUserController extends BaseController {

	/** 角色管理页面 */
	private static final String WHITE_USER_LIST = getViewPath("admin/system/white_user_list");
	private static final String WHITE_USER_ADD = getViewPath("admin/system/white_user_add");

	@Autowired
	private MyTposThrUserService myTposThrUserService;

	/**白名单列表 页面*/
	@RequiresPermissions("mywhiteuser:win:list")
	@RequestMapping(value = "/win/list")
	public String winList(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest request) {
		return WHITE_USER_LIST;
	}

	/**
	 * @Description: 添加白名单
	 * @param model
	 * @return
	 * @throws
	 */
	@RequestMapping(value = "/list/add", method = RequestMethod.GET)
	 public String add(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		model.addAttribute("mark","add");
		model.addAttribute("p",params);
		return WHITE_USER_ADD;
	}

	/**
	 * @Description: 修改白名单
	 * @param model
	 * @param oid
	 * @return
	 * @throws
	 */
	@RequestMapping(value = "/list/edit/{oid}")
	public String edit(Model model,@RequestParam Map<Object,Object> params , @PathVariable Long oid){
		Map<String,Object> m = Maps.newHashMap();
		m.put("tpos_thr_user_id",oid);
		model.addAttribute("mark","upd");
		model.addAttribute("p",params);
		model.addAttribute("row",myTposThrUserService.selectByMap(m).get(0));
		return WHITE_USER_ADD;
	}

	/**列表分页*/
	@RequiresPermissions("mywhiteuser:win:list")
	@RequestMapping(value = "/query" , method = RequestMethod.POST)
	public @ResponseBody
	Object query(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(myTposThrUserService.query(params),resp); return null;
	}

	/**新增*/
	@RequiresPermissions("mywhiteuser:wu:add")
	@RequestMapping(value = "/wu/add" , method = RequestMethod.POST)
	public @ResponseBody Object wuAdd(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return myTposThrUserService.whiteUserAdd(p);
	}
	/**修改*/
	@RequiresPermissions("mywhiteuser:wu:upd")
	@RequestMapping(value = "/wu/upd" , method = RequestMethod.POST)
	public @ResponseBody Object wuUpd(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return myTposThrUserService.whiteUserUpd(p);
	}

	/**删除*/
	@RequiresPermissions("mywhiteuser:wu:del")
	@RequestMapping(value = "/wu/del" , method = RequestMethod.POST)
	public @ResponseBody Object wuDel(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return myTposThrUserService.whiteUserDel(p);
	}

}