package com.bcxin.ins.models.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.*;
import com.bcxin.ins.vo.ConstProp;
import com.google.common.collect.Maps;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.Map;
import java.util.UUID;

/**
 * Created by Apple on 2017/6/12.
 */
@Controller
@RequestMapping("${apiPath}/ueditor")
@Lazy(false)
public class UeditorAPIController extends BaseController {

    @Autowired
    private MyUtilService utilS;
    @RequestMapping
    public String index(){
        System.out.println(1);
        return "/ueditor/index";
    }

//    @RequestMapping(value = "/upload", method = RequestMethod.GET)
//    @ResponseBody
//    public String upload(HttpServletRequest request, HttpServletResponse response) throws IOException {
//        String action = request.getParameter("action");
//       return null;
//    }

    @RequestMapping(value = "/upload")
    @ResponseBody
    public Map<String, String> upload(HttpServletRequest request, CommonsMultipartFile upfile) {
        Map<String, String> result = Maps.newHashMap();
        System.out.println(upfile.getOriginalFilename());
        String path = getFilePath(upfile);
        File file = new File(path);
        System.out.println(path);
        String state = "SUCCESS";
        //返回类型
        String rootPath = request.getContextPath();
        result.put("url", rootPath + "/api/ueditor/show?filePath=" + path);
        result.put("size", String.valueOf(file.length()));
        result.put("type", file.getName().substring(file.getName().lastIndexOf('.')));
        result.put("state", state);
        return result;
    }

    @RequestMapping(value = "/show", method = RequestMethod.GET)
    public void show(String filePath, HttpServletResponse response) throws IOException {

        File file = getFile(filePath);

        response.setDateHeader("Expires", System.currentTimeMillis() + 1000 * 60 * 60 * 24);
        response.setHeader("Cache-Control", "max-age=60");
        OutputStream os = response.getOutputStream();

        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            IOUtils.copy(is, os);
        } catch (FileNotFoundException e) {
            response.setStatus(404);
            return;
        } finally {
            if (null != is) {
                is.close();
            }
            if (null != os) {
                os.flush();
                os.close();
            }
        }
    }

    protected String getFilePath(CommonsMultipartFile uploadFile){
        String absolutePath = "D:/upload";
        File folder = new File(absolutePath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        String rawName = uploadFile.getOriginalFilename();
        String fileExt = rawName.substring(rawName.lastIndexOf('.'));
        String newName = System.currentTimeMillis() + UUID.randomUUID().toString() + fileExt;
        File saveFile = new File(absolutePath + File.separator + newName);
        try(FileOutputStream out = new FileOutputStream(saveFile);) {
            out.write(uploadFile.getBytes());
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return absolutePath + ConstProp.SLASH + newName;
    }

    protected File getFile(String path){
        File file = new File(path);
        return file;

    }

}
