package com.bcxin.ins.models.web;

import com.bcxin.ins.common.constants.GlobalConstants;
import com.bcxin.ins.common.http.MessageUtils;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.security.FormAuthenticationFilter;
import com.bcxin.ins.core.service.SysRoleService;
import com.bcxin.ins.core.service.SysUserService;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.spring.cache.BaseUtils;
import com.bcxin.ins.spring.cache.CacheUtils;
import com.bcxin.ins.spring.security.Principal;
import com.bcxin.ins.util.CookieUtils;
import com.bcxin.ins.util.RSAUtils;
import com.bcxin.ins.vo.ConstProp;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 
*    
* 类名称：LoginController   
* 类描述：后台管理员登录表示层   
* 创建人：liujinju
* @version    
*
 */
@Controller
public class SysLoginController extends BaseController {


	/**
	 * 后台管理登录页面
	 */
	private static final String ADMIN_LOGIN = getViewPath("admin/login/admin_login");
	/**
	 * 后台管理首页
	 */
	private static final String ADMIN_MAIN = getViewPath("admin/main/main");

	/** 发现错误*/
	private static final String ERROR = getViewPath("common/error");
	@Autowired
	private SysUserService sysUserService;

	@Autowired
	private SysRoleService sysRoleService;


	@RequestMapping(value = "${systemPath}/error/{code}", method = RequestMethod.GET)
	public String error(@PathVariable String code,HttpServletRequest request, HttpServletResponse response, Model model) {
		String msg = "未知错误，请联系管理员";
		if("10011".equals(code)){
			msg = "警告！！请求内容中含有非法字符。";
		}
		model.addAttribute("prompt", msg);
		return ERROR;
	}

	/**
	 * GET 登录
	 *
	 * @param request
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "${systemPath}/login", method = RequestMethod.GET)
	public String login(HttpServletRequest request, HttpServletResponse response, Model model) {
		return login(response, model);
	}

	public String login(HttpServletResponse response, Model model) {
		// 将公钥的 modulus 和 exponent 传给页面
//		Map<String, Object> publicKeyMap = RSAUtils.getPublicKeyMap();
		Principal principal = SysUserUtils.getPrincipal();
		if (principal != null) {
			return redirectTo("/admin/index");
		}
		// 如果已登录，再次访问主页，则退出原账号。
		if (GlobalConstants.TRUE.equals(GlobalConstants.getConfig("notAllowRefreshIndex"))) {
			CookieUtils.setCookie(response, "LOGINED", "false");
		}
//		model.addAttribute("publicKeyMap", publicKeyMap);
		return ADMIN_LOGIN;
	}

	@RequestMapping("/bcxin/ajaxlogin")
//	@ResponseBody
	public void Apilogin(String data, HttpServletRequest request,HttpServletResponse response) {
		sysUserService.ajaxLoginValidate(data,this.getParameter("sessionId"),response);
	}
	/**
	 * 清除缓存
	 * @param
	 * @return
	 */
	@RequestMapping(value = "${systemPath}/removeCache", method = RequestMethod.GET)
	public String removeCache() {
		CacheUtils.removeAll("sysCache");
		BaseUtils.removeCache("menuList");
		return redirectTo("/admin/index");
	}
	/**
	 * 退出
	 * @param
	 * @return
	 */
	@RequestMapping(value = "${systemPath}/logout", method = RequestMethod.GET)
	public String logout() {
		Subject subject = SecurityUtils.getSubject();
		subject.logout();
		SysUserUtils.getUser();
		return redirectTo(ADMIN_LOGIN);
	}
	/**
	 * ajax退出
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/bcxin/logout")
	public void apilogout() {
		Subject subject = SecurityUtils.getSubject();
		if(subject==null){
			subject.logout();
		}
		Map<String,Object> map = Maps.newHashMap();
		map.put("status", ConstProp.CODE_SUCCESS);
		map.put("message", "操作成功");
		MessageUtils.returnMessage(MessageUtils.packageMap(map),this.response);
	}

	/**
	 * 登录失败，真正登录的POST请求由Filter完成
	 */
	@RequestMapping(value = "${systemPath}/login", method = RequestMethod.POST)
	public String loginFail(HttpServletRequest request, HttpServletResponse response, Model model) {
		if (sysUserService.loginValidatePost(request, model)) {
			return redirectTo("${systemPath}/index");
		}
		return ADMIN_LOGIN;
	}


}
