package com.bcxin.ins.models.web;


import com.alibaba.fastjson.JSON;
import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysDict;
import com.bcxin.ins.core.service.SysDictService;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.core.util.DOM;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 字典Controller
 * @author ThinkGem
 * @version 2014-05-16
 */
@Controller
@RequestMapping(value = "${systemPath}/dict")
public class SysDictController extends BaseController {

	@Autowired
	private SysDictService sysDictService;
	
	private static final String SYSTEM_DICT_LIST = getViewPath("/admin/system/system_dict_list");
	private static final String SYSTEM_DICT_ADD = getViewPath("/admin/system/system_dist_add");


	/**
	 * 创建或修改菜单
	 * @return
	 */
	@RequestMapping(value = "/list/save", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult update( @RequestParam Map<Object,Object> params){
		SysDict sysDict  = (SysDict) DOM.mtd(params,new SysDict());
		if("add".equals(params.get("mark"))){
			Map<String,Object> columnMap = new HashMap<String,Object>();
			columnMap.put("type",  params.get("type"));
			columnMap.put("value", params.get("value"));
			List<SysDict> list =sysDictService.selectByMap(columnMap);
			if(list.size()>0){
				return fail(false, "该字典值已经被使用");
			}

			try {
				sysDict.setCom_dict_id(null);
				sysDictService.insert(sysDict);//插入菜单
			} catch (Exception e) {
				e.printStackTrace();
			}
			return success(true, "字典创建成功!");
		}else{
			//sysDict.preUpdate();
			sysDictService.updateById(sysDict);//更新字典
			return success(true, "字典修改成功!");
		}
	}

	/**
	 * <b>查询字典 </b> 
	 * 
	 * @param dict
	 * @param dict
	 * @param model
	 * @param model
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月3日 上午10:04:06
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/list")
	public String list(SysDict dict, Model model) {
//		try{
//			//查询所有字典
//			List<SysDict> dictList = sysDictService.selectList(new EntityWrapper<SysDict>(dict).orderBy("type,sort"));
//			model.addAttribute("dictList", dictList);
//		}catch (Exception e) {
//			logger.error("showDictList()--error",e);
//		}
		return SYSTEM_DICT_LIST;
	}

	@RequestMapping(value = "/list/query")
	public @ResponseBody Object query(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(sysDictService.query(p),resp); return null;
	}

	/**
	* @Description: 添加菜单 
	* @param model
	* @return
	* @throws 
	*/

	@RequestMapping(value = "/list/add", method = RequestMethod.GET)
	public String add(Model model) {
		return SYSTEM_DICT_ADD;
	}
	
	/**
	* @Description: 编辑字典
	* @param model
	* @param dictId
	* @return
	* @throws 
	*/

	@RequestMapping(value = "/list/edit/{dictId}")
	public String edit(Model model, @PathVariable Long dictId){
		SysDict dict = sysDictService.selectById(dictId);
		model.addAttribute("dict", dict);//字典信息
		return SYSTEM_DICT_ADD;
	}
	
	
	/**
	 * 字典同步
	 * @return
	 */
	@RequestMapping(value = "/sync", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult sync(){
		SysDictUtils.syncDict();
		return success(true, "字典同步成功!");
	}
	/**
	 * 获取已经存在的字典并去除 
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/list/getvalue")
	public String getValue(Model model,Long dictId){
		SysDict dict = sysDictService.selectById(dictId);
		dict.setCom_dict_id(null);
		dict.setLabel(null);
		dict.setValue(null);
		model.addAttribute("dict", dict);//字典信息
		return SYSTEM_DICT_ADD;
	}
	

	/**
	 * 删除菜单功能
	 */

	@RequestMapping("/list/{id}/delete")
	@ResponseBody
	public Map<String,Object> deleteFunction(@PathVariable("id") Long id){
		Map<String,Object> json = new HashMap<String,Object>();
		try{
			sysDictService.deleteById(id);
			json = this.setJson(true, null, null);
		}catch (Exception e) {
			logger.error("deleteFunction()--error",e);
		}
		return json;
	}


	@ResponseBody
	@RequestMapping("/getListByType/{type}")
	public List<SysDict> getSysDictListByType(@PathVariable("type") String type){
		if(StringUtils.isNotBlank(type)){
			return SysDictUtils.getDictList(type);
		}
		return null;
	}

	/**
	 * 获取单个标签
	 * @param value
	 * @param type
	 * @param def
	 * @return
	 */
	@RequestMapping("/getDictLabel")
	public String getDictLabel(String value,String type,String def){
		if(StrUtil.isBlank(value)||StrUtil.isBlank(type)) return "";
		return renderString(response, SysDictUtils.getDictLabel(value,type, StrUtil.isBlank(def)?"":def));
	}
}
