package com.bcxin.ins.models.web;

import com.bcxin.ins.common.constants.GlobalConstants;
import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.*;
import com.bcxin.ins.core.service.*;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.spring.util.UploadFileUtils;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 
 * <b>机构管理 </b>
 * 
 * @author Administrator
 * @date 2016年12月30日 下午2:23:35
 * @注意事项 </b>
 * <b>
 */
@Controller
@Transactional
@RequestMapping("${systemPath}/syscompany")
public class SysCompanyController extends BaseController {

	@Autowired
	private SysCompanyService sysCompanyService;//机构服务
	@Autowired
	private SysCompanyContactsService sysCompanyContactsService;//联系人服务
	@Autowired
	private SysCompanyTerminalContactsService sysCompanyTerminalContactsService;//终端用户联系人服务
	@Autowired
	private SysCompanyChannelContactsService sysCompanyChannelContactsService;//终端用户联系人服务
	@Autowired
	private SysRoleService sysRoleService;

	@Autowired
	private SysUserService sysUserService;

	@Autowired
	private SysUserRoleService sysUserRoleService;


	/**
	 * 机构列表 （1：供应商，2：分销商，3：企业）
	 * @param
	 * @return
	 */
	@RequiresPermissions(value={"syscompany:list:view:supplier",
								"syscompany:list:view:terminal",
							    "syscompany:list:view:distributor",
								"syscompany:list:view:resource"
				},logical=Logical.OR)
	@RequestMapping(value = "/list")
	public String list(Model model) {
		String type = getParameter("type");
		if(StrUtil.isNotBlank(type)){
			List<SysCompany> companyList = Lists.newArrayList();
			if(type.equals(SysCompany.TERMINAL_TYPE_BUSINESS)) {
					companyList = sysCompanyService.getCompanyList(new SysCompany(Integer.parseInt(type)));
			}
			model.addAttribute("companyList", companyList);
			return getUrl(Integer.parseInt(type),"list");
		}
		getRequest().setAttribute("ex", "参数错误！！！");
		return "common/500";
	}

	/**
	 * 获取分销商管理首页分销商列表 liumd
	 * @param
	 * @return
	 */
	@RequiresPermissions("syscompany:list:view:distributor")
	@RequestMapping(value = "/distributorList")
	public String distributorList(Model model) {
		String type = getParameter("type");
//		String searchContent = getParameter("searchContent");
		if(StrUtil.isNotBlank(type)){
			List<SysCompany> companyList = sysCompanyService.findDistributorList(type,null);
			model.addAttribute("companyList", companyList);
			return getUrl(Integer.parseInt(type),"list");
		}
		getRequest().setAttribute("ex", "参数错误！！！");
		return "common/500";
	}

	/**
	 * 根据所选层级获取上级分销商列表 liumd
	 * 比如 选择二级分销商时，获取所有一级分销商
	 * 		选择三级分销商时，获取所有二级分销商
	 * @param
	 * @return
	 */
	@ResponseBody
	@RequiresPermissions("syscompany:list:view:distributor")
	@RequestMapping(value = "/getDistributorListByLevel")
	public List<SysCompany> getDistributorListByLevel(Model model) {
		String level = getParameter("level");
		if(StrUtil.isNotBlank(level)){
			List<SysCompany> lis = sysCompanyService.getDistributorListByLevel(level);
			if(lis != null){
				return lis;
			}
			return null;
		}
		return null;
	}

	/**
	 * 根据所选层级获取上级分销商列表
	 * 新增限制排除当前用户自己 防止自己选自己 如用户当前为二级，更改为三级，目录中不应该出现自己  --liumd
	 * 比如 选择二级分销商时，获取所有一级分销商
	 * 		选择三级分销商时，获取所有二级分销商
	 * @param
	 * @return
	 */
	@ResponseBody
	@RequiresPermissions("syscompany:list:view:distributor")
	@RequestMapping(value = "/getDistributorListByLevelExcludeSelf")
	public List<SysCompany> getDistributorListByLevelExcludeSelf(Model model) {
		String level = getParameter("level");
		String userId = getParameter("userId");
		if(StrUtil.isNotBlank(level) && StringUtils.isNotBlank(userId)){
			List<SysCompany> lis = sysCompanyService.getDistributorListByLevelExcludeSelf(level,userId);
			if(lis != null){
				return lis;
			}
			return null;
		}
		return null;
	}

	/**
	 * 查看所选分销商详情 liumd
	 * @param
	 * @return
	 */
	@RequiresPermissions("syscompany:list:view:distributor")
	@RequestMapping(value = "/viewDistributorByChoise")
	public String viewDistributorByChoise(Model model) {
		String choiseId = getParameter("choiseId");
		String modify = getParameter("modify");
		if(StrUtil.isBlank(choiseId)){
			getRequest().setAttribute("ex", "参数错误！！！");
			return "common/500";
		}
		SysCompany company = null;
		List<SysCompany> companyList = sysCompanyService.getDistributorByChoise(choiseId);
		if(companyList == null){
			getRequest().setAttribute("ex", "参数错误！！！");
			return "common/500";
		}
		company = companyList.get(0);
		List<SysCompany> childList = sysCompanyService.findDistributorList("2",choiseId);
		if(childList != null){
			company.setChildSysCompanyList(childList);
		}
		model.addAttribute("company", company);
		if(StringUtils.isNotBlank(modify) && "modify".equals(modify)){
			model.addAttribute("modify", modify);
		}
		return SYSTEM_COMPANY_DISTRIBUTOR_VIEW;
	}


	/**
	 * 查看所选终端用户详情 liumd
	 * 企业用户和个人用户字段不同，根据数据库取到的类型，分配不同的跳转页面。
	 * * @param
	 * @return
	 */
	@RequiresPermissions("syscompany:list:view:terminal")
	@RequestMapping(value = "/viewTerminalByChoise")
	public String viewTerminalByChoise(Model model) {
		String choiseId = getParameter("choiseId");
		String modify = getParameter("modify");
		if(StrUtil.isBlank(choiseId)){
			getRequest().setAttribute("ex", "参数错误！！！");
			return "common/500";
		}
		SysCompany company = null;
		List<SysCompany> companyList = sysCompanyService.getTerminalByChoise(choiseId);
		if(companyList == null){
			getRequest().setAttribute("ex", "参数错误！！！");
			return "common/500";
		}
		company = companyList.get(0);
		model.addAttribute("company", company);
		if(StringUtils.isNotBlank(modify) && "modify".equals(modify)){
			//添加判断，如果该用户已经从终端用户提升为分销商，将不再提供修改和提升为分销商这两个按钮。
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("relate_to_terminal",choiseId);
			List<SysCompany> lis = sysCompanyService.selectByMap(map);
			if(lis.size() <= 0){
				model.addAttribute("modify", modify);
			}
		}
		String terminalType = String.valueOf(company.getTerminalType());
		if(StringUtils.isBlank(terminalType)){
			getRequest().setAttribute("ex", "参数错误！！！");
			return "common/500";
		}
		if(terminalType.equals(SysCompany.TERMINAL_TYPE_BUSINESS)){
			return SYSTEM_COMPANY_TERMINAL_BUSINESS_VIEW;
		}else if(terminalType.equals(SysCompany.TERMINAL_TYPE_PERSONAL)){
			return SYSTEM_COMPANY_TERMINAL_PERSONAL_VIEW;
		}
		getRequest().setAttribute("ex", "参数错误！！！");
		return "common/500";
	}


    /**
     * 查看所选资源方详情 liumd
     * * @param
     * @return
     */
	@RequiresPermissions("syscompany:list:view:resource")
    @RequestMapping(value = "/viewChannelByChoise")
    public String viewChannelByChoise(Model model) {
        String choiseId = getParameter("choiseId");
        String modify = getParameter("modify");
        if(StrUtil.isBlank(choiseId)){
			getRequest().setAttribute("ex", "参数错误！！！");
			return "common/500";
		}
		SysCompany company = null;
		List<SysCompany> companyList = sysCompanyService.getChannelByChoise(choiseId);
		if(companyList == null){
			getRequest().setAttribute("ex", "参数错误！！！");
			return "common/500";
		}
		company = companyList.get(0);
		model.addAttribute("company", company);
		if(StringUtils.isNotBlank(modify) && "modify".equals(modify)){
			model.addAttribute("modify", modify);
		}
		return SYSTEM_COMPANY_CHANNEL_VIEW;
    }


	/**
	 * 获取终端用户管理首页列表 liumd
	 * @param
	 * @return
	 */
	@RequiresPermissions("syscompany:list:view:terminal")
	@RequestMapping(value = "/terminalList")
	public String terminalList(Model model) {
		String type = getParameter("type");
		if(StrUtil.isNotBlank(type)){
			List<SysCompany> companyList = sysCompanyService.findDistributorList(type,null);
			model.addAttribute("companyList", companyList);
			return getUrl(Integer.parseInt(type),"list");
		}
		getRequest().setAttribute("ex", "参数错误！！！");
		return "common/500";
	}




	/**
	 * POST 启用/禁止机构
	 * @param
	 * @return
	 */
	@RequiresPermissions(value = {"syscompany:list:audit:supplier",
								  "syscompany:list:audit:terminal",
			                      "syscompany:list:audit:distributor",
								  "syscompany:list:audit:resource"
							},logical=Logical.OR)
	@RequestMapping(value = "/list/audit", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult audit() {
		SysUserUtils.removeCache(SysCompanyService.CACHE_OFFICE_LIST);
		Long accountId = Long.parseLong(getParameter("accountId"));
		//添加判断，如果该用户已经从终端用户提升为分销商，将不再提供激活服务。
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("relate_to_terminal",accountId);
		List<SysCompany> lis = sysCompanyService.selectByMap(map);
		if(lis.size() > 0){
			return fail(false,"该终端用户已升级为分销商，不再提供激活服务");
		}else{
			Integer status = Integer.valueOf(getParameter("status"));
			//需要把所属的连同下级账号禁用掉
			//需要把所属的子账号禁用掉
			sysCompanyService.updateById(new SysCompany(accountId,status));
			return success(true);
		}
	}
	
	/**
	 * DELETE 删除机构
	 * @return
	 */
	@RequiresPermissions(value={"syscompany:list:delete:supplier",
								"syscompany:list:delete:terminal",
								"syscompany:list:delete:distributor",
								"syscompany:list:delete:resource"
								},logical=Logical.OR)
	@RequestMapping(value = "/list/{accountId}/delete", method = RequestMethod.DELETE)
	@ResponseBody
	public AjaxResult delete(@PathVariable Long accountId) {
		SysUserUtils.removeCache(SysCompanyService.CACHE_OFFICE_LIST);
		sysCompanyService.deleteById(accountId);
		return success(true);
	}

	/**
	 * 修改机构页面
	 * @return
	 */
	@RequiresPermissions(value = {"syscompany:list:edit:supplier",
								  "syscompany:list:edit:terminal",
								  "syscompany:list:edit:resource",
								  "syscompany:list:edit:distributor",
								},logical=Logical.OR)
	@RequestMapping(value = "/list/{companyId}/edit/{type}")
	public String edit(Model model, @PathVariable Long companyId,@PathVariable Integer type){
		model.addAttribute("isAdd",true);
		SysCompany sysCompany = sysCompanyService.get(companyId);
		model.addAttribute("company", sysCompany);
		Map<String,Object> map = Maps.newHashMap();
		map.put("companyId", sysCompany.getId());
		//查询关联产品
		List<Map<String,Object>> insProlist = sysCompanyService.getInsProductMap(map);
		model.addAttribute("insProlist",insProlist);
		map.clear();
		map.put("company_id", sysCompany.getId());
		//查询关联联系人
		List<SysCompanyContacts> contactsList = sysCompanyContactsService.selectByMap(map);
		model.addAttribute("contactsList",contactsList);
		return getUrl(type, "add");
	}
	
	/**
	 * GET创建机构页面
	 * @return
	 */
	@RequiresPermissions(value = {"syscompany:list:add:supplier",
			                      "syscompany:list:add:terminal",
			                      "syscompany:list:add:resource",
								  "syscompany:list:add:distributor"},logical=Logical.OR)
	@RequestMapping(value = "/list/add")
	public String add(Model model) {
		model.addAttribute("isAdd",true);
		String type = getParameter("type");
		String terminalType = getParameter("terminalType");
		if(StringUtils.isNotBlank(terminalType)){
			if(terminalType.equals(SysCompany.TERMINAL_TYPE_BUSINESS) && type.equals(String.valueOf(SysCompany.COMPANY_TYPE_TERMINAL))){
				return SYSTEM_COMPANY_TERMINAL_BUSINESS_ADD;
			}else if(terminalType.equals(SysCompany.TERMINAL_TYPE_PERSONAL) && type.equals(String.valueOf(SysCompany.COMPANY_TYPE_TERMINAL))){
				return SYSTEM_COMPANY_TERMINAL_PERSONAL_ADD;
			}
		}
		return getUrl(Integer.parseInt(type), "add");
	}
	/**
	 * 查看机构页面
	 * @return
	 */
	@RequiresPermissions(value={"syscompany:list:view:supplier",
								"syscompany:list:view:terminal",
								"syscompany:list:view:distributor",
								"syscompany:list:view:resource"
								},logical=Logical.OR)
	@RequestMapping(value = "/list/{companyId}/view/{type}")
	public String view(Model model,@PathVariable Long companyId,@PathVariable Integer type) {
		model.addAttribute("isAdd",false);
		SysCompany sysCompany = sysCompanyService.get(companyId);
		model.addAttribute("company", sysCompany);
		Map<String,Object> map = Maps.newHashMap();
		map.put("companyId", sysCompany.getId());
		//查询关联产品
		List<Map<String,Object>> insProlist = sysCompanyService.getInsProductMap(map);
		model.addAttribute("insProlist",insProlist);
		map.clear();
		map.put("company_id", sysCompany.getId());
		//查询关联联系人
		List<SysCompanyContacts> contactsList = sysCompanyContactsService.selectByMap(map);
		model.addAttribute("contactsList",contactsList);
		return getUrl(type, "add");
	}

	/**
	 * POST 创建或修改机构
	 * @return
	 */
	@RequiresPermissions(value={"syscompany:list:add:supplier",
								"syscompany:list:add:terminal",
								"syscompany:list:add:distributor",
								"syscompany:list:add:resource",
								"syscompany:list:edit:resource",
								"syscompany:list:edit:supplier",
								"syscompany:list:edit:terminal",
								"syscompany:list:edit:distributor"},logical=Logical.OR)
	@RequestMapping(value = "/list/save")
	@ResponseBody
	public AjaxResult update(@ModelAttribute("syscompany") SysCompany sysCompany){
		if(sysCompany.getId()==null){
			return saveSysCompanyByIdIsNull(sysCompany);
		}else{
			return updateSysCompanyByIdIsNotNull(sysCompany);
		}
	}

	/**
	 * <b> 修改机构 </b>
	 * @author ZXF
	 * @create 2020/09/14 0014 17:03
	 * @version
	 * @注意事项 </b>
	 */
	private AjaxResult updateSysCompanyByIdIsNotNull(@ModelAttribute("syscompany") SysCompany sysCompany) {
		sysCompanyService.save(sysCompany);
		if(null!=sysCompany.getContactsList()&&sysCompany.getContactsList().size()>0){
            List<SysCompanyContacts> list = Lists.newArrayList();
            for(SysCompanyContacts s:sysCompany.getContactsList()){
                s.setSysCompany(sysCompany);
                sysCompanyContactsService.save(s);
            }
        }
		if(null!=sysCompany.getSysCompanyTerminalContacts()){
            SysCompanyTerminalContacts s = sysCompany.getSysCompanyTerminalContacts();
            s.setSysCompany(sysCompany);
            sysCompanyTerminalContactsService.save(s);
        }
		if(null != sysCompany.getSysCompanyChannelContacts()){
            SysCompanyChannelContacts s = sysCompany.getSysCompanyChannelContacts();
            s.setSysCompany(sysCompany);
            sysCompanyChannelContactsService.save(s);
        }
		//清空缓存
		SysUserUtils.removeCache(sysCompany.getParentIds()+ SysCompanyService.CACHE_OFFICE_PARENT_LIST);
		return success(true, "修改成功!");
	}

	/**
	 * <b> 创建机构 </b>
	 * @author ZXF
	 * @create 2020/09/14 0014 17:02
	 * @version
	 * @注意事项 </b>
	 */
	private AjaxResult saveSysCompanyByIdIsNull(@ModelAttribute("syscompany") SysCompany sysCompany) {
		sysCompanyService.save(sysCompany);
		if(null!=sysCompany.getContactsList()&&sysCompany.getContactsList().size()>0){
            List<SysCompanyContacts> list = Lists.newArrayList();
            for(SysCompanyContacts s:sysCompany.getContactsList()){
                s.setSysCompany(sysCompany);
                list.add(s);
            }
            sysCompanyContactsService.insertBatch(list);
        }
		if(null!=sysCompany.getSysCompanyTerminalContacts()){
            SysCompanyTerminalContacts s = sysCompany.getSysCompanyTerminalContacts();
            s.setSysCompany(sysCompany);
            sysCompanyTerminalContactsService.save(s);
        }
		if(null != sysCompany.getSysCompanyChannelContacts()){
            SysCompanyChannelContacts s = sysCompany.getSysCompanyChannelContacts();
            s.setSysCompany(sysCompany);
            sysCompanyChannelContactsService.save(s);
        }
		return success(true, "创建成功!");
	}

	/**
	 * 跳转到  终端用户提升为分销商  资料补全页面
	 * @param model
	 * @return
	 */
	@RequiresPermissions("syscompany:list:promote:terminal")
	@RequestMapping(value = "/upToDistributorPage")
	public String upToDistributorPage(Model model) {
		String terminalId = getParameter("terminalId");
		String companyName = getParameter("companyName");
		model.addAttribute("terminalId",terminalId);
		model.addAttribute("companyName",companyName);
		return SYSTEM_COMPANY_TERMINAL_TO_DISTRIBUTOR;
	}

	/**
	 * 将终端用户提升为分销商
	 * @param sysCompany
	 * @return
	 */
	@RequiresPermissions("syscompany:list:promote:terminal")
	@ResponseBody
	@RequestMapping(value = "/upToDistributor")
	public AjaxResult upToDistributor(@ModelAttribute("syscompany") SysCompany sysCompany){
		String terminalId = sysCompany.getRelateToTerminal();
		String level = sysCompany.getDistributionLevel();
		if(StringUtils.isNotEmpty(level) && ConstProp.DIGIT_ONE.equals(level)){
			sysCompany.setParent(new SysCompany(Long.parseLong(ConstProp.DIGIT_ZERO)));
		}
		sysCompanyService.save(sysCompany);
		if(null!=sysCompany.getContactsList()&&sysCompany.getContactsList().size()>ConstProp.INT_NUMBER_ZERO){
			List<SysCompanyContacts> list = Lists.newArrayList();
			for(SysCompanyContacts s:sysCompany.getContactsList()){
				s.setSysCompany(sysCompany);
				list.add(s);
			}
			sysCompanyContactsService.insertBatch(list);
		}
		SysUserUtils.removeCache(SysCompanyService.CACHE_OFFICE_LIST);
		Long accountId = Long.parseLong(terminalId);
		//原终端用户状态设置为失效
		Integer status = Integer.valueOf(ConstProp.DIGIT_ZERO);
		sysCompanyService.updateById(new SysCompany(accountId,status));
		return success(true, "提升为分销商成功!");
	}

	/**
	 * 
	 * @param extId 排除的编号，不能选择的编号
	 * @param type 机构类型
	 * @param grade 机构等级
	 * @param isAll 是否列出全部数据
	 * @param parentId  父级id
	 * @param response
	 * @return
	 */
	@RequiresPermissions("user")
	@ResponseBody
	@RequestMapping(value = "treeData")
	public List<Map<String, Object>> treeData(@RequestParam(required=false) String extId, @RequestParam(required=false) String type,
			@RequestParam(required=false) Long grade, @RequestParam(required=false) Boolean isAll,@RequestParam(required=false) Long parentId, HttpServletResponse response) {
		List<Map<String, Object>> mapList = Lists.newArrayList();
		List<SysCompany> list = sysCompanyService.findList(isAll,parentId);
		for (SysCompany e :list){
			if ((StrUtil.isBlank(extId) || (extId!=null && !extId.equals(e.getId()) && e.getParentIds().indexOf(","+extId+",")==-1))
					&& (grade == null || (grade != null && Integer.parseInt(e.getGrade()) <= grade.intValue()))
					&& GlobalConstants.YES.equals(e.getStatus())){
				Map<String, Object> map = Maps.newHashMap();
				map.put("id", e.getId());
				map.put("pId", e.getParentId());
				map.put("pIds", e.getParentIds());
				map.put("name", e.getCompanyName());
				if (type != null && "3".equals(type)){
					map.put("isParent", true);
				}
				mapList.add(map);
			}
		}
		return mapList;
	}
	
	@RequestMapping(value = "/upload")  
	@ResponseBody
	public AjaxResult uploadHeadPortrait(MultipartFile file){
		SysUser user = SysUserUtils.getUser();
        String fileName = UploadFileUtils.rename(file);
        String path=GlobalConstants.getUserFlie()+File.separator+user.getId().toString()+File.separator+"logo";
        File targetFile = new File(path, fileName);  
        if(!targetFile.exists()){  
            targetFile.mkdirs();  
        }  
        //保存  
        try {  
            file.transferTo(targetFile);  
        } catch (Exception e) {  
            e.printStackTrace();  
        }  
        return json(true,user.getId().toString()+"/logo/"+fileName);
	}
	/**
	 *  创建用户页面
	 * @return
	 */
	@RequiresPermissions(value = {"syscompany:list:addUser:supplier",
								  "syscompany:list:addUser:terminal",
			   					  "syscompany:list:addUser:distributor",
			                      "syscompany:list:addUser:resource"
			},logical=Logical.OR)
	@RequestMapping(value = "/list/addUser")
	public String addUser(Model model) {
		List<SysRole> sysRoles = sysRoleService.selectRoleList();
		String companyId = this.getParameter("companyId");
		SysUser user = sysUserService.selectOne(new EntityWrapper<SysUser>().addFilter("company_id={0}",companyId));
		if (null!=user) {
			List<SysUserRole> sysRoleList = sysUserRoleService.selectRoleListByAccountId(user.getId());
			model.addAttribute("sysRoleList", sysRoleList);//分配角色
		}else {
			if (StrUtil.isNotBlank(companyId)) {
				user = new SysUser(new SysCompany(Long.parseLong(companyId)));
			}
		}
		model.addAttribute("sysUser", user);
		model.addAttribute("showPower","showPower");
		model.addAttribute("sysRoles", sysRoles);
		return SYSTEM_USER_ADDUSER;
	}

	/**
	 * 打开用户列表创建用户
	 * @return
	 */
	@RequiresPermissions(value = {"syscompany:list:addUser:distributor",
			                      "syscompany:list:addUser:terminal",
								  "syscompany:list:addUser:supplier",
			                      "syscompany:list:addUser:resource"
					},logical=Logical.OR)
	@RequestMapping(value = "/list/openUserList")
	public String openUserList(Model model){
		String companyId = this.getParameter("companyId");
		List<SysUser> list = sysUserService.selectList(new EntityWrapper<SysUser>().addFilter("company_id={0}",companyId));
		model.addAttribute("sysUsers", list);// 用户列表
		model.addAttribute("companyId", companyId);
		return SYSTEM_USER_LISTUSER;
	}

	/**
	 * 获取跳转的URL
	 * @param
	 * @param type  访问类型
	 * @return
	 */
	private String getUrl(Integer companyType,String type){
		if("list".equals(type)){
			return checkUrlTYpeList(companyType);
		}else{
			return checkURlAdd(companyType);
		}
	}
	/**
	 * 获取url 列表
	 * @param type
	 * @return
	 */
	private String checkUrlTYpeList(Integer type){
		if(SysCompany.COMPANY_TYPE_DISTRIBUTOR.equals(type)){
			return SYSTEM_COMPANY_DISTRIBUTOR_LIST;
		}else if(SysCompany.COMPANY_TYPE_SUPPLIER.equals(type)){
			return SYSTEM_COMPANY_SUPPLIER_LIST;
		}else if(SysCompany.COMPANY_TYPE_TERMINAL.equals(type)){
			return SYSTEM_COMPANY_TERMINAL_LIST;
		}else if(SysCompany.COMPANY_TYPE_CHANNEL.equals(type)){
			return SYSTEM_COMPANY_CHANNEL_LIST;
		}else{
			return "common/404";
		}
	}
	/**
	 * 列表URL add页面
	 * @return
	 */
	private String  checkURlAdd(Integer type){
		if(SysCompany.COMPANY_TYPE_DISTRIBUTOR.equals(type)){
			return SYSTEM_COMPANY_DISTRIBUTOR_ADD;
		}else if(SysCompany.COMPANY_TYPE_SUPPLIER.equals(type)){
			return SYSTEM_COMPANY_SUPPLIER_ADD;
		}else if(SysCompany.COMPANY_TYPE_SUPPLIER_VIEW.equals(type)){
			return SYSTEM_COMPANY_SUPPLIER_VIEW;
		}else if(SysCompany.COMPANY_TYPE_CHANNEL.equals(type)){
			return SYSTEM_COMPANY_CHANNEL_ADD;
		}else{
			return "common/404";
		}
	}

	/** 供应商列表  */
	private static final String SYSTEM_COMPANY_SUPPLIER_LIST = getViewPath("admin/system/system_company_supplier_list");
	/** 供应商form */
	private static final String SYSTEM_COMPANY_SUPPLIER_ADD = getViewPath("admin/system/system_company_supplier_add");
	/** 资源方添加页面 */
	private static final String SYSTEM_COMPANY_CHANNEL_ADD = getViewPath("admin/system/system_company_channel_add");
	/** 供应商查看 */
	private static final String SYSTEM_COMPANY_SUPPLIER_VIEW = getViewPath("admin/system/system_company_supplier_view");
	
	/** 终端用户列表  */
	private static final String SYSTEM_COMPANY_TERMINAL_LIST = getViewPath("admin/system/system_company_terminal_list");
	/** 资源方列表  */
	private static final String SYSTEM_COMPANY_CHANNEL_LIST = getViewPath("admin/system/system_company_channel_list");
	/** 资源方列表  */
	private static final String SYSTEM_COMPANY_CHANNEL_VIEW = getViewPath("admin/system/system_company_channel_view");
	/** 终端企业用户form列表 */
	private static final String SYSTEM_COMPANY_TERMINAL_BUSINESS_ADD = getViewPath("admin/system/system_company_terminal_business_add");
	/** 终端个人用户form列表 */
	private static final String SYSTEM_COMPANY_TERMINAL_PERSONAL_ADD = getViewPath("admin/system/system_company_terminal_personal_add");
	/** 终端企业用户查看 */
	private static final String SYSTEM_COMPANY_TERMINAL_BUSINESS_VIEW = getViewPath("admin/system/system_company_terminal_business_view");
	/** 终端个人用户查看 */
	private static final String SYSTEM_COMPANY_TERMINAL_PERSONAL_VIEW = getViewPath("admin/system/system_company_terminal_personal_view");
	/** 终端用户提升为分销商资料补全页面 */
	private static final String SYSTEM_COMPANY_TERMINAL_TO_DISTRIBUTOR = getViewPath("admin/system/system_company_terminal_to_distributor");

	/** 分销商列表  */
	private static final String SYSTEM_COMPANY_DISTRIBUTOR_LIST = getViewPath("admin/system/system_company_distributor_list");
	/** 分销商form */
	private static final String SYSTEM_COMPANY_DISTRIBUTOR_ADD = getViewPath("admin/system/system_company_distributor_add");
	/** 查看所选的分销商 */
	private static final String SYSTEM_COMPANY_DISTRIBUTOR_VIEW = getViewPath("admin/system/system_company_distributor_view");

	/** 创建或者修改用户界面 */
	private static final String SYSTEM_USER_ADDUSER = getViewPath("admin/system/system_user_add");
	/** 用户list界面 */
	private static final String SYSTEM_USER_LISTUSER = getViewPath("admin/system/system_companyuser_list");
}