package com.bcxin.ins.models.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.service.MyUtilService;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.entity.product_core.ProClauses;
import com.bcxin.ins.models.pro.service.*;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * Created by Apple on 2017/6/12.
 */
@Controller
@RequestMapping("${apiPath}/mypro")
@Lazy(false)
public class ProAPIController extends BaseController {

    /**信用险详情*/
    private static final String PRO_DETAIL_CREDIT = getViewPath("admin/pro/pro_detail_credit");
    /**责任险详情*/
    private static final String PRO_DETAIL_RESPONSIBILITY = getViewPath("admin/pro/pro_detail_responsibility");
    /**保证险详情*/
    private static final String PRO_DETAIL_ENSURE = getViewPath("admin/pro/pro_detail_ensure");
    /**人身险详情*/
    private static final String PRO_DETAIL_PERSON = getViewPath("admin/pro/pro_detail_person");
    /**选择地区界面*/
    private static final String PRO_AREA_PICKER = getViewPath("admin/pro/pro_area_picker");
    /** 发现错误*/
    private static final String ERROR = getViewPath("common/error");

    @Autowired
    private MyProService proS;
    @Autowired
    private ProDangerLevelService proDangerLevelService;
    @Autowired
    private ProProfessionService proProfessionService;
    @Autowired
    private ProRtSellRegionService proRtSellRegionService;
    @Autowired
    private ProRtProtectAreaService proRtProtectAreaService;
    @Autowired
    private ProRtProfessionService proRtProfessionService;
    @Autowired
    private ProClausesService proClausesService;
    @Autowired
    private ProCategoryService proCategoryService;
    @Autowired
    private MyUtilService utilS;

    //@RequiresPermissions("mysysuser:win/list)
    @RequestMapping(value = "/win/dml")
    public String winDml(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req) {
        // 参数说明，mark ("add"/"upd") category_id 18位longID  产品ID pro_primary_id 新增还是删除都要传
        if(!CTLUtil.pNotNull(params,"pro_primary_id","pro_category_id")){
            model.addAttribute("prompt","必要参数确实");
            return ERROR;
        }

        //TODO 字典信息加载，后面在再做成动态的
//        params.put("type","ownedIndustry");
//        model.addAttribute("ownedIndustry",utilS.dict(params));

        //判断是新增还是修改，并标记
        List<Map<Object,Object>> row  = proS.queryProByID(params);
        if(row.size()==0){
            model.addAttribute("mark","add");
        }else{
            Map<String,Object> m = Maps.newHashMap();
            m.put("pro_primary_id",params.get("pro_primary_id"));
            String sell_region = JSON.toJSONString(proRtSellRegionService.selectByMap(m));
            String protect_area = JSON.toJSONString(proRtProtectAreaService.selectByMap(m));
            model.addAttribute("sell_region", "".equals(sell_region.trim())?"[]":sell_region);
            model.addAttribute("protect_area","".equals(protect_area.trim())?"[]":protect_area);
            model.addAttribute("mark","upd");
            model.addAttribute("row",row.get(0));
        }

        model.addAttribute("detail",params.get("detail"));
        model.addAttribute("pro_primary_id",params.get("pro_primary_id"));//必填参数
        Map<Object,Object> categoryMap  = proS.queryTopParent(params);
        // 参数说明，mark ("add"/"upd")
        if("814363399244214272".equals(String.valueOf(categoryMap.get("pro_category_id")))){ //信用保险
            //http://localhost:8080/api/mypro/win/dml?pro_category_id=814363399244214272&pro_primary_id=814363399244214270
            return PRO_DETAIL_CREDIT;
        }
        if("814363404969439232".equals(String.valueOf(categoryMap.get("pro_category_id")))){ //人身保险
            //http://localhost:8080/api/mypro/win/dml?pro_category_id=814363404969439232&pro_primary_id=814363399244214270
            return PRO_DETAIL_PERSON;
        }
        if("814363396589219840".equals(String.valueOf(categoryMap.get("pro_category_id")))){ //保证保险
            //http://localhost:8080/api/mypro/win/dml?pro_category_id=814363396589219840&pro_primary_id=814363399244214270
            return PRO_DETAIL_ENSURE;
        }
        if("814363400192126976".equals(String.valueOf(categoryMap.get("pro_category_id")))){ //责任保险
            //http://localhost:8080/api/mypro/win/dml?pro_category_id=814363400192126976&pro_primary_id=814363399244214270
            return PRO_DETAIL_RESPONSIBILITY;
        }
        model.addAttribute("prompt","该产品的分类ID不属于：信用保险、人身保险、保证保险、责任保险");
        return ERROR;
    }


    @RequestMapping(value = "/win/china/picker")
    public String winChinaSelect(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req) {
        response.setHeader("Access-Control-Allow-Origin", "*");        model.addAttribute("p",params);
        model.addAttribute("mark","china");
        return PRO_AREA_PICKER;
    }
    @RequestMapping(value = "/win/world/picker")
    public String winWorldSelect(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        model.addAttribute("p",params);
        model.addAttribute("mark","world");
        return PRO_AREA_PICKER;
    }

    @RequestMapping(value = "/area/tree/list")
    public @ResponseBody Object areaTreeList(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        return utilS.areaTreeList(params);
    }

    /**
     * 职业分类字典查询
     */
    @RequestMapping(value = "/dict/profession/category")
    public @ResponseBody Object dictProfessionCategory(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        Map<String,Object> p = Maps.newHashMap();
        return proProfessionService.selectByMap(p);
    }

    /**
     * 危险等级，某个产品的
     */
    @RequestMapping(value = "/dangerlevel")
    public @ResponseBody Object dangerlevel(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        Map<String,Object> p = Maps.newHashMap();
        p.put("pro_primary_id",params.get("pro_primary_id"));
        return proDangerLevelService.selectByMap(p);
    }

    /**
     * 危险等级，某个产品，新增
     */
    @RequestMapping(value = "/dangerlevel/add")
    public @ResponseBody Object dangerLevelAdd(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        return proDangerLevelService.add(params);
    }

    /**
     * 危险等级，某个产品，修改
     */
    @RequestMapping(value = "/dangerlevel/upd")
    public @ResponseBody Object dangerLevelUpd(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        return proDangerLevelService.upd(params);
    }

    /**
     * 危险等级，某个产品，删除
     */
    @RequestMapping(value = "/dangerlevel/del")
    public @ResponseBody Object dangerLevelDel(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        return proDangerLevelService.del(params);
    }

    /**
     * 获得某个产品的，条款列表
     */
    @RequestMapping(value = "/clauseslist")
    public @ResponseBody Object clauseslist(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        return proClausesService.getClausesByProID(params);
    }

    /**
     * 获得某个产品的，条款列表
     */
    @RequestMapping(value = "/clauses")
    public  Object clauses(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp)  throws Exception {
        response.setHeader("Access-Control-Allow-Origin", "*");
        Map<String,Object> p = Maps.newHashMap();
        p.put("pro_clauses_id",params.get("pro_clauses_id"));
        List<ProClauses> l  = proClausesService.selectByMap(p);
        resp.getOutputStream().write(l.get(0).getClauses_file());
        return null;
    }

    /**
     * 职业分类，某个产品的
     */
    @RequestMapping(value = "/rtprofession/category")
    public @ResponseBody Object rtprofessionCategory(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req) {
        Map<String,Object> p = Maps.newHashMap();
        p.put("pro_primary_id",params.get("pro_primary_id"));
        response.setHeader("Access-Control-Allow-Origin", "*");
        return proRtProfessionService.selectByMap(p);
    }

    /**
     * 职业分类，某个产品的
     */
    @RequestMapping(value = "/pro/category")
    public @ResponseBody Object proCategory(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        return proCategoryService.selectList(null);
    }

    @RequestMapping(value = "/add")
    public @ResponseBody Object add(Model model, @RequestParam Map<Object,Object> params , @RequestParam("insurance_clauses") CommonsMultipartFile[] files, HttpServletRequest req) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        R r = proS.addPro(CTLUtil.init(req, params), files);
        CTLUtil.out2(r,response);
        return null;
    }

    @RequestMapping(value = "/upd")
    public @ResponseBody Object upd(Model model, @RequestParam Map<Object,Object> params , @RequestParam("insurance_clauses") CommonsMultipartFile[] files, HttpServletRequest req) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        R r = proS.updPro(CTLUtil.init(req, params), files);
        CTLUtil.out2(r,response);
        return null;
    }

}
