package com.bcxin.ins.models.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.service.MySysClientCompanyService;
import com.bcxin.ins.core.service.MySysClientUserService;
import com.bcxin.ins.core.service.MySysUserService;
import com.bcxin.ins.core.service.MyUtilService;
import com.bcxin.ins.core.util.CTLUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 类名称：SysUserController
 * 类描述：系统管理员控制器
 * 创建人:liujinju
 * @version
 */
@Controller
@RequestMapping("${systemPath}/myclientuser")
public class MySysClientUserController extends BaseController {

	/** 列表 */
	private static final String LIST = getViewPath("admin/clientuser/client_user_list");
	/**  企业用户新增和修改 */
	private static final String ADD_PERSON = getViewPath("admin/clientuser/client_user_add_person");
	/** 个人用户新增和修改 */
	private static final String ADD_COMPANY = getViewPath("admin/clientuser/client_user_add_company");
	/** 详情页面包含个人和企业信息 */
	private static final String DETAIL = getViewPath("admin/clientuser/client_user_add_detail");

	/** 没有service的control会时效！！！*/
	@Autowired
	private MySysClientUserService cuserS;
	@Autowired
	private MySysClientCompanyService companyS;
	@Autowired
	private MyUtilService utilS;

	/**用户列表*/
	@RequiresPermissions("myclientuser:win:list")
	@RequestMapping(value = "/win/list")
	public String winList(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		return LIST;
	}

	/**个人修改窗口*/
	@RequiresPermissions("myclientuser:win:list")
	@RequestMapping(value = "/win/person/upd")
	public String winPersonUpd(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		//TODO 个人和企业的信息查询
		model.addAttribute("row",cuserS.selectById(Long.valueOf(String.valueOf(params.get("sys_client_user_id")))));
		model.addAttribute("mark","upd");
		return ADD_PERSON;
	}

	/**个人新增窗口*/
	@RequiresPermissions("myclientuser:win:list")
	@RequestMapping(value = "/win/person/add")
	public String winPersonAdd(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		model.addAttribute("mark","add");
		return ADD_PERSON;
	}

	/**企业修改窗口*/
	@RequiresPermissions("myclientuser:win:list")
	@RequestMapping(value = "/win/company/upd")
	public String winCompanyUpd(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		//TODO 个人和企业的信息查询
		model.addAttribute("row",companyS.selectById(Long.valueOf(String.valueOf(params.get("sys_client_company_id")))));
		model.addAttribute("mark","upd");
		return ADD_COMPANY;
	}

	/**企业新增窗口*/
	@RequiresPermissions("myclientuser:win:list")
	@RequestMapping(value = "/win/company/add")
	public String winCompnayAdd(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		model.addAttribute("mark","add");
		return ADD_COMPANY;
	}
	/**企业新增窗口*/
	@RequiresPermissions("myclientuser:win:list")
	@RequestMapping(value = "/win/detail")
	public String detail(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		model.addAttribute("row",cuserS.selectByUserID(params));
		return DETAIL;
	}

	/**省市县三级联动*/
	@RequestMapping(value = "/detail/json")
	public @ResponseBody Object detailJson(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		return cuserS.selectByUserID(params);
	}

	/**省市县三级联动*/
	@RequestMapping(value = "/district")
	public @ResponseBody Object district(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		model.addAttribute("mark","add");
		return utilS.getArea(params);
	}

	/**查询公司*/
	@RequestMapping(value = "/company")
	public @ResponseBody Object company(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		return cuserS.getCompany(params);
	}
	/**查询国籍*/
	@RequestMapping(value = "/tpos_area")
	public @ResponseBody Object tposArea(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		return cuserS.getCountryCodeList(params);
	}

	/**分页查询用户*/
	@RequiresPermissions("myclientuser:win:list")
	@RequestMapping(value = "/query" , method = RequestMethod.POST)
	public @ResponseBody Object query(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(cuserS.query(p),resp); return null;
	}

	/**新增个人*/
	@RequiresPermissions("myclientuser:person:audit")
	@RequestMapping(value = "/person/audit")
	public @ResponseBody Object personAudit(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return cuserS.personUpd(p);
	}

	/**新增个人*/
	@RequiresPermissions("myclientuser:person:add")
	@RequestMapping(value = "/person/add")
	public @ResponseBody Object personAdd(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return cuserS.personAdd(p);
	}
	/**修改个人*/
	@RequiresPermissions("myclientuser:person:upd")
	@RequestMapping(value = "/person/upd")
	public @ResponseBody Object personUpd(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return cuserS.personUpd(p);
	}
	/**新增机构*/
	@RequiresPermissions("myclientuser:company:add")
	@RequestMapping(value = "/company/add")
	public @ResponseBody Object companyAdd(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return cuserS.companyAdd(p);
	}
	/**修改机构*/
	@RequiresPermissions("myclientuser:company:upd")
	@RequestMapping(value = "/company/upd")
	public @ResponseBody Object companyUpd(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return cuserS.companyUpd(p);
	}




}