package com.bcxin.ins.models.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.models.apply.service.ComTaskUnSeeFeeRecordService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 未见费出单保单信息记录控制器
 * @version
 */
@Controller
@RequestMapping("${systemPath}/unseefee")
public class ComTaskUnSeeFeeRecordController extends BaseController {

	/**待处理未见费保单列表*/
	private static final String UNSEEFEE_LIST = getViewPath("admin/unseefee/unseefee_list");


	@Autowired
	private ComTaskUnSeeFeeRecordService ctrS;

	/**待处理未见费保单列表*/
	@RequiresPermissions("unseefee:win:list")
	@RequestMapping(value = "/win/list")
	public String winList(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		return UNSEEFEE_LIST;
	}

	/**待处理未见费保单列表分页*/
	@RequiresPermissions("unseefee:win:list")
	@RequestMapping(value = "/query" , method = RequestMethod.POST)
	public @ResponseBody Object query(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(ctrS.query(params),resp); return null;
	}

}